/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_param_test_tests.c
 * @brief		iutest parameter test test
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2013, Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/

/* include ===========================================================*/
#include "../include/iutest_c.h"
#include <assert.h>

IUTEST_C_WORKSPACE();

#if IUTEST_C_HAS_PARAM_TEST

IUTEST_INSTANTIATE_TEST_CASE_P(int, A, TestP, iuValues, 0, 1, 2, 3 );
IUTEST_INSTANTIATE_TEST_CASE_P(int, B, TestP, iuRange, 0, 11);
IUTEST_INSTANTIATE_TEST_CASE_P(int, C, TestP, iuStepRange, 0, 11, 2);

#if defined(__GNUC__)
IUTEST_INSTANTIATE_TEST_CASE_P(int, D, TestP, iuRange, 0, 11, 2);
#endif

IUTEST_P(int, TestP, Test)
{
	const int x = param;
	const int kMax = 11;
	IUTEST_ASSERT_LT(x, kMax);
	iuConsole_Output("%d\n", x);
}

IUTEST_P(int, TestP, Test2)
{
	const int x = param;
	const int kMax = 11;
	IUTEST_ASSERT_LT(x, kMax);
	iuConsole_Output("%d\n", x);
}

#endif

#ifdef UNICODE
int wmain(int argc, wchar_t* argv[])
#else
int main(int argc, char* argv[])
#endif
{
	IUTEST_INIT(&argc, argv);
	{
		int ret = IUTEST_RUN_ALL_TESTS();
		if( ret != 0 ) return 1;
	}
#if IUTEST_C_HAS_PARAM_TEST
#if defined(__GNUC__)
	assert( iuUnitTest_GetTotalTestCaseCount(iuUnitTest_GetInstance()) == (4+11+6+6) );
	assert( iuUnitTest_GetTotalTestCount(iuUnitTest_GetInstance()) == (4+11+6+6)*2 );
#else
	assert( iuUnitTest_GetTotalTestCaseCount(iuUnitTest_GetInstance()) == (4+11+6) );
	assert( iuUnitTest_GetTotalTestCount(iuUnitTest_GetInstance()) == (4+11+6)*2 );
#endif
#endif
	
	printf("*** Successful ***\n");
	return 0;
}


