/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_params_util_c.h
 * @brief		iris unit test parameter eXgp util t@C
 *
 * @author		t.sirayanagi
 * @par			copyright
 * Copyright (C) 2013-2014, Takazumi Shirayanagi\n
 * This software is released under the new BSD License,
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_IUTEST_PARAMS_UTIL_C_H_4B4332BA_2300_416B_A1EE_004BC08A627E_
#define INCG_IRIS_IUTEST_PARAMS_UTIL_C_H_4B4332BA_2300_416B_A1EE_004BC08A627E_

/* include ===========================================================*/
#include "../iutest_defs_c.h"

#if IUTEST_C_HAS_PARAM_TEST

/* define ============================================================*/
/** @private */
#define iuTestParamHolder_ctor(testcase_name_, testcases_, params)	{	\
	NULL, IUTEST_PP_TOSTRING(testcase_name_), testcases_, params		\
	, sizeof(params[0]), IUTEST_PP_COUNTOF(params), NULL }

/* struct ============================================================*/
/**
 * @brief	ParameterHolder
*/
typedef struct iuTestParamHolder_t
{
	const char**	testcase_names;		/*!< eXgP[X */
	const char*		testcase_base_name;	/*!< eXgP[X */
	iuTestCase*		testcases;			/*!< o^peXgP[Xz */
	void*			params;				/*!< p[^z */
	size_t			align;				/*!< p[^ACg */
	size_t			elem;				/*!< p[^ */
	struct iuTestParamHolder_t	*next;	/*!<  iuTestParamHolder ̃m[h */
} iuTestParamHolder;

#endif	/* IUTEST_C_HAS_PARAM_TEST */

#endif
