/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_env_c.h
 * @brief		iris unit test environment
 *
 * @author		t.sirayanagi
 * @par			copyright
 * Copyright (C) 2012-2014, Takazumi Shirayanagi\n
 * This software is released under the new BSD License,
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_IUTEST_ENV_C_H_DC5C5193_7081_4FEF_B668_283CAEFA1F77_
#define INCG_IRIS_IUTEST_ENV_C_H_DC5C5193_7081_4FEF_B668_283CAEFA1F77_

/* include ===========================================================*/
#include "iutest_listener_c.h"
#include "internal/iutest_random_c.h"
#include "internal/iutest_string_c.h"

IUTEST_EXTERN_C_BEGIN()

/* define ============================================================*/
/**
 * @private
 * @{
*/
#define IIUT_C_TESTENV_NAME		g_iutest_c_testenv_instance
#define IIUT_C_TESTENV()		IIUT_C_TESTENV_NAME
/**
 * @}
*/

#define IUTEST_FLAG(name)		IIUT_C_TESTENV().option.name

/* enum ==============================================================*/
typedef enum IUTESTENV_FLAG
{
	IUTESTENV_CONSOLECOLOR_ON		= 0x0010,	/*!< FoON */
	IUTESTENV_CONSOLECOLOR_OFF		= 0x0020,	/*!< FoOFF */
	IUTESTENV_CONSOLECOLOR_ANSI		= 0x0040,	/*!< GXP[vV[PXŏo */
	IUTESTENV_OUTPUT_XML_REPORT		= 0x0100,	/*!< xml o */
	IUTESTENV_SHOWHELP_AND_SORRY	= 0x0400,	/*!< wvo */
	IUTESTENV_SHOWHELP				= 0x0800,	/*!< wvo */
	IUTESTENV_SHOWVERSION			= 0x1000,	/*!< o[Wo */
	IUTESTENV_SHOWTESTSLIST			= 0x2000,	/*!< eXgXgo */
	IUTESTENV_SHOWFEATURE			= 0x4000,	/*!< @\o */
	IUTESTENV_SHOWMASK				= 0xFF00,	/*!< \n}XN */

	IUTESTENV_FLAG_DEFAULT			= 0
} IUTESTENV_FLAG;

/* declare ===========================================================*/
struct iuTestPartResult_t;

/* typedef ===========================================================*/
#if IUTEST_C_HAS_STDARG
typedef int (*iuVPrintf)(const char* fmt, va_list va);
#endif
typedef void (*iuGlobalEnvironmentSetUp)(void);
typedef void (*iuGlobalEnvironmentTearDown)(void);
typedef iuBOOL (*iuTestCommitTestPartResult)(struct iuTestPartResult_t* part_result, void* user);

/* struct ============================================================*/
/**
 * @brief	O[o SetUp \
*/
typedef struct iuTestGlobalEnvSetUp_t
{
	iuGlobalEnvironmentSetUp		func;	/*!< SetUp ֐ */
	struct iuTestGlobalEnvSetUp_t*	next;	/*!< ̍\ */
} iuTestGlobalEnvSetUp;

/**
 * @brief	O[o TearDown \
*/
typedef struct iuTestGlobalEnvTearDown_t
{
	iuGlobalEnvironmentTearDown			func;	/*!< TearDown ֐ */
	struct iuTestGlobalEnvTearDown_t*	next;	/*!< ̍\ */
} iuTestGlobalEnvTearDown;

/**
 * @brief	ʂ̓o^R[obN֐
*/
typedef struct iuTestCommitPartResultInfo_t
{
	iuTestCommitTestPartResult func;
	void* user;
} iuTestCommitPartResultInfo;

/**
 * @brief	eXg\
*/
typedef struct iuTestEnv_t
{
	iuTestListener*	listeners;		/*!< Xi[Xg */
	iuTestGlobalEnvSetUp*		env_setup;		/*!< O[o SetUp Xg */
	iuTestGlobalEnvTearDown*	env_teardown;	/*!< O[o TearDown Xg */
#if IUTEST_C_HAS_STDARG
	iuVPrintf		pfnvpritf;		/*!< vprintf ֐|C^ */
#endif
	iuUInt32		flag;			/*!< tO */
	iuUInt32		current_seed;	/*!< V[ȟݒl */
	iuRandomContext	random_context;	/*!< ReLXg */
	iuTestCommitPartResultInfo	commit_result;	/*!< eXgʂ̓o^R[obN֐ */

	/* IvV */
	struct {
		const char*		filter;			/*!< eXgtB^O */
		const char*		output;			/*!< o͕ */
		int				repeat;			/*!< s[gJEg */
		iuUInt32		random_seed;	/*!< V[h̐ݒl */
		iuBOOL			shuffle;		/*!< VbteXg */
		iuBOOL			print_time;		/*!< oߎԂ̏o */
		iuBOOL			break_on_failure;			/*!< eXgsɃu[N */
		iuBOOL			also_run_disabled_tests;	/*!< DISABLED eXgs */
	} option;
} iuTestEnv;

/* define ============================================================*/
/**
 * @private
 * @{
*/
#define iuTestEnvOption_ctor()	{ NULL, NULL, 1, 0, FALSE, TRUE, FALSE, FALSE }
#if IUTEST_C_HAS_STDARG
#define iuTestEnv_ctor()	{ NULL, NULL, NULL, NULL, IUTESTENV_FLAG_DEFAULT, 0		\
								, iuRandomContext_ctor(), { NULL, NULL }, iuTestEnvOption_ctor() }
#else
#define iuTestEnv_ctor()	{ NULL, NULL, NULL, IUTESTENV_FLAG_DEFAULT, 0		\
								, iuRandomContext_ctor(), { NULL, NULL }, iuTestEnvOption_ctor() }
#endif
/**
 * @}
*/

/* extern ============================================================*/
extern iuTestEnv	IIUT_C_TESTENV_NAME;

/* function ==========================================================*/
#if IUTEST_C_HAS_LIB
/**
 * @brief	eXgCX^X̎擾
*/
IUTEST_ATTRIBUTE_UNUSED_ iuTestEnv* iuTestEnv_GetInstance(void);

#if IUTEST_C_HAS_STDARG
/**
 * @brief	vprintf ֐|C^ݒ
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_SetVPrintfFunction(iuTestEnv* test_env, iuVPrintf proc);

#endif

/**
 * @brief	TestListener ̒ǉ
*/
IUTEST_ATTRIBUTE_UNUSED_ iuBOOL	iuTestEnv_AddTestListener(iuTestEnv* test_env, iuTestListener* test_listener);

/**
 * @brief	TestListener ̍폜
*/
IUTEST_ATTRIBUTE_UNUSED_ iuTestListener* iuTestEnv_SubTestListener(iuTestEnv* test_env, iuTestListener* test_listener);

/**
 * @brief	GlobalEnvironmentSetUp ̒ǉ
*/
IUTEST_ATTRIBUTE_UNUSED_ iuBOOL iuTestEnv_AddGlobalEnvironmentSetUp(iuTestEnv* test_env, iuGlobalEnvironmentSetUp func);

/**
 * @brief	GlobalEnvironmentTearDown ̒ǉ
*/
IUTEST_ATTRIBUTE_UNUSED_ iuBOOL iuTestEnv_AddGlobalEnvironmentTearDown(iuTestEnv* test_env, iuGlobalEnvironmentTearDown func);

/**
 * @brief	GlobalEnvironmentSetUp ̎s
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_GlobalEnvironmentSetUp(void);

/**
 * @brief	GlobalEnvironmentTearDown ̎s
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_GlobalEnvironmentTearDown(void);

/**
 * @brief	OnTestProgramStart
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnTestProgramStart(struct iuUnitTest_t* unit_test);

/**
 * @brief	OnTestIterationStart
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnTestIterationStart(struct iuUnitTest_t* unit_test, int iteration);

/**
 * @brief	OnEnvironmentsSetUpStart
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnEnvironmentsSetUpStart(struct iuUnitTest_t* unit_test);

/**
 * @brief	OnEnvironmentsSetUpEnd
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnEnvironmentsSetUpEnd(struct iuUnitTest_t* unit_test);

/**
 * @brief	OnTestCaseStart
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnTestCaseStart(struct iuTestCase_t* test_case);

/**
 * @brief	OnTestStart
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnTestStart(struct iuTestCase_t* test_case, struct iuTestInfo_t* test_info);

/**
 * @brief	OnTestPartResult
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnTestPartResult(struct iuTestPartResult_t* test_part_result);

/**
 * @brief	OnTestRecordProperty
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnTestRecordProperty(struct iuTestProperty_t* test_property);

/**
 * @brief	OnTestEnd
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnTestEnd(struct iuTestCase_t* test_case, struct iuTestInfo_t* test_info);

/**
 * @brief	OnTestCaseEnd
*/
IUTEST_ATTRIBUTE_UNUSED_ void IUTEST_ATTRIBUTE_UNUSED_ iuTestEnv_ListenerEvent_OnTestCaseEnd(struct iuTestCase_t* test_case);

/**
 * @brief	OnEnvironmentsTearDownStart
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnEnvironmentsTearDownStart(struct iuUnitTest_t* unit_test);

/**
 * @brief	OnEnvironmentsTearDownEnd
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnEnvironmentsTearDownEnd(struct iuUnitTest_t* unit_test);

/**
 * @brief	OnTestIterationEnd
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnTestIterationEnd(struct iuUnitTest_t* unit_test, int iteration);

/**
 * @brief	OnTestProgramEnd
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_ListenerEvent_OnTestProgramEnd(struct iuUnitTest_t* unit_test);

/**
 * @brief	eXg̃ZbgAbv
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTestEnv_SetUp(iuTestEnv* test_env);

/**
 * @brief	DISABLED eXgs邩ǂ
*/
IUTEST_ATTRIBUTE_UNUSED_ iuBOOL iuTestEnv_IsEnableRunDisabledTests(void);

/**
 * @brief	VbteXgǂ
*/
IUTEST_ATTRIBUTE_UNUSED_ iuBOOL iuTestEnv_IsEnableShuffleTests(void);

/**
 * @brief	eXgs BREAK 邩ǂ
*/
IUTEST_ATTRIBUTE_UNUSED_ iuBOOL iuTestEnv_IsEnableBreakOnFailure(void);

/**
 * @brief	ԏo͂邩ǂ
*/
iuBOOL iuTestEnv_IsEnablePrintTime(void);

/**
 * @biref	xml o͂邩ǂ
*/
iuBOOL iuTestEnv_IsEnableOutputXml(void);

/**
 * @brief	eXgtOLǂ
*/
iuBOOL iuTestEnv_IsEnableFlag(int mask);

/**
 * @brief	V[h̎擾
*/
IUTEST_ATTRIBUTE_UNUSED_ iuUInt32 iuTestEnve_GetCurrentRandomSeed(void);

#if IUTEST_C_HAS_COMMANDLINE_OPTION
/**
 * @brief	R}hC̉
*/
IUTEST_C_INL_INLINE void iuTestEnv_ParseCommandLineA(int* pargc, char** argv);

#if IUTEST_C_HAS_WCHAR_T
/**
 * @brief	R}hC̉
*/
IUTEST_C_INL_INLINE void iuTestEnv_ParseCommandLineW(int* pargc, wchar_t** argv);
#endif

#endif

#if IUTEST_C_HAS_ENVIRONMENTSVAR_OPTION

/**
 * @brief	ϐ̓ǂݎ
*/
void iuTestEnv_LoadEnviromentVariable(void);

#endif

#endif

#if !IUTEST_C_HAS_LIB
#  include "impl/iutest_env_c.inl"
#endif

IUTEST_EXTERN_C_END()

#endif
