﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_spi_tests.cpp
 * @brief		iutest spi test
 *
 * @author		t.shirayanagi
 * @par			copyright
 * Copyright (C) 2012-2014, Takazumi Shirayanagi\n
 * This software is released under the new BSD License,
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "../include/gtest/iutest_spi_switch.hpp"
#include "iutest_pred_tests.hpp"

namespace spitest
{

class SPITest : public ::iutest::Test
{
public:
#if IUTEST_HAS_SPI_LAMBDA_SUPPORT
	const char* null_str;
	int a, b;
	int  aa[5];
	int  ab[6];
	char ac[5];
	::std::string sa;
	::std::string sb;
	::std::string sa2;
	
	SPITest()
		: null_str(NULL)
		, a(0), b(0)
		, sa("a")
		, sb("b")
	{
		int  aa_[5] = { 0, 1, 2, 3, 4 };
		int  ab_[6] = { 0, 1, 2, 3, 4, 5 };
		char ac_[5] = { 0, 0, 2, 3, 5 };
		for( int i=0; i < 5; ++i )
		{
			aa[i] = aa_[i];
			ab[i] = ab_[i];
			ac[i] = ac_[i];
		}
		ab[5] = 5;
	}
#endif
	
public:
	void FatalFailure_Sub(int& count);
	void FatalFailure2_Sub(int& count);
};

#if !IUTEST_HAS_SPI_LAMBDA_SUPPORT
const char* null_str = NULL;
int a=0, b=0;
int  aa[] = { 0, 1, 2, 3, 4 };
int  ab[] = { 0, 1, 2, 3, 4, 5 };
char ac[] = { 0, 0, 2, 3, 5 };
::std::string sa="a";
::std::string sb="b";
#endif

void SPITest::FatalFailure_Sub(int& count)
{
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_TRUE(false), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_FALSE(true), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_NULL((void*)1), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_NOTNULL((void*)0), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_SAME(a, b), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_EQ(0, 1), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_NE(1, 1), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_LE(1, 0), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_LT(1, 0), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_GE(0, 1), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_GT(0, 1), "" );
#if !defined(IUTEST_USE_GTEST)
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_FLOAT_EQ(0, 1), "(0x" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_DOUBLE_EQ(0, 1), "(0x" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_FLOAT_EQ(0.0f/a, 0.0f/a), "(0x" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_DOUBLE_EQ(0.0/a, 0.0f/a), "(0x" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED_FORMAT2(::iutest::FloatLE , 2, 0), "(0x" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED_FORMAT2(::iutest::DoubleLE, 2, 0), "(0x" );
#else
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_FLOAT_EQ(0, 1), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_DOUBLE_EQ(0, 1), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_FLOAT_EQ(0.0f/a, 0.0f/a), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_DOUBLE_EQ(0.0/a, 0.0f/a), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED_FORMAT2(::iutest::FloatLE , 2, 0), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED_FORMAT2(::iutest::DoubleLE, 2, 0), "" );
#endif
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_NEAR(0, 100, 2), "" );

	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STREQ("A", "a"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STREQ("A", null_str), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STREQ(null_str, "a"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STREQ(sa, "A"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STREQ("A", sa), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STREQ(sa, sb), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STREQ(L"A", L"a"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRNE("a", "a"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRNE(null_str, null_str), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRNE(sa, "a"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRNE("a", sa), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRNE(sa, sa), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRNE(L"a", L"a"), "" );

	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ("b", "a"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ("b", null_str), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ(null_str, "a"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ(sa, "b"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ("b", sa), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ(sa, sb), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ(L"a", L"b"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE("a", "a"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE("A", "a"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE(null_str, null_str), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE(sa, "A"), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE("A", sa), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE(sa, sa), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE(L"A", L"a"), "" );

	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRIN("b", "a"), "strstr" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRIN("b", null_str), "strstr" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_STRIN(null_str, "a"), "strstr" );
	
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED1(IsOdd, 2), "evaluates to false, where" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED2(IsGreater, 0, 1), "evaluates to false, where" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED3(PredTest3, 0, 1, 3), "evaluates to false, where" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED4(PredTest4, 0, 1, 2, 4), "evaluates to false, where" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED5(PredTest5, 0, 1, 2, 3, 5), "evaluates to false, where" );
#if !defined(IUTEST_USE_GTEST) && !defined(IUTEST_NO_VARIADIC_MACROS) && IUTEST_HAS_VARIADIC_TEMPLATES
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_PRED(PredTest6, 0, 1, 2, 3, 4, 6), "evaluates to false, where" );
#endif

#if defined(IUTEST_OS_WINDOWS)
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_HRESULT_SUCCEEDED(-1), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_HRESULT_FAILED(0), "" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_HRESULT_FAILED(100), "" );
#endif
	
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_EQ_COLLECTIONS(aa, aa+(sizeof(aa)/sizeof(aa[0])), ab, ab+(sizeof(ab)/sizeof(ab[0]))), "Mismatch element" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_EQ_COLLECTIONS(ab, ab+(sizeof(ab)/sizeof(ab[0])), aa, aa+(sizeof(aa)/sizeof(aa[0]))), "Mismatch element" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_EQ_COLLECTIONS(aa, aa+(sizeof(aa)/sizeof(aa[0])), ac, ac+(sizeof(ac)/sizeof(ac[0]))), "Mismatch in a position" );

	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_EQ_RANGE(aa, ab), "Mismatch element" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_EQ_RANGE(ab, aa), "Mismatch element" );
	IUTEST_ASSERT_FATAL_FAILURE( IUTEST_ASSERT_EQ_RANGE(aa, ac), "Mismatch in a position" );

	count++;
}
	
IUTEST_F(SPITest, FatalFailure)
{
	int count=0;
#if IUTEST_HAS_EXCEPTIONS
	try {
		FatalFailure_Sub(count);
	} catch(...) {
	}
#else
	FatalFailure_Sub(count);
#endif
	IUTEST_ASSERT_EQ(1, count);
}

void SPITest::FatalFailure2_Sub(int& count)
{
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_TRUE(false), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_FALSE(true), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_NULL((void*)1), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_NOTNULL((void*)0), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_SAME(a, b), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_EQ(0, 1), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_NE(1, 1), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_LE(1, 0), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_LT(1, 0), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_GE(0, 1), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_GT(0, 1), "" );
#if !defined(IUTEST_USE_GTEST)
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_FLOAT_EQ(0, 1), "(0x" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_DOUBLE_EQ(0, 1), "(0x" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED_FORMAT2(::iutest::FloatLE , 2, 0), "(0x" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED_FORMAT2(::iutest::DoubleLE, 2, 0), "(0x" );
#else
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_FLOAT_EQ(0, 1), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_DOUBLE_EQ(0, 1), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED_FORMAT2(::iutest::FloatLE , 2, 0), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED_FORMAT2(::iutest::DoubleLE, 2, 0), "" );
#endif
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_NEAR(0, 100, 2), "" );

	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STREQ("A", "a"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STREQ("A", null_str), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STREQ(null_str, "a"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STREQ(sa, "A"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STREQ("A", sa), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STREQ(sa, sb), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STREQ(L"A", L"a"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRNE("a", "a"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRNE(null_str, null_str), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRNE(sa, "a"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRNE("a", sa), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRNE(sa, sa), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRNE(L"a", L"a"), "" );

	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ("b", "a"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ("b", null_str), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ(null_str, "a"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ(sa, "b"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ("b", sa), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ(sa, sb), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASEEQ(L"a", L"b"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE("a", "a"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE("A", "a"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE(null_str, null_str), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE(sa, "A"), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE("A", sa), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE(sa, sa), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRCASENE(L"A", L"a"), "" );

	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRIN("b", "a"), "strstr" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRIN("b", null_str), "strstr" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_STRIN(null_str, "a"), "strstr" );

	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED1(IsOdd, 2), "evaluates to false, where" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED2(IsGreater, 0, 1), "evaluates to false, where" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED3(PredTest3, 0, 1, 3), "evaluates to false, where" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED4(PredTest4, 0, 1, 2, 4), "evaluates to false, where" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED5(PredTest5, 0, 1, 2, 3, 5), "evaluates to false, where" );
#if !defined(IUTEST_USE_GTEST) && !defined(IUTEST_NO_VARIADIC_MACROS) && IUTEST_HAS_VARIADIC_TEMPLATES
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_PRED(PredTest6, 0, 1, 2, 3, 4, 6), "evaluates to false, where" );
#endif

#if defined(IUTEST_OS_WINDOWS)
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_HRESULT_SUCCEEDED(-1), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_HRESULT_FAILED(0), "" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_HRESULT_FAILED(100), "" );
#endif
	
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_EQ_COLLECTIONS(aa, aa+(sizeof(aa)/sizeof(aa[0])), ab, ab+(sizeof(ab)/sizeof(ab[0]))), "Mismatch element" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_EQ_COLLECTIONS(ab, ab+(sizeof(ab)/sizeof(ab[0])), aa, aa+(sizeof(aa)/sizeof(aa[0]))), "Mismatch element" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_EQ_COLLECTIONS(aa, aa+(sizeof(aa)/sizeof(aa[0])), ac, ac+(sizeof(ac)/sizeof(ac[0]))), "Mismatch in a position" );

	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_EQ_RANGE(aa, ab), "Mismatch element" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_EQ_RANGE(ab, aa), "Mismatch element" );
	IUTEST_EXPECT_FATAL_FAILURE( IUTEST_ASSERT_EQ_RANGE(aa, ac), "Mismatch in a position" );

	count++;
}
	
IUTEST_F(SPITest, FatalFailure2)
{
	int count=0;
#if IUTEST_HAS_EXCEPTIONS
	try {
		FatalFailure2_Sub(count);
	} catch(...) {
	}
#else
	FatalFailure2_Sub(count);
#endif
	IUTEST_ASSERT_EQ(1, count);
}

IUTEST_F(SPITest, NonFatalFailure)
{
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_TRUE(false), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_FALSE(true), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_NULL((void*)1), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_NOTNULL((void*)0), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_SAME(a, b), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ(0, 1), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_NE(1, 1), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_LE(1, 0), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_LT(1, 0), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_GE(0, 1), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_GT(0, 1), "" );
#if !defined(IUTEST_USE_GTEST)
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_FLOAT_EQ(0, 1), "(0x" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_DOUBLE_EQ(0, 1), "(0x" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED_FORMAT2(::iutest::FloatLE , 2, 0), "(0x" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED_FORMAT2(::iutest::DoubleLE, 2, 0), "(0x" );
#else
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_FLOAT_EQ(0, 1), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_DOUBLE_EQ(0, 1), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED_FORMAT2(::iutest::FloatLE , 2, 0), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED_FORMAT2(::iutest::DoubleLE, 2, 0), "" );
#endif
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_NEAR(0, 100, 2), "" );

	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ("A", "a"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ("A", null_str), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ(null_str, "a"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ(sa, "A"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ("A", sa), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ(sa, sb), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ(L"A", L"a"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE("a", "a"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE(null_str, null_str), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE(sa, "a"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE("a", sa), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE(sa, sa), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE(L"a", L"a"), "" );

	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ("b", "a"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ("b", null_str), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ(null_str, "a"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ(sa, "b"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ("b", sa), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ(sa, sb), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ(L"a", L"b"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE("a", "a"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE("A", "a"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE(null_str, null_str), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE(sa, "A"), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE("A", sa), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE(sa, sa), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE(L"A", L"a"), "" );

	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRIN("b", "a"), "strstr" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRIN("b", null_str), "strstr" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_STRIN(null_str, "a"), "strstr" );

	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED1(IsOdd, 2), "evaluates to false, where" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED2(IsGreater, 0, 1), "evaluates to false, where" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED3(PredTest3, 0, 1, 3), "evaluates to false, where" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED4(PredTest4, 0, 1, 2, 4), "evaluates to false, where" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED5(PredTest5, 0, 1, 2, 3, 5), "evaluates to false, where" );
#if !defined(IUTEST_USE_GTEST) && !defined(IUTEST_NO_VARIADIC_MACROS) && IUTEST_HAS_VARIADIC_TEMPLATES
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED(PredTest6, 0, 1, 2, 3, 4, 6), "evaluates to false, where" );
#endif

#if defined(IUTEST_OS_WINDOWS)
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_HRESULT_SUCCEEDED(-1), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_HRESULT_FAILED(0), "" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_HRESULT_FAILED(100), "" );
#endif

	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_COLLECTIONS(aa, aa+(sizeof(aa)/sizeof(aa[0])), ab, ab+(sizeof(ab)/sizeof(ab[0]))), "Mismatch element" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_COLLECTIONS(ab, ab+(sizeof(ab)/sizeof(ab[0])), aa, aa+(sizeof(aa)/sizeof(aa[0]))), "Mismatch element" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_COLLECTIONS(aa, aa+(sizeof(aa)/sizeof(aa[0])), ac, ac+(sizeof(ac)/sizeof(ac[0]))), "Mismatch in a position" );

	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_RANGE(aa, ab), "Mismatch element" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_RANGE(ab, aa), "Mismatch element" );
	IUTEST_ASSERT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_RANGE(aa, ac), "Mismatch in a position" );
}

IUTEST_F(SPITest, NonFatalFailure2)
{
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_TRUE(false), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_FALSE(true), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_NULL((void*)1), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_NOTNULL((void*)0), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_SAME(a, b), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ(0, 1), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_NE(1, 1), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_LE(1, 0), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_LT(1, 0), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_GE(0, 1), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_GT(0, 1), "" );
#if !defined(IUTEST_USE_GTEST)
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_FLOAT_EQ(0, 1), "(0x" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_DOUBLE_EQ(0, 1), "(0x" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED_FORMAT2(::iutest::FloatLE , 2, 0), "(0x" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED_FORMAT2(::iutest::DoubleLE, 2, 0), "(0x" );
#else
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_FLOAT_EQ(0, 1), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_DOUBLE_EQ(0, 1), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED_FORMAT2(::iutest::FloatLE , 2, 0), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED_FORMAT2(::iutest::DoubleLE, 2, 0), "" );
#endif
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_NEAR(0, 100, 2), "" );

	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ("A", "a"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ("A", null_str), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ(null_str, "a"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ(sa, "A"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ("A", sa), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ(sa, sb), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STREQ(L"A", L"a"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE("a", "a"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE(null_str, null_str), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE(sa, "a"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE("a", sa), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE(sa, sa), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRNE(L"a", L"a"), "" );

	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ("b", "a"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ("b", null_str), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ(null_str, "a"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ(sa, "b"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ("b", sa), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ(sa, sb), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASEEQ(L"a", L"b"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE("a", "a"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE("A", "a"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE(null_str, null_str), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE(sa, "A"), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE("A", sa), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE(sa, sa), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRCASENE(L"A", L"a"), "" );

	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRIN("b", "a"), "strstr" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRIN("b", null_str), "strstr" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_STRIN(null_str, "a"), "strstr" );

	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED1(IsOdd, 2), "evaluates to false, where" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED2(IsGreater, 0, 1), "evaluates to false, where" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED3(PredTest3, 0, 1, 3), "evaluates to false, where" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED4(PredTest4, 0, 1, 2, 4), "evaluates to false, where" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED5(PredTest5, 0, 1, 2, 3, 5), "evaluates to false, where" );
#if !defined(IUTEST_USE_GTEST) && !defined(IUTEST_NO_VARIADIC_MACROS) && IUTEST_HAS_VARIADIC_TEMPLATES
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_PRED(PredTest6, 0, 1, 2, 3, 4, 6), "evaluates to false, where" );
#endif

#if defined(IUTEST_OS_WINDOWS)
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_HRESULT_SUCCEEDED(-1), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_HRESULT_FAILED(0), "" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_HRESULT_FAILED(100), "" );
#endif

	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_COLLECTIONS(aa, aa+(sizeof(aa)/sizeof(aa[0])), ab, ab+(sizeof(ab)/sizeof(ab[0]))), "Mismatch element" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_COLLECTIONS(ab, ab+(sizeof(ab)/sizeof(ab[0])), aa, aa+(sizeof(aa)/sizeof(aa[0]))), "Mismatch element" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_COLLECTIONS(aa, aa+(sizeof(aa)/sizeof(aa[0])), ac, ac+(sizeof(ac)/sizeof(ac[0]))), "Mismatch in a position" );

	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_RANGE(aa, ab), "Mismatch element" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_RANGE(ab, aa), "Mismatch element" );
	IUTEST_EXPECT_NONFATAL_FAILURE( IUTEST_EXPECT_EQ_RANGE(aa, ac), "Mismatch in a position" );
}

}

