﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		iutest_skip_tests.cpp
 * @brief		IUTEST_SKIP 対応テスト
 *
 * @author		t.shirayanagi
 * @par			copyright
 * Copyright (C) 2012-2014, Takazumi Shirayanagi\n
 * This software is released under the new BSD License,
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "iutest.hpp"

static bool skip_check = true;

IUTEST(DISABLED_SkipTest, A)
{
}

IUTEST(SkipTest, CanSkip)
{
	IUTEST_SKIP() << "test";
	IUTEST_EXPECT_EQ(2, 3);
}

IUTEST(SkipTest, Failed)
{
	IUTEST_EXPECT_EQ(2, 3);
	IUTEST_SKIP();
	skip_check = false;
	IUTEST_EXPECT_EQ(2, 3);
}

IUTEST(SkipTest, Syntax)
{
	if( bool b = false )
		IUTEST_SKIP() << b << "no skip";
	IUTEST_EXPECT_EQ(2, 3);
}

#if !defined(IUTEST_USE_GTEST)

class SetUpTestCaseSkipTest : public ::iutest::Test
{
public:
	static void SetUpTestCase()
	{
		IUTEST_SKIP() << "skip in SetUpTestCase";
	}
};

IUTEST_F(SetUpTestCaseSkipTest, NotRun)
{
	IUTEST_EXPECT_EQ(2, 3);
}

class SetUpSkipTest : public ::iutest::Test
{
public:
	virtual void SetUp()
	{
		IUTEST_SKIP() << "skip in SetUp";
	}
};

IUTEST_F(SetUpSkipTest, NotRun)
{
	IUTEST_EXPECT_EQ(2, 3);
}

#endif

#ifdef UNICODE
int wmain(int argc, wchar_t* argv[])
#else
int main(int argc, char* argv[])
#endif
{
	IUTEST_INIT(&argc, argv);
#if defined(OUTPUTXML)
	// 失敗テストを含むので xml 出力しない
	::iutest::IUTEST_FLAG(output) = NULL;
#endif
	const int ret = IUTEST_RUN_ALL_TESTS();
	if( ret == 0 ) return 1;
#if !defined(IUTEST_USE_GTEST)
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->test_to_run_count() == 5 );
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->test_run_skipped_count() == 3 );
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->reportable_test_run_skipped_count() == 3 );
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->skip_test_count() == 4 );
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->reportable_skip_test_count() == 4 );
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->successful_test_count() == 0 );
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->total_test_case_count() == 4 );
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->successful_test_case_count() == 3 );
#else
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->test_to_run_count() == 3 );
#endif
	IUTEST_ASSERT_EXIT( ::iutest::UnitTest::GetInstance()->failed_test_count() == 2 );
	IUTEST_ASSERT_EXIT( skip_check );
	printf("*** Successful ***\n");
	return 0;
}
