/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_body_c.h
 * @brief		iris unit test eXgP̃NX
 *
 * @author		t.sirayanagi
 * @par			copyright
 * Copyright (C) 2012-2015, Takazumi Shirayanagi\n
 * This software is released under the new BSD License,
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_IUTEST_BODY_C_H_3EEA6706_9954_4330_B292_129667FA6B96_
#define INCG_IRIS_IUTEST_BODY_C_H_3EEA6706_9954_4330_B292_129667FA6B96_

/* include ===========================================================*/
#include "iutest_result_c.h"
#include "internal/iutest_core_impl_c.h"

IUTEST_EXTERN_C_BEGIN()

/* typedef ===========================================================*/
/**
 * @brief	eXg̊֐|C^^
*/
typedef void (*iuTestBody)(void);

/**
 * @brief	eXg SetUp ֐|C^^
*/
typedef void (*iuTestSetUp)(struct iuTestInfo_t*);

/**
 * @brief	eXg TearDown ֐|C^^
*/
typedef void (*iuTestTearDown)(struct iuTestInfo_t*);

/* struct ============================================================*/
/**
 * @brief	eXg\
*/
typedef struct iuTest_t
{
	iuTestBody		body;		/*!< eXg֐ */
	iuTestSetUp		setup;		/*!< SetUp֐ */
	iuTestTearDown	teardown;	/*!< TearDown֐ */
	void*			user;		/*!< [U[`̈AhX */
} iuTest;

/* define ============================================================*/
/** @private */
#define iuTest_ctor(body)	{ body, NULL, NULL, NULL }

/* function ==========================================================*/
#if IUTEST_C_HAS_LIB

/**
* @brief	iuTest Body ̏
*/
IUTEST_ATTRIBUTE_UNUSED_ void iuTest_Init(iuTest* test_body, iuTestSetUp setup, iuTestTearDown teardown, void* user);

/**
 * @brief	vpeB̋L^
 * @param [in]	key		= L[
 * @param [in]	value	= l̕
 * @return	
*/
IUTEST_ATTRIBUTE_UNUSED_ iuBOOL iuTest_RecordProperty(const char *key, const char *value);

/**
 * @brief	eXgʂ
 * @return	s\ǂ
*/
iuBOOL iuTest_CommitResult(iuTestPartResult* part_result);

/**
 * @brief	eXgʂ
*/
void iuTest_CommitResults(iuTestResult* result);

/**
* @brief	_~[
* @return	s\ǂ
*/
iuBOOL iuTest_DummyCommitResult(iuTestPartResult* part_result, void* user);

#endif

#if !IUTEST_C_HAS_LIB
#  include "impl/iutest_body_c.inl"
#endif

IUTEST_EXTERN_C_END()

#endif
