/*======================================================================
----------------------------------------------------------------------*/
/**
 * @file		iutest_case_c.h
 * @brief		iris unit test case
 *
 * @author		t.sirayanagi
 * @par			copyright
 * Copyright (C) 2012-2015, Takazumi Shirayanagi\n
 * This software is released under the new BSD License,
 * see LICENSE
*/
/*----------------------------------------------------------------------
======================================================================*/
#ifndef INCG_IRIS_IUTEST_CASE_C_H_1EFD40F6_D189_467B_93B0_887A64E2B830_
#define INCG_IRIS_IUTEST_CASE_C_H_1EFD40F6_D189_467B_93B0_887A64E2B830_

/* include ===========================================================*/
#include "iutest_info_c.h"

IUTEST_EXTERN_C_BEGIN()

/* typedef ===========================================================*/
/**
 * @brief	eXgP[X SetUp ֐|C^^
*/
typedef void (*iuTestSetUpTestCase)(void);

/**
 * @brief	eXgP[X TearDown ֐|C^^
*/
typedef void (*iuTestTearDownTestCase)(void);

/* enum ==============================================================*/
typedef enum IUTESTCASE_FLAG
{
	IUTESTCASE_DISABLED			= 0x00000002,	/*!< ǂ */
} IUTESTCASE_FLAG;

/* struct ============================================================*/
/**
 * @brief	TestCase \
*/
typedef struct iuTestCase_t
{
	const char* name;		/*!< eXgP[X */
	iuTestInfo*	list;		/*!< TestInfo Xg */
	iuTestSetUpTestCase		setup;		/*!< SetUp */
	iuTestTearDownTestCase	teardown;	/*!< TearDown */
	iuTimeInMillisec		elapsedmsec;/*!< s */
	iuUInt32	flag;		/*!< bit tO */
	void*		param;		/*!< p[^ւ̃|C^ */
	iuTestResult	result;			/*!< eXg */
	struct iuTestCase_t	*next;		/*!<  TestCase ̃m[h */
} iuTestCase;

/* function ==========================================================*/
#if IUTEST_C_HAS_LIB
/**
 * @brief	eXg̑擾
*/
int iuTestCase_GetTotalTestCount(const iuTestCase* test_case);

/**
 * @brief	sΏۂ̃eXg̑擾
*/
int iuTestCase_GetTestToRunCount(const iuTestCase* test_case);

/**
 * @brief	eXg̑擾
*/
int iuTestCase_GetSuccessfulTestCount(const iuTestCase* test_case);

/**
 * @brief	seXg̑擾
*/
int iuTestCase_GetFailureTestCount(const iuTestCase* test_case);

/**
 * @brief	eXgʂ̎擾
*/
iuBOOL iuTestCase_IsFaild(const iuTestCase* test_case);

/**
 * @brief	ǂ
*/
iuBOOL iuTestCase_IsDisabledTest(const iuTestCase* test_case);

/**
 * @brief	eXg̑擾
*/
int iuTestCase_GetDisableTestCount(const iuTestCase* test_case);

/**
 * @brief	IɃXLbveXg̑擾
*/
int iuTestCase_GetRunSkippedTestCount(const iuTestCase* test_case);

/**
* @brief	XLbveXg̑擾
*/
int iuTestCase_GetSkipTestCount(const iuTestCase* test_case);

/**
 * @brief	seXg邩ǂ
*/
iuBOOL iuTestCase_HasShouldRunTest(const iuTestCase* test_case);

/**
 * @brief	Ԃ̃NA
*/
void iuTestCase_Clear(iuTestCase* test_case);

/**
 * @brief	eXg̃tB^O
*/
void iuTestCase_Filter(iuTestCase* test_case);

/**
 * @brief	TestInfo ̒ǉ
*/
int IUTEST_ATTRIBUTE_UNUSED_ iuTestCase_AddTestInfo(iuTestCase* test_case, iuTestInfo* test_info);

/**
 * @brief	eXg̎s
*/
iuBOOL	iuTestCase_Run(iuTestCase* test_case);

#endif

#if !IUTEST_C_HAS_LIB
#  include "impl/iutest_case_c.inl"
#endif

IUTEST_EXTERN_C_END()

#endif
