﻿//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		param_test_tests1.cpp
 * @brief		parameter test
 *
 * @author		t.shirayanagi
 * @par			copyright
 * Copyright (C) 2012-2015, Takazumi Shirayanagi\n
 * This software is released under the new BSD License,
 * see LICENSE
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "param_test_tests.hpp"

#if IUTEST_HAS_PARAM_TEST

IUTEST_P(ParamTest, Test)
{
	IUTEST_SUCCEED() << GetParam();
}

int param_test_array[] = { 3, 2, 1, 0 };
::std::vector<int> va(param_test_array, param_test_array+(sizeof(param_test_array)/sizeof(param_test_array[0])));
IUTEST_INSTANTIATE_TEST_CASE_P(Range, ParamTest, ::iutest::Range<int>(0, 10));
IUTEST_INSTANTIATE_TEST_CASE_P(Values, ParamTest, ::iutest::Values(0, 1, 10));
IUTEST_INSTANTIATE_TEST_CASE_P(ValuesInArray, ParamTest, ::iutest::ValuesIn(param_test_array));
IUTEST_INSTANTIATE_TEST_CASE_P(ValuesInVector, ParamTest, ::iutest::ValuesIn(va));
#if IUTEST_HAS_INITIALIZER_LIST
IUTEST_INSTANTIATE_TEST_CASE_P(ValuesInInitializerList, ParamTest, ::iutest::ValuesIn({ 3, 2, 1, 0 }));
#endif

#if !defined(IUTEST_USE_GTEST)

enum TestEnum
{
	  TestEnum_0
	, TestEnum_1
	, TestEnum_2
	, TestEnum_3
	, TestEnum_4
	, TestEnum_5
};

class EnumParamTest : public ::iutest::TestWithParam<TestEnum> {};

IUTEST_P(EnumParamTest, Test)
{
}

IUTEST_INSTANTIATE_TEST_CASE_P(Range, EnumParamTest, ::iutest::Range<TestEnum>(TestEnum_0, TestEnum_5));

#endif

class BoolParamTest : public ::iutest::TestWithParam<bool> {};

IUTEST_P(BoolParamTest, Test)
{
}

IUTEST_INSTANTIATE_TEST_CASE_P(My1, BoolParamTest, ::iutest::Bool());

IUTEST_P(MultiInstantiateParamTest, Test)
{
	int param = GetParam();
	IUTEST_ASSERT_EQ(0, value);
	IUTEST_ASSERT_EQ(param, param);
}

IUTEST_INSTANTIATE_TEST_CASE_P(My1, MultiInstantiateParamTest, ::iutest::Range<int>(0, 10));

class InheritanceTestFixture : public ::iutest::Test {};
class InheritanceParamTest : public InheritanceTestFixture, public ::iutest::WithParamInterface<int> {};

IUTEST_P(InheritanceParamTest, Test)
{
}

IUTEST_INSTANTIATE_TEST_CASE_P(My1, InheritanceParamTest, ::iutest::Values(0));

#endif

