/*
* Copyright (C) 2010 The Android Open Source Project
*
* Apache License Version 2.0 (u{CZXv) ɊÂăCZX܂B;
* {CZXɏȂꍇ͂̃t@Cgpł܂B
* {CZX̃Rs[́Aȉ̏ꏊł܂B
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
* Kp@߂܂͏ʂł̓ӂɂĖȂA{CZXɊÂĔЕz\tgEFÁA
* َ킸AȂۏ؂ȂɌ̂܂
* Еz܂B
* {CZXł̌ƐK肵ẮA
* {CZXQƂĂB
*
*/

#include "../../../../include/iutest.hpp"

#define LOGI(...) ((void)__android_log_print(ANDROID_LOG_INFO, "AndroidProject1.NativeActivity", __VA_ARGS__))
#define LOGW(...) ((void)__android_log_print(ANDROID_LOG_WARN, "AndroidProject1.NativeActivity", __VA_ARGS__))

/**
* ۑԂ̃f[^łB
*/
struct saved_state {
	float angle;
	int32_t x;
	int32_t y;
};

/**
* Av̕ۑԂłB
*/
struct engine {
	struct android_app* app;

	ASensorManager* sensorManager;
	const ASensor* accelerometerSensor;
	ASensorEventQueue* sensorEventQueue;

	int animating;
	EGLDisplay display;
	EGLSurface surface;
	EGLContext context;
	int32_t width;
	int32_t height;
	struct saved_state state;
};

/**
* ݂̕\ EGL ReLXg܂B
*/
static int engine_init_display(struct engine* engine) {
	// OpenGL ES  EGL ̏

	/*
	* ړI̍\̑Ŏw肵܂B
	* ȉŁAIXN[ EBhE
	* ݊̂AeFŒ 8 rbg̃R|[lg EGLConfig I܂
	*/
	const EGLint attribs[] = {
		EGL_SURFACE_TYPE, EGL_WINDOW_BIT,
		EGL_BLUE_SIZE, 8,
		EGL_GREEN_SIZE, 8,
		EGL_RED_SIZE, 8,
		EGL_NONE
	};
	EGLint w, h, format;
	EGLint numConfigs;
	EGLConfig config;
	EGLSurface surface;
	EGLContext context;

	EGLDisplay display = eglGetDisplay(EGL_DEFAULT_DISPLAY);

	eglInitialize(display, 0, 0);

	/* ŁAAvP[V͖ړI̍\I܂B̃Tvł́A
	* oƈvŏ EGLConfig 
	* IPȑIvZX܂ */
	eglChooseConfig(display, attribs, &config, 1, &numConfigs);

	/* EGL_NATIVE_VISUAL_ID ́AANativeWindow_setBuffersGeometry() 
	* Ď󂯎邱Ƃۏ؂Ă EGLConfig ̑łB
	* EGLConfig I炷ɁAANativeWindow obt@[v邽߂
	* EGL_NATIVE_VISUAL_ID gpĈSɍč\ł܂B*/
	eglGetConfigAttrib(display, config, EGL_NATIVE_VISUAL_ID, &format);

	ANativeWindow_setBuffersGeometry(engine->app->window, 0, 0, format);

	surface = eglCreateWindowSurface(display, config, engine->app->window, NULL);
	context = eglCreateContext(display, config, NULL, NULL);

	if (eglMakeCurrent(display, surface, surface, context) == EGL_FALSE) {
		LOGW("Unable to eglMakeCurrent");
		return -1;
	}

	eglQuerySurface(display, surface, EGL_WIDTH, &w);
	eglQuerySurface(display, surface, EGL_HEIGHT, &h);

	engine->display = display;
	engine->context = context;
	engine->surface = surface;
	engine->width = w;
	engine->height = h;
	engine->state.angle = 0;

	// GL ̏Ԃ܂B
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
	glEnable(GL_CULL_FACE);
	glShadeModel(GL_SMOOTH);
	glDisable(GL_DEPTH_TEST);

	return 0;
}

/**
* fBXvČ݂̃t[̂݁B
*/
static void engine_draw_frame(struct engine* engine) {
	if (engine->display == NULL) {
		// fBXvC܂B
		return;
	}

	// FŉʂhԂ܂B
	glClearColor(((float)engine->state.x) / engine->width, engine->state.angle,
		((float)engine->state.y) / engine->height, 1);
	glClear(GL_COLOR_BUFFER_BIT);

	eglSwapBuffers(engine->display, engine->surface);
}

/**
* ݃fBXvCɊ֘AtĂ EGL ReLXg폜܂B
*/
static void engine_term_display(struct engine* engine) {
	if (engine->display != EGL_NO_DISPLAY) {
		eglMakeCurrent(engine->display, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);
		if (engine->context != EGL_NO_CONTEXT) {
			eglDestroyContext(engine->display, engine->context);
		}
		if (engine->surface != EGL_NO_SURFACE) {
			eglDestroySurface(engine->display, engine->surface);
		}
		eglTerminate(engine->display);
	}
	engine->animating = 0;
	engine->display = EGL_NO_DISPLAY;
	engine->context = EGL_NO_CONTEXT;
	engine->surface = EGL_NO_SURFACE;
}

/**
* ̓̓Cxg܂B
*/
static int32_t engine_handle_input(struct android_app* app, AInputEvent* event) {
	struct engine* engine = (struct engine*)app->userData;
	if (AInputEvent_getType(event) == AINPUT_EVENT_TYPE_MOTION) {
		engine->state.x = AMotionEvent_getX(event, 0);
		engine->state.y = AMotionEvent_getY(event, 0);
		return 1;
	}
	return 0;
}

/**
* ̃C R}h܂B
*/
static void engine_handle_cmd(struct android_app* app, int32_t cmd) {
	struct engine* engine = (struct engine*)app->userData;
	switch (cmd) {
	case APP_CMD_SAVE_STATE:
		// ݂̏Ԃۑ悤VXeɂėv܂BۑĂB
		engine->app->savedState = malloc(sizeof(struct saved_state));
		*((struct saved_state*)engine->app->savedState) = engine->state;
		engine->app->savedStateSize = sizeof(struct saved_state);
		break;
	case APP_CMD_INIT_WINDOW:
		// EBhE\Ă܂BĂB
		if (engine->app->window != NULL) {
			engine_init_display(engine);
			engine_draw_frame(engine);
		}
		break;
	case APP_CMD_TERM_WINDOW:
		// EBhE\܂͕Ă܂BN[ AbvĂB
		engine_term_display(engine);
		break;
	case APP_CMD_GAINED_FOCUS:
		// AvtH[JX擾ƁAxv̊ĎJn܂B
		if (engine->accelerometerSensor != NULL) {
			ASensorEventQueue_enableSensor(engine->sensorEventQueue,
				engine->accelerometerSensor);
			// ڕW 1 bƂ 60 ̃Cxg擾邱Ƃł (č)B
			ASensorEventQueue_setEventRate(engine->sensorEventQueue,
				engine->accelerometerSensor, (1000L / 60) * 1000);
		}
		break;
	case APP_CMD_LOST_FOCUS:
		// AvtH[JXƁAxv̊Ď~܂B
		// ɂAgpĂȂƂ̃obe[ߖł܂B
		if (engine->accelerometerSensor != NULL) {
			ASensorEventQueue_disableSensor(engine->sensorEventQueue,
				engine->accelerometerSensor);
		}
		// ܂AAj[V~܂B
		engine->animating = 0;
		engine_draw_frame(engine);
		break;
	}
}

/**
* ́Aandroid_native_app_glue gpĂlCeBu AvP[V
* ̃C Gg |CgłBꎩ̂̃XbhŃCxg [vɂĎsA
* ̓Cxg󂯎葼̑s肵܂B
*/
void android_main(struct android_app* state) {
	struct engine engine;

	memset(&engine, 0, sizeof(engine));
	state->userData = &engine;
	state->onAppCmd = engine_handle_cmd;
	state->onInputEvent = engine_handle_input;
	engine.app = state;

	// xv̊Ď̏
	engine.sensorManager = ASensorManager_getInstance();
	engine.accelerometerSensor = ASensorManager_getDefaultSensor(engine.sensorManager,
		ASENSOR_TYPE_ACCELEROMETER);
	engine.sensorEventQueue = ASensorManager_createEventQueue(engine.sensorManager,
		state->looper, LOOPER_ID_USER, NULL, NULL);

	if (state->savedState != NULL) {
		// ȑO̕ۑԂŊJn܂BĂB
		engine.state = *(struct saved_state*)state->savedState;
	}

	engine.animating = 1;

	// [v̓X^btɂJn҂Ă܂B

	::iutest::InitIrisUnitTest();
	IUTEST_RUN_ALL_TESTS();

	while (1) {
		// ׂۗ̂ẴCxgǂݎ܂B
		int ident;
		int events;
		struct android_poll_source* source;

		// Aj[VȂꍇAɃubNăCxĝ҂܂B
		// Aj[VꍇAׂẴCxgǂݎ܂Ń[vĂ瑱s܂
		// Aj[V̎̃t[`悵܂B
		while ((ident = ALooper_pollAll(engine.animating ? 0 : -1, NULL, &events,
			(void**)&source)) >= 0) {

			// ̃Cxg܂B
			if (source != NULL) {
				source->process(state, source);
			}

			// ZT[Ƀf[^ꍇA܂B
			if (ident == LOOPER_ID_USER) {
				if (engine.accelerometerSensor != NULL) {
					ASensorEvent event;
					while (ASensorEventQueue_getEvents(engine.sensorEventQueue,
						&event, 1) > 0) {
						LOGI("accelerometer: x=%f y=%f z=%f",
							event.acceleration.x, event.acceleration.y,
							event.acceleration.z);
					}
				}
			}

			// I邩ǂmF܂B
			if (state->destroyRequested != 0) {
				engine_term_display(&engine);
				return;
			}
		}

		if (engine.animating) {
			// Cxg玟̃Aj[V t[`悵܂B
			engine.state.angle += .01f;
			if (engine.state.angle > 1) {
				engine.state.angle = 0;
			}

			// `͉ʂ̍XV[gɍ킹ĒĂ邽߁A
			// ŎԒKv͂܂B
			engine_draw_frame(&engine);
		}
	}
}
