/*
 * Copyright (C) 2010 The Android Open Source Project
 *
 * Apache License Version 2.0 (u{CZXv) ɊÂăCZX܂B;
 * {CZXɏȂꍇ͂̃t@Cgpł܂B
 * {CZX̃Rs[́Aȉ̏ꏊł܂B
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Kp@߂܂͏ʂł̍ӂɂʒi̒߂ȂA{CZXɊÂĔЕz\tgEFÁA
 * َ킸AȂۏ؂ȂɌ̂܂
 * Еz܂B
 * {CZXł̌
 * K肵ɂẮA{CZXQƂĂB
 *
*/

#ifndef _ANDROID_NATIVE_APP_GLUE_H
#define _ANDROID_NATIVE_APP_GLUE_H

#include <poll.h>
#include <pthread.h>
#include <sched.h>

#include <android/configuration.h>
#include <android/looper.h>
#include <android/native_activity.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * <android/native_activity.h> 񋟂lCeBu ANeBreB C^[tFCX
 * ́ÃCxgƂɃANeBreB̃C XbhɂČĂяo
 * AvP[V̈ÃR[obNɊÂĂ܂B
 *
 * ܂AVXeɂăAvP[VI댯邽߁A
 * X̃R[obNۂĂ͂Ȃ܂B̃vO~O
 *  f͒ړIŃRpNgłAIłB
 *
 * 'threaded_native_app' ÓICúAAvP[V
 * ꎩ̂̃C Cxg [vʂ̃XbhɎł
 * قȂsf񋟂̂Ɏgp܂Bȉ̂悤Ɏs܂B
 *
 * 1/ AvP[V́AANeBreB쐬ꂽƂɌĂяo
 *    "android_main()" ƂO̊֐AANeBreB̃C XbhƂ
 *    قȂVXbhɒ񋟂Kv܂B
 *
 * 2/ android_main() ́AAvP[VsĂ 
 *     ANativeActivity IuWFNg CX^XȂǁȀdvȃIuWFNgւ̎QƂ܂
 *    L "android_app" \̂ւ̃|C^[󂯎܂B
 *
 * 3/ "android_app" IuWFNǵAȉ 2 ̏dvȃCxgɃbXĂ 
 *    ALooper CX^Xێ܂B
 *
 *      - ANeBreB CtTCN Cxg ("ꎞ~"A"ĊJ" Ȃ)Bȉ APP_CMD_XXX
 *        錾QƂĂB
 *
 *      - ANeBreBɃA^b`Ă AInputQueue ̓̓CxgB
 *
 *    ͂ꂼ  LOOPER_ID_MAIN  LOOPER_ID_INPUT Ƃl 
 *    ALooper_pollOnce ɂĕԂ ALooper ʎq
 *    ΉĂ܂B
 *
 *    ql̃AvP[Vł ALooper gpđ̃t@CLqq
 *    bXł܂B̓R[obNx[Xł邩A LOOPER_ID_USER Ŏn܂
 *    ʎqԂ̂ꂩłB
 *
 * 4/ LOOPER_ID_MAIN ܂ LOOPER_ID_INPUT Cxg󂯎Ƃɂ͏
 *    Ԃꂽf[^ android_poll_source \̂w܂B
 *     process() ֐ĂяoACxgƂ android_app->onAppCmd
 *     android_app->onInputEvent 
 *    Ăяo悤ɓ͂ł܂B
 *
 *    ܂́A჌x֐ĂяoĒڃf[^
 *    ǂݎ菈ł܂B̕@ɂẮAO[ process_cmd()  process_input()
 *    mF܂B
 *
 * ׂĂ̎gpႪ܂܂Ă NDK ƃZbg "native-activity" ƂO
 * TvQƂĂBɁANativeActivity  JavaDoc QƂĂB
 */

struct android_app;

/**
 * \[X̃f[^̏Ƃ "outData" Ƃ
 * Ԃ ALooper fd Ɋ֘AtĂf[^B
 */
struct android_poll_source {
    //̃\[X̎ʎq́ALOOPER_ID_MAIN ܂ 
    //LOOPER_ID_INPUT łB
    int32_t id;

    //  ident Ɋ֘AtĂ android_appB
    struct android_app* app;

    //̃\[X̃f[^̕WvZXs邽߂
    //Ăяo֐B
    void (*process)(struct android_app* app, struct android_poll_source* source);
};

/**
 * ́AXbhꂽAvP[V̕WO[ R[hɎgp
 * C^[tFCXłB̃fł́AAvP[ṼR[hvZX̃C XbhƂ
 * قȂ邻ꎩ̂̃XbhŎsĂ܂B
 * ̃Xbh Java VM Ɗ֘AtĂKv
 * ͂܂񂪁AJNI Cӂ Java IuWFNg
 * Ăяoۂɂ͂Kv܂B
 */
struct android_app {
    //K؂ȏꍇɂ́AAvP[V͂̏ԃIuWFNgɃ|C^[킹邱Ƃ
    //ł܂B
    void* userData;

    //C Av R}h (APP_CMD_*) 邽߂̊֐͂܂
    void (*onAppCmd)(struct android_app* app, int32_t cmd);

    //̓Cxg邽߂̊֐͂܂B_
    // Cxg͊ɃfBXpb`ĂAԂƂɂ͊Ă܂B
    // CxgƂꍇ 1 ԂAׂĂ̊̃fBXpb`ɂĂ
    // 0 Ԃ܂B
    int32_t (*onInputEvent)(struct android_app* app, AInputEvent* event);

    // ̃AvsĂ ANativeActivity IuWFNg CX^XB
    ANativeActivity* activity;

    // ̃AvsĂ錻݂̍\B
    AConfiguration* config;

    // ꂪ쐬Ɏw肳ꂽŌ̃CX^X̕ۑ̏ԂłB
    // ԂȂꍇ NULL łBKvɉĎgpł܂B
    //[́Aʒu APP_CMD_RESUME ɑ΂ android_app_exec_cmd()
    // Ăяo܂ŕێAsavedState  NULL ɐݒ肳܂B
    // ̕ϐ́ANULL ɏʒu APP_CMD_SAVE_STATE 
    //ꍇɂ̂ݕύXKvAԂ malloc ɂ
    //ɔzu܂B邱ƂŁAŃ[
    //܂B
    void* savedState;
    size_t savedStateSize;

    // AṽXbhɊ֘AtĂ ALooperB
    ALooper* looper;

    // ꂪANULL ȊȌꍇɃAv[U[̓Cxg
    // M̓L[łB
    AInputQueue* inputQueue;

    // ꂪANULL ȊȌꍇɃAv`łEBhEʂłB
    ANativeWindow* window;

    // EBhĚ݂̃Rec̈́A[U[ɑ΂ĕ\
    // EBhẼReczuꏊłB
    ARect contentRect;

    // AṽANeBreB݂̌̏Ԃ́AAPP_CMD_STARTA
    // APP_CMD_RESUMEAAPP_CMD_PAUSEA܂ APP_CMD_STOP ̂ꂩłBȉQƂĂB
    int activityState;

    // ́AAvP[V NativeActivity ̔j
    // Av Xbh̊̑ҋ@̓[ȊOɂȂ܂B
    int destroyRequested;

    // -------------------------------------------------
    // ȉ̓O[ R[h "l" ̎łB

    pthread_mutex_t mutex;
    pthread_cond_t cond;

    int msgread;
    int msgwrite;

    pthread_t thread;

    struct android_poll_source cmdPollSource;
    struct android_poll_source inputPollSource;

    int running;
    int stateSaved;
    int destroyed;
    int redrawNeeded;
    AInputQueue* pendingInputQueue;
    ANativeWindow* pendingWindow;
    ARect pendingContentRect;
};

enum {
    /**
     * AṽC Xbh擾R}h Looper f[^ ID łB
     *  ALooper_pollOnce() ̎ʎqƂĕԂ܂B̎ʎq̃f[^́A
     * android_poll_source \̂ւ̃|C^[łB
     *  android_app_read_cmd()
     *  android_app_exec_cmd() Ŏ擾Ał܂B
     */
    LOOPER_ID_MAIN = 1,

    /**
     * AvP[ṼEBhE AInputQueue 擾Cxg Looper f[^ ID łB
     *  ALooper_pollOnce() 
     * ʎqƂĕԂ܂B̎ʎq̃f[^
     * android_poll_source \̂ւ̃|C^[łB android_app  inputQueue IuWFNg
     * ǂݎ܂B
     */
    LOOPER_ID_INPUT = 2,

    /**
     * [U[`ꂽ ALooper ̍ŏ̎ʎqB
     */
    LOOPER_ID_USER = 3,
};

enum {
    /**
     * C Xbh̃R}h: AInputQueue ύX܂B̃R}h̏̍ہA
     * android_app->inputQueue ͐VL[ (܂ NULL)
     * ɍXV܂B
     */
    APP_CMD_INPUT_CHANGED,

    /**
     * C Xbh̃R}h: V ANativeWindow gp鏀ł܂B̃R}hMہA
     * android_app->window ɐVEBhEʂ
     * ܂܂܂B
     */
    APP_CMD_INIT_WINDOW,

    /**
     * C Xbh̃R}h:  ANativeWindow IKv
     * ܂B̃R}hMۂɂ android_app->window ɂ͈
     * ̃EBhE܂܂ĂAandroid_app_exec_cmd
 Ăяo    * NULL ɐݒ肳܂B
     */
    APP_CMD_TERM_WINDOW,

    /**
     * C Xbh̃R}h: ݂ ANativeWindow ̃TCYύX܂B
     * VTCYgpčĕ`悵ĂB
     */
    APP_CMD_WINDOW_RESIZED,

    /**
     * C Xbh̃R}h: ̃VXeł́A݂ ANativeWindow ĕ`
     * Kv܂BꎞIȕ`̕s邽߂ɂ́Aandroid_app_exec_cmd() 
     * ɓnOɃEBhEĕ`悷Kv܂B
     */
    APP_CMD_WINDOW_REDRAW_NEEDED,

    /**
     * C Xbh̃R}h: EBhẼRec̈悪ύX (\܂͔\
     * ̃\tg̓EBhEȂǂ) ܂BVRec̈́A
     * android_app::contentRect ɂ܂B
     */
    APP_CMD_CONTENT_RECT_CHANGED,

    /**
     * C Xbh̃R}h: AṽANeBreB EBhE̓tH[JX
     * 擾܂B
     */
    APP_CMD_GAINED_FOCUS,

    /**
     * C Xbh̃R}h: AṽANeBreB EBhE̓tH[JX
     * ܂B
     */
    APP_CMD_LOST_FOCUS,

    /**
     * C Xbh̃R}h: ݂̃foCX\ύX܂B
     */
    APP_CMD_CONFIG_CHANGED,

    /**
     * C Xbh̃R}h: VXe sĂ܂B
     * ̎gpʂ炵ĂB
     */
    APP_CMD_LOW_MEMORY,

    /**
     * C Xbh̃R}h: AṽANeBreBJn܂B
     */
    APP_CMD_START,

    /**
     * C Xbh̃R}h: AṽANeBreBĊJ܂B
     */
    APP_CMD_RESUME,

    /**
     * C Xbh̃R}h: KvɉČŕł悤ɁAAv
     * VۑԂ𐶐Kv܂BԂۑꍇ
     * malloc 蓖āAandroid_app.savedStateSize ̃TCY 
     * android_app.savedState ɔzu܂Bŉ
     * ܂B
     */
    APP_CMD_SAVE_STATE,

    /**
     * C Xbh̃R}h: AṽANeBreBꎞ~܂B
     */
    APP_CMD_PAUSE,

    /**
     * C Xbh̃R}h: AṽANeBreB~܂B
     */
    APP_CMD_STOP,

    /**
     * C Xbh̃R}h: AṽANeBreBjĂA
     * sOɁAAv XbhN[ AbvďÎҋ@Ă܂B
     */
    APP_CMD_DESTROY,
};

/**
 * ALooper_pollAll()  LOOPER_ID_MAIN ԂۂɌĂяoA
 * Av R}h bZ[Wǂݎ܂B
 */
int8_t android_app_read_cmd(struct android_app* android_app);

/**
 * w肳ꂽR}h̍ŏ̃vvZbTsɂ́Aandroid_app_read_cmd()
 * ԂꂽR}hgpČĂяo܂B̊֐ĂяoɁA
 * ̃R}hɑ΂Ǝ̃ANVsł܂B
 */
void android_app_pre_exec_cmd(struct android_app* android_app, int8_t cmd);

/**
 * w肳ꂽR}h̍Ō̌㏈sɂ́Aandroid_app_read_cmd()
 * ԂꂽR}hgpČĂяo܂B̊֐ĂяoOɁÃR}h
 * ΂Ǝ̃ANVsĂKv܂B
 */
void android_app_post_exec_cmd(struct android_app* android_app, int8_t cmd);

/**
 * ꂪAAvP[V R[hKv̂֐łA
 * Avւ̃C GgĂ܂B
 */
extern void android_main(struct android_app* app);

#ifdef __cplusplus
}
#endif

#endif /* _ANDROID_NATIVE_APP_GLUE_H */
