[![AppVeyor Build status](https://ci.appveyor.com/api/projects/status/2gdmgo8ce8m0iy0e/branch/master?svg=true)](https://ci.appveyor.com/project/srz-zumix/iutest/branch/master)
[![Azure Pipelines Build Status](https://dev.azure.com/srz-zumix/iutest/_apis/build/status/iutest?branchName=master)](https://dev.azure.com/srz-zumix/iutest/_build/latest?definitionId=4)
[![Bitrise iOS Build Status](https://app.bitrise.io/app/6903498632e89465/status.svg?token=siumhVNY6p6lklSZF6xGNA&branch=master)](https://app.bitrise.io/app/6903498632e89465?referrer=a9c0b9baf7536067)
[![Buddy branch](https://app.buddy.works/zumixcpp/iutest/repository/branch/master/badge.svg?token=a0d4d12b159d24a0234f9ed9567ebb40a6268f39f8151ef552999864674de564 "buddy branch")](https://app.buddy.works/zumixcpp/iutest/repository/branch/master)
[![CircleCI](https://circleci.com/gh/srz-zumix/iutest/tree/master.svg?style=svg)](https://circleci.com/gh/srz-zumix/iutest/tree/master)
[![Cirrus Build Status](https://api.cirrus-ci.com/github/srz-zumix/iutest.svg?branch=master)](https://cirrus-ci.com/github/srz-zumix/iutest/master)
[![Codefresh build status](https://g.codefresh.io/api/badges/pipeline/srz-zumix/iutest%2Fiutest_unittest?branch=master&type=cf-2)](https://g.codefresh.io/pipelines/iutest_unittest/builds?repoOwner=srz-zumix&repoName=iutest&serviceName=srz-zumix%2Fiutest&filter=trigger:build~Build;branch:master;pipeline:58a933be9d1bd40100495882~iutest_unittest)
[![Codeship Status for srz-zumix/iutest](https://codeship.com/projects/5bc87030-5b41-0133-6000-4242aa07dce3/status?branch=master)](https://codeship.com/projects/110695)
[![Drone Build Status](https://cloud.drone.io/api/badges/srz-zumix/iutest/status.svg?branch=master)](https://cloud.drone.io/srz-zumix/iutest)
[![GitHub Actions Status](https://github.com/srz-zumix/iutest/workflows/GitHub%20Actions/badge.svg?branch=master)](https://github.com/srz-zumix/iutest/actions?query=workflow%3A%22GitHub+Actions%22)
[![GitLab CI pipeline status](https://gitlab.com/srz-zumix/iutest-test/badges/master/pipeline.svg)](https://gitlab.com/srz-zumix/iutest-test/commits/master)
[![Peakflow Build Status](https://www.peakflow.io/en/projects/iutest/branch-statuses/master.svg)](https://www.peakflow.io/en/projects/iutest/build-groups?build_groups_q%5Bbranch_name_cont%5D=master)
[![Scrutinizer Build Status](https://scrutinizer-ci.com/g/srz-zumix/iutest/badges/build.png?b=master)](https://scrutinizer-ci.com/g/srz-zumix/iutest/build-status/master)
[![Semaphore Build Status](https://semaphoreci.com/api/v1/srz_zumix/iutest/branches/master/badge.svg)](https://semaphoreci.com/srz_zumix/iutest)
[![Semaphore 2.0 Build Status](https://srz-zumix.semaphoreci.com/badges/iutest/branches/master.svg)](https://srz-zumix.semaphoreci.com/projects/iutest)
[![Shippable Run Status](https://api.shippable.com/projects/541904d2ac22859af743f867/badge?branch=master)](https://app.shippable.com/github/srz-zumix/iutest)
[![Travis-CI Build Status](https://travis-ci.com/srz-zumix/iutest.svg?branch=master)](https://travis-ci.com/srz-zumix/iutest)
[![Wercker status](https://app.wercker.com/status/d385156052aa4118a7f24affe4a8f851/s/master "wercker status")](https://app.wercker.com/project/bykey/d385156052aa4118a7f24affe4a8f851)  
  
[![Codacy Badge](https://api.codacy.com/project/badge/Grade/e6407b63c9c844d080ed71c7707bded9?branch=master)](https://www.codacy.com/app/srz-zumix/iutest?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=srz-zumix/iutest&amp;utm_campaign=Badge_Grade)
[![Language grade: C/C++](https://img.shields.io/lgtm/grade/cpp/g/srz-zumix/iutest.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/srz-zumix/iutest/context:cpp)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/srz-zumix/iutest.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/srz-zumix/iutest/context:python)
[![Codecov](https://codecov.io/gh/srz-zumix/iutest/branch/master/graph/badge.svg)](https://codecov.io/gh/srz-zumix/iutest)
[![Coveralls Coverage Status](https://coveralls.io/repos/github/srz-zumix/iutest/badge.svg?branch=master)](https://coveralls.io/github/srz-zumix/iutest?branch=master)
[![Coverity Scan Build Status](https://scan.coverity.com/projects/1316/badge.svg)](https://scan.coverity.com/projects/srz-zumix-iutest)
[![GuardRails badge](https://badges.guardrails.io/srz-zumix/iutest.svg?token=fe1bb5ca5f743800d26e4d2b7282c5b316df83c0b228048f4192510bdd7280f0)](https://dashboard.guardrails.io/default/gh/srz-zumix/iutest)
[![GitHub Actions reviewdog Status](https://github.com/srz-zumix/iutest/workflows/GitHub%20Actions%20-%20reviewdog/badge.svg?branch=develop)](https://github.com/srz-zumix/iutest/actions?query=workflow%3A%22GitHub+Actions+-+reviewdog%22)  
[![New(3-clause) BSD License](https://img.shields.io/badge/license-New_BSD-blue.svg)](https://opensource.org/licenses/BSD-3-Clause)
[![NuGet version](https://badge.fury.io/nu/iutest.svg)](https://badge.fury.io/nu/iutest)  
[![support](https://img.shields.io/badge/%24-support-orange.svg)](https://amzn.asia/6fNxDZU)

iutest
==========

iutest - iris unit test framework

Welcome to the iutest
--------------------------------------------------

iutest is framework for writing C++ tests.

Features
--------------------------------------------------

* An [XUnit](https://en.wikipedia.org/wiki/XUnit) test framework.
* Header only, no external dependencies.
* Test discovery.
* XML/JUnit test report generation.
* Assertions.
  + A rich set of assertions.
  + User-defined assertions.
  + Power-assert (expression-assert).
  + Matchers.
  + Fatal and non-fatal, warning, assume failures.
* Value-parameterized tests.
* Type-parameterized tests.
* Advanced parameter generation.
  + Pairwise parameter.
  + CSV parameter.
  + Any parameter.
  + Random parameter.
  + Multiple parameters can be concatenated.
* Test packages (grouping).
* Skip test.
* Private member test.
* Janaese test name (C++03). 
* Various options for running the tests.
* Compatible with [Google Test](https://github.com/google/googletest). (1.5 or later)

Platforms
--------------------------------------------------

* Windows
* Linux
* MacOS
* FreeBSD
* Cygwin
* MinGW

Compiler
--------------------------------------------------

* VC++6~
* GCC 3.4.6~
* Clang 3.1~
* Zapcc

Documentation
--------------------------------------------------

* in repository  
  doc/index.html  
* online document  
  [latest released version](https://srz-zumix.github.io/iutest/latest)  
  [GitHub master branch](https://srz-zumix.github.io/iutest/master)  

Project page
--------------------------------------------------

* [OSDN Project page](https://iutest.osdn.jp/)  
* [GitHub](https://github.com/srz-zumix/iutest)  

Support
--------------------------------------------------

* Use [GitHub issues](https://github.com/srz-zumix/iutest/issues) to report bugs and feature requests.
* Ask questions at the twitter ([@srz_zumix](https://twitter.com/srz_zumix))

Tools
--------------------------------------------------

* fused  
  make fused-src.
* Twilio  
  notifies the test results using Twilio
* Wandbox  
  tools to make use of the iutest in [Wandbox](https://wandbox.org/)

Tests
--------------------------------------------------

|CI|master|develop|Tests|
|:--|:--|:--|:--|
|[AppVeyor](https://www.appveyor.com/)|[![AppVeyor Build status](https://ci.appveyor.com/api/projects/status/2gdmgo8ce8m0iy0e/branch/master?svg=true)](https://ci.appveyor.com/project/srz-zumix/iutest/branch/master)|[![AppVeyor Build status](https://ci.appveyor.com/api/projects/status/2gdmgo8ce8m0iy0e/branch/develop?svg=true)](https://ci.appveyor.com/project/srz-zumix/iutest/branch/develop)|Windows, Visual Studio, Cygwin, MINGW, NuGet, Visual Studio PREFAST (Code Analysis)|
|[Azure Pipelines](https://dev.azure.com)|[![Build Status](https://dev.azure.com/srz-zumix/iutest/_apis/build/status/iutest?branchName=master)](https://dev.azure.com/srz-zumix/iutest/_build/latest?definitionId=4)|[![Build Status](https://dev.azure.com/srz-zumix/iutest/_apis/build/status/iutest?branchName=develop)](https://dev.azure.com/srz-zumix/iutest/_build/latest?definitionId=4)|Config matrix test|
|[Bitrise](https://www.bitrise.io/?referrer=a9c0b9baf7536067)|[![Bitrise iOS Build Status](https://app.bitrise.io/app/6903498632e89465/status.svg?token=siumhVNY6p6lklSZF6xGNA&branch=master)](https://app.bitrise.io/app/6903498632e89465?referrer=a9c0b9baf7536067)|[![Bitrise iOS Build Status](https://app.bitrise.io/app/6903498632e89465/status.svg?token=siumhVNY6p6lklSZF6xGNA&branch=develop)](https://app.bitrise.io/app/6903498632e89465?referrer=a9c0b9baf7536067)|iOS|
|           |[![Bitrise Android Build Status](https://app.bitrise.io/app/f6bc69af3f6e2838/status.svg?token=eqd9m0stwgXuEff2FeLRQA&branch=master)](https://app.bitrise.io/app/f6bc69af3f6e2838?referrer=a9c0b9baf7536067)|[![Bitrise Android Build Status](https://app.bitrise.io/app/f6bc69af3f6e2838/status.svg?token=eqd9m0stwgXuEff2FeLRQA&branch=develop)](https://app.bitrise.io/app/f6bc69af3f6e2838?referrer=a9c0b9baf7536067)|Android|
|[Buddy](https://buddy.works/)|[![buddy branch](https://app.buddy.works/zumixcpp/iutest/repository/branch/master/badge.svg?token=a0d4d12b159d24a0234f9ed9567ebb40a6268f39f8151ef552999864674de564 "buddy branch")](https://app.buddy.works/zumixcpp/iutest/repository/branch/master)|[![buddy branch](https://app.buddy.works/zumixcpp/iutest/repository/branch/develop/badge.svg?token=a0d4d12b159d24a0234f9ed9567ebb40a6268f39f8151ef552999864674de564 "buddy branch")](https://app.buddy.works/zumixcpp/iutest/repository/branch/develop)|benchmark test|
|[Circle CI](https://circleci.com/)|[![CircleCI](https://circleci.com/gh/srz-zumix/iutest/tree/master.svg?style=svg)](https://circleci.com/gh/srz-zumix/iutest/tree/master)|[![CircleCI](https://circleci.com/gh/srz-zumix/iutest/tree/develop.svg?style=svg)](https://circleci.com/gh/srz-zumix/iutest/tree/develop)|Basic test with opmimize options|
|[Cirrus CI](https://cirrus-ci.org/)|[![Cirrus Build Status](https://api.cirrus-ci.com/github/srz-zumix/iutest.svg?branch=master)](https://cirrus-ci.com/github/srz-zumix/iutest/master)|[![Cirrus Build Status](https://api.cirrus-ci.com/github/srz-zumix/iutest.svg?branch=develop)](https://cirrus-ci.com/github/srz-zumix/iutest/develop)|g++/clang std=c++14,17.. Basic tests, FreeBSD Basic tests|
|[Codacy](https://www.codacy.com/)|[![Codacy Badge](https://api.codacy.com/project/badge/Grade/e6407b63c9c844d080ed71c7707bded9?branch=master)](https://www.codacy.com/app/srz-zumix/iutest?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=srz-zumix/iutest&amp;utm_campaign=Badge_Grade)|[![Codacy Badge](https://api.codacy.com/project/badge/Grade/e6407b63c9c844d080ed71c7707bded9?branch=develop)](https://www.codacy.com/app/srz-zumix/iutest?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=srz-zumix/iutest&amp;utm_campaign=Badge_Grade)|Shellcheck, Cppcheck, PyLint, etc...|
|[Codefresh](https://codefresh.io/)|[![Codefresh build status](https://g.codefresh.io/api/badges/pipeline/srz-zumix/iutest%2Fiutest_unittest?branch=master&type=cf-1)](https://g.codefresh.io/pipelines/iutest_unittest/builds?repoOwner=srz-zumix&repoName=iutest&serviceName=srz-zumix%2Fiutest&filter=trigger:build~Build;branch:master;pipeline:58a933be9d1bd40100495882~iutest_unittest)|[![Codefresh build status](https://g.codefresh.io/api/badges/pipeline/srz-zumix/iutest%2Fiutest_unittest?branch=develop&type=cf-1)](https://g.codefresh.io/pipelines/iutest_unittest/builds?repoOwner=srz-zumix&repoName=iutest&serviceName=srz-zumix%2Fiutest&filter=trigger:build~Build;branch:develop;pipeline:58a933be9d1bd40100495882~iutest_unittest)|Build tools/docker/Dockerfile, Benchmark test, Gcc 8/9 basic test|
|[Codeship](https://codeship.com/)|[![Codeship Status for srz-zumix/iutest](https://app.codeship.com/projects/5bc87030-5b41-0133-6000-4242aa07dce3/status?branch=master)](https://app.codeship.com/projects/110695)|[![Codeship Status for srz-zumix/iutest](https://app.codeship.com/projects/5bc87030-5b41-0133-6000-4242aa07dce3/status?branch=develop)](https://app.codeship.com/projects/110695)|Check coding standard of the project|
|[Coverity Scan](https://scan.coverity.com)|[![Coverity Scan Build Status](https://scan.coverity.com/projects/1316/badge.svg)](https://scan.coverity.com/projects/srz-zumix-iutest)||Coverity Scan|
|[Drone Cloud](https://cloud.drone.io)|[![Drone Build Status](https://cloud.drone.io/api/badges/srz-zumix/iutest/status.svg?branch=master)](https://cloud.drone.io/srz-zumix/iutest)|[![Build Status](https://cloud.drone.io/api/badges/srz-zumix/iutest/status.svg?branch=develop)](https://cloud.drone.io/srz-zumix/iutest)|gcc/clang each version Basic test|
|[GitHub Actions](https://github.com/srz-zumix/iutest/actions?query=workflow%3A"GitHub+Actions")|[![GitHub Actions Status](https://github.com/srz-zumix/iutest/workflows/GitHub%20Actions/badge.svg?branch=master)](https://github.com/srz-zumix/iutest/actions?query=workflow%3A%22GitHub+Actions%22+branch%3Amaster)|[![GitHub Actions Status](https://github.com/srz-zumix/iutest/workflows/GitHub%20Actions/badge.svg?branch=develop)](https://github.com/srz-zumix/iutest/actions?query=workflow%3A%22GitHub+Actions%22+branch%3Adevelop)|Basic test (Windows LLVM clang and mingw), EditorConfig Lint, Include What You Use, arm-none-eabi-gcc build|
|[GitHub Actions reviewdog](https://github.com/srz-zumix/iutest/actions?query=workflow%3A"GitHub+Actions+reviewdog")|[![GitHub Actions Reviewdog Status](https://github.com/srz-zumix/iutest/workflows/GitHub%20Actions%20-%20reviewdog/badge.svg?branch=develop)](https://github.com/srz-zumix/iutest/actions?query=workflow%3A%22GitHub+Actions+-+reviewdog%22+branch%3Amaster)||Reviewdog (shellcheck, cpplint)|
|[GitHub Actions Update GitHubPages](https://github.com/srz-zumix/iutest/actions?query=workflow%3A"GitHubPages")|[![Update GitHubPages Status](https://github.com/srz-zumix/iutest/workflows/GitHubPages/badge.svg?branch=master)](https://github.com/srz-zumix/iutest/actions?query=workflow%3A%22GitHubPages%22+branch%3Amaster)||Update documents|
|[GitLab CI](https://about.gitlab.com/product/continuous-integration/)|[![GitLab CI pipeline status](https://gitlab.com/srz-zumix/iutest-test/badges/master/pipeline.svg)](https://gitlab.com/srz-zumix/iutest-test/commits/master)|[![GitLab CI pipeline status](https://gitlab.com/srz-zumix/iutest-test/badges/develop/pipeline.svg)](https://gitlab.com/srz-zumix/iutest-test/commits/develop)|Google Test/Google Mock compatibility (HEAD)|
|[Peakflow](https://www.peakflow.io)|[![Peakflow Build Status](https://www.peakflow.io/en/projects/iutest/branch-statuses/master.svg)](https://www.peakflow.io/en/projects/iutest/build-groups?build_groups_q%5Bbranch_name_cont%5D=master)|[![Peakflow Build Status](https://www.peakflow.io/en/projects/iutest/branch-statuses/develop.svg)](https://www.peakflow.io/en/projects/iutest/build-groups?build_groups_q%5Bbranch_name_cont%5D=develop)||
|[Razorops](https://razorops.com/)|-|-|CentOS7 Basic test|
|[Scrutinizer](https://scrutinizer-ci.com/)|[![Scrutinizer Build Status](https://scrutinizer-ci.com/g/srz-zumix/iutest/badges/build.png?b=master)](https://scrutinizer-ci.com/g/srz-zumix/iutest/build-status/master)|[![Scrutinizer Build Status](https://scrutinizer-ci.com/g/srz-zumix/iutest/badges/build.png?b=develop)](https://scrutinizer-ci.com/g/srz-zumix/iutest/build-status/develop)|iuwandbox tests|
|[Semaphore](https://semaphoreci.com/)|[![Semaphore Build Status](https://semaphoreci.com/api/v1/srz_zumix/iutest/branches/master/badge.svg)](https://semaphoreci.com/srz_zumix/iutest)|[![Semaphore Build Status](https://semaphoreci.com/api/v1/srz_zumix/iutest/branches/develop/badge.svg)](https://semaphoreci.com/srz_zumix/iutest)|Scan-build|
|[Semaphore 2.0](https://semaphoreci.com/)|[![Semaphore 2.0 Build Status](https://srz-zumix.semaphoreci.com/badges/iutest/branches/master.svg)](https://srz-zumix.semaphoreci.com/projects/iutest)|[![Semaphore 2.0 Build Status](https://srz-zumix.semaphoreci.com/badges/iutest/branches/develop.svg)](https://srz-zumix.semaphoreci.com/projects/iutest)|Scan-build, Basic test, sample run|
|[Shippable](https://shippable.com/)|[![Shippable Run Status](https://api.shippable.com/projects/541904d2ac22859af743f867/badge?branch=master)](https://app.shippable.com/github/srz-zumix/iutest)|[![Run Status](https://api.shippable.com/projects/541904d2ac22859af743f867/badge?branch=develop)](https://app.shippable.com/github/srz-zumix/iutest)|CentOS gcc/clang Baisc test|
|[Travis CI](https://travis-ci.com/)|[![Travis-CI Build Status](https://travis-ci.com/srz-zumix/iutest.svg?branch=master)](https://travis-ci.com/srz-zumix/iutest)|[![Travis-CI Build Status](https://travis-ci.com/srz-zumix/iutest.svg?branch=develop)](https://travis-ci.com/srz-zumix/iutest)|Basic tests, Google Test compatibility, Coverage, Coverity-scan|
|[Wercker](https://www.wercker.com/)|[![wercker status](https://app.wercker.com/status/d385156052aa4118a7f24affe4a8f851/s/master "wercker status")](https://app.wercker.com/project/byKey/d385156052aa4118a7f24affe4a8f851)|[![wercker status](https://app.wercker.com/status/d385156052aa4118a7f24affe4a8f851/s/develop "wercker status")](https://app.wercker.com/project/byKey/d385156052aa4118a7f24affe4a8f851)|gtest compatible test for released versions / gtest version detect test|

Basic test

[Compiler and OS tests status](./docs/status/compiler_os_ci_status.rst)


Coverage
--------------------------------------------------

[![Coveralls Coverage Status](https://coveralls.io/repos/github/srz-zumix/iutest/badge.svg?branch=master)](https://coveralls.io/github/srz-zumix/iutest?branch=master)  


[![Codecov](https://codecov.io/gh/srz-zumix/iutest/branch/master/graph/badge.svg)](https://codecov.io/gh/srz-zumix/iutest)  
[![Codecov](https://codecov.io/gh/srz-zumix/iutest/branch/master/graphs/icicle.svg)](https://codecov.io/gh/srz-zumix/iutest)  

Contributing change
--------------------------------------------------

Please read the [`CONTRIBUTING.md`](CONTRIBUTING.md) for details on how to contribute to this project.

License
--------------------------------------------------

    Copyright (c) 2011-2020, Takazumi Shirayanagi,
    All rights reserved.

    This software is released under the New(3-clause) BSD License, see LICENSE

    If you distribute iutest, you might enjoy the [LICENSE-MIXING](docs/LICENSE-MIXING) document.
