/**
 * 
 */
package jp.sourceforge.functional;

/**
 * <P>
 * 何らかの値を受け取り、何らかの値を返す。最も基本となるファンクタ。
 * </P>
 * <P>
 * コンバーターを引数として受け取る場合、<code>UnaryConverter</code>や<code>BinaryConverter</code>
 * の代わりに、 このインターフェースを使用することを推奨します。
 * </P>
 * 
 * @author Fujii Kenichi
 * 
 * @param <T>
 *            引数の型
 * @param <R>
 *            戻り値の型
 */
public interface Converter<T, R> {
	/**
	 * 何らかの値を受け取り、何らかの値を返す。
	 * 
	 * @param source
	 *            元となる値
	 * @return 結果
	 */
	R convert(T source);
}
