package jp.sourceforge.functional;

/**
 * <p>
 * 引数を取らずに値を返すファンクタ。 これは、コンバーターの観点からすると、”引数を無視して値を返すファンクタ”であると言うことが出来ます。
 * </p>
 * <p>
 * コンバーターの引数を<code>Void</code></code>ではなく<code>Object</code>で実装していますが、これは例えば、
 * {@code Converter<? super String. R>}と定義されたパラメーターがあった場合、<code>Void</code>
 * 引数で実装したコンバーターは適合しないと言う問題が発生してしまうためです。<BR>
 * （これは, Javaの<code>Void</code>クラスが<code>Object</code>
 * クラスのサブクラスになってしまっている（本来は逆であるべき）と言う仕様が原因。）
 * </p>
 * <p>
 * また、このクラスは<code>Getter</code>インターフェースも実装しています。<BR>
 * 引数の無いコンバーターを明示的に指定したい（受け取りたい）場合は、<code>Getter</code>インターフェースを使用してください。<BR>
 * {@code Converter<? super Void, R>}では、<code>Object</code>
 * を受け取るコンバーターが適合してしまうという問題が発生します。（何度も言うがJavaのせい）
 * </p>
 * 
 * @author Fujii Kenichi
 * 
 * @param <R>
 */
public abstract class NullaryConverter<R> implements Converter<Object, R>,
		Getter<R> {

	@Override
	public R convert(Object source) {
		return get();
	}
}
