package jp.sourceforge.functional.classifier;

import jp.sourceforge.functional.Classifier;
import jp.sourceforge.functional.UnaryClassifier;

public class DelegateUnaryClassifier<T> extends UnaryClassifier<T> {

	private final Classifier<? super T> _classifier;

	public DelegateUnaryClassifier(Classifier<? super T> classifier) {
		_classifier = classifier;
	}

	@Override
	public boolean classify(T object) {
		return _classifier.classify(object);
	}
}
