package jp.sourceforge.functional.iterable;

import java.util.Iterator;

import jp.sourceforge.functional.BinaryConverter;
import jp.sourceforge.functional.Converter;

public class ConvertIterable<SOURCE, T> implements Iterable<T> {

	private final Iterable<? extends SOURCE> _source_iterable;
	private final Converter<? super SOURCE, ? extends T> _converter;
	private static BinaryConverter<?, ?, ?> _construct_functor = new BinaryConverter<Iterable<?>, Converter<Object, ?>, Iterable<Object>>() {
		@Override
		public Iterable<Object> convert(Iterable<?> source,
				Converter<Object, ?> converter) {
			return ConvertIterable.make(source, converter);
		}
	};

	public ConvertIterable(Iterable<? extends SOURCE> sources,
			Converter<? super SOURCE, ? extends T> converter) {
		_source_iterable = sources;
		_converter = converter;
	}

	@Override
	public Iterator<T> iterator() {
		return new UnremovableIterator<T>() {
			private final Iterator<? extends SOURCE> _source_iterator = _source_iterable
					.iterator();

			@Override
			public boolean hasNext() {
				return _source_iterator.hasNext();
			}

			@Override
			public T next() {
				return _converter.convert(_source_iterator.next());
			}
		};
	}

	public static <S, E> Iterable<E> make(Iterable<? extends S> sources,
			Converter<? super S, ? extends E> converter) {
		return new ConvertIterable<S, E>(sources, converter);
	}

	@SuppressWarnings("unchecked")
	public static <S, E> BinaryConverter<Iterable<? extends S>, Converter<? super S, ? extends E>, Iterable<E>> getBuilder() {
		return (BinaryConverter<Iterable<? extends S>, Converter<? super S, ? extends E>, Iterable<E>>) ConvertIterable._construct_functor;
	}
}
