/**
 * 
 */
package jp.sourceforge.functional.pair;

import jp.sourceforge.functional.pair.Pair.Side;

public class PairSecond<E1, E2> implements Side<E1, E2, E2, E1> {

	protected PairSecond() {}

	@Override
	public E2 getElement(Pair<? extends E1, ? extends E2> pair) {
		return pair.second;
	}

	@Override
	public E1 getOppositeElement(Pair<? extends E1, ? extends E2> pair) {
		return pair.first;
	}

	@Override
	public Pair<E1, E2> makePair(E2 element, E1 opposite_element) {
		return Pair.makePair(opposite_element, element);
	}
}
