package jp.sourceforge.functional.util;

import jp.sourceforge.functional.BinaryConverter;
import jp.sourceforge.functional.UnaryConverter;

public class CalculateFunctors {

	public static UnaryConverter<Number, Integer> toInt() {
		return new UnaryConverter<Number, Integer>() {
			@Override
			public Integer convert(Number number) {
				return number.intValue();
			}
		};
	}

	public static UnaryConverter<Number, Short> toShort() {
		return new UnaryConverter<Number, Short>() {
			@Override
			public Short convert(Number number) {
				return number.shortValue();
			}
		};
	}

	public static UnaryConverter<Number, Long> toLong() {
		return new UnaryConverter<Number, Long>() {
			@Override
			public Long convert(Number number) {
				return number.longValue();
			}
		};
	}

	public static UnaryConverter<Number, Double> toDouble() {
		return new UnaryConverter<Number, Double>() {
			@Override
			public Double convert(Number number) {
				return number.doubleValue();
			}
		};
	}

	public static UnaryConverter<Number, Float> toFloat() {
		return new UnaryConverter<Number, Float>() {
			@Override
			public Float convert(Number number) {
				return number.floatValue();
			}
		};
	}

	public static UnaryConverter<Number, Byte> toByte() {
		return new UnaryConverter<Number, Byte>() {
			@Override
			public Byte convert(Number number) {
				return number.byteValue();
			}
		};
	}

	public static <T extends Comparable<T>> BinaryConverter<T, T, T> max() {
		return new BinaryConverter<T, T, T>() {
			@Override
			public T convert(T first, T second) {
				return first.compareTo(second) < 0 ? second : first;
			}
		};
	}

	public static <T extends Comparable<T>> BinaryConverter<T, T, T> min() {
		return new BinaryConverter<T, T, T>() {
			@Override
			public T convert(T first, T second) {
				return first.compareTo(second) > 0 ? second : first;
			}
		};
	}

	public static <T extends Comparable<T>> UnaryConverter<T, T> toInside(
			T min, T max) {
		assert min.compareTo(max) <= 0;
		return CalculateFunctors.<T> max().bindFirst(min).arrange(
				CalculateFunctors.<T> min().bindFirst(max));
	}
}
