package jp.sourceforge.functional.util;

import jp.sourceforge.functional.BinaryConverter;
import jp.sourceforge.functional.Converter;
import jp.sourceforge.functional.Getter;
import jp.sourceforge.functional.NullaryConverter;
import jp.sourceforge.functional.UnaryConverter;
import jp.sourceforge.functional.pair.Pair;

public class ConvertFunctors {

	public static <T, R> BinaryConverter<Converter<? super T, ? extends R>, T, R> convert() {
		return new BinaryConverter<Converter<? super T, ? extends R>, T, R>() {
			@Override
			public R convert(Converter<? super T, ? extends R> converter,
					T object) {
				return converter.convert(object);
			}
		};
	}

	public static <T, R> BinaryConverter<Converter<? super T, ? extends R>, T, NullaryConverter<R>> bind() {
		return new BinaryConverter<Converter<? super T, ? extends R>, T, NullaryConverter<R>>() {
			@Override
			public NullaryConverter<R> convert(
					final Converter<? super T, ? extends R> converter,
					final T bind) {
				return new NullaryConverter<R>() {
					@Override
					public R get() {
						return converter.convert(bind);
					}
				};
			}
		};
	}

	public static <T1, T2, R> BinaryConverter<Converter<? super Pair<? extends T1, ? extends T2>, ? extends R>, T1, UnaryConverter<T2, R>> bindFirst() {
		return new BinaryConverter<Converter<? super Pair<? extends T1, ? extends T2>, ? extends R>, T1, UnaryConverter<T2, R>>() {
			@Override
			public UnaryConverter<T2, R> convert(
					final Converter<? super Pair<? extends T1, ? extends T2>, ? extends R> converter,
					final T1 first) {
				return new UnaryConverter<T2, R>() {
					@Override
					public R convert(T2 second) {
						return converter.convert(Pair.makePair(first, second));
					}
				};
			}
		};
	}

	public static <T1, T2, R> BinaryConverter<Converter<? super Pair<? extends T1, ? extends T2>, ? extends R>, T2, UnaryConverter<T1, R>> bindSecond() {
		return new BinaryConverter<Converter<? super Pair<? extends T1, ? extends T2>, ? extends R>, T2, UnaryConverter<T1, R>>() {
			@Override
			public UnaryConverter<T1, R> convert(
					final Converter<? super Pair<? extends T1, ? extends T2>, ? extends R> converter,
					final T2 second) {
				return new UnaryConverter<T1, R>() {
					@Override
					public R convert(T1 first) {
						return converter.convert(Pair.makePair(first, second));
					}
				};
			}
		};
	}

	public static <T, S, R> BinaryConverter<Converter<? super T, ? extends R>, Converter<? super S, ? extends T>, UnaryConverter<S, R>> arrange() {
		return new BinaryConverter<Converter<? super T, ? extends R>, Converter<? super S, ? extends T>, UnaryConverter<S, R>>() {
			@Override
			public UnaryConverter<S, R> convert(
					final Converter<? super T, ? extends R> base_converter,
					final Converter<? super S, ? extends T> argument_converter) {
				return new UnaryConverter<S, R>() {
					@Override
					public R convert(S source) {
						return base_converter.convert(argument_converter
								.convert(source));
					}
				};
			}
		};
	}

	public static <T, R, R2> BinaryConverter<Converter<? super T, ? extends R>, Converter<? super R, ? extends R2>, UnaryConverter<T, R2>> arrangeResult() {
		return new BinaryConverter<Converter<? super T, ? extends R>, Converter<? super R, ? extends R2>, UnaryConverter<T, R2>>() {
			@Override
			public UnaryConverter<T, R2> convert(
					final Converter<? super T, ? extends R> base_converter,
					final Converter<? super R, ? extends R2> result_convereter) {
				return new UnaryConverter<T, R2>() {
					@Override
					public R2 convert(T source) {
						return result_convereter.convert(base_converter
								.convert(source));
					}
				};
			}
		};
	}

	public static <R> UnaryConverter<Getter<R>, R> get() {
		return new UnaryConverter<Getter<R>, R>() {
			@Override
			public R convert(Getter<R> getter) {
				return getter.get();
			}
		};
	}

}
