package jp.sourceforge.functional;

import jp.sourceforge.functional.converter.ConverterMaker;
import jp.sourceforge.functional.pair.Pair;

public abstract class UnaryClassifier<T> extends UnaryConverter<T, Boolean>
		implements Classifier<T> {

	public UnaryClassifier<T> negative() {
		return new UnaryClassifier<T>() {
			@Override
			public boolean classify(T object) {
				return !UnaryClassifier.this.classify(object);
			}
		};
	}

	@Override
	public Boolean convert(T source) {
		return classify(source);
	}

	@Override
	public NullaryClassifier bind(final T bind) {
		return new NullaryClassifier() {
			@Override
			public boolean conclude() {
				return UnaryClassifier.this.classify(bind);
			}
		};
	}

	@Override
	public UnaryConverter<T, ? extends NullaryClassifier> binder() {
		return new ConverterMaker<T, Object, Boolean, NullaryClassifier>() {
			@Override
			public NullaryClassifier convert(T bind) {
				return UnaryClassifier.this.bind(bind);
			}
		};
	}

	@Override
	public <S> UnaryClassifier<S> arrange(
			final Converter<? super S, ? extends T> converter) {
		return new UnaryClassifier<S>() {
			@Override
			public boolean classify(S element) {
				return UnaryClassifier.this
						.classify(converter.convert(element));
			}
		};
	}

	public <S1, S2> BinaryClassifier<S1, S2> arrangeToBinaryClassifier(
			final Converter<? super Pair<? extends S1, ? extends S2>, ? extends T> converter) {
		return new BinaryClassifier<S1, S2>() {
			@Override
			public boolean classify(S1 first, S2 second) {
				return UnaryClassifier.this.classify(converter.convert(Pair
						.makePair(first, second)));
			}
		};
	}
}
