package jp.sourceforge.functional;

import jp.sourceforge.functional.converter.ConverterMaker;
import jp.sourceforge.functional.pair.Pair;

public abstract class UnaryVisitor<T> extends UnaryConverter<T, Void> implements
		Visitor<T> {

	@Override
	public Void convert(T source) {
		visit(source);
		return null;
	}

	@Override
	public NullaryVisitor bind(final T bind) {
		return new NullaryVisitor() {
			@Override
			public void run() {
				UnaryVisitor.this.visit(bind);
			}
		};
	}

	@Override
	public UnaryConverter<T, ? extends NullaryVisitor> binder() {
		return new ConverterMaker<T, Object, Void, NullaryVisitor>() {
			@Override
			public NullaryVisitor convert(T bind) {
				return UnaryVisitor.this.bind(bind);
			}
		};
	}

	@Override
	public <S> UnaryVisitor<S> arrange(
			final Converter<? super S, ? extends T> converter) {
		return new UnaryVisitor<S>() {
			@Override
			public void visit(S element) {
				UnaryVisitor.this.visit(converter.convert(element));
			}
		};
	}

	public <S1, S2> BinaryVisitor<S1, S2> arrangeToBinaryVisitor(
			final Converter<? super Pair<? extends S1, ? extends S2>, ? extends T> converter) {
		return new BinaryVisitor<S1, S2>() {
			@Override
			public void visit(S1 first, S2 second) {
				UnaryVisitor.this.visit(converter.convert(Pair.makePair(first,
						second)));
			}
		};
	}
}
