package jp.sourceforge.functional.compare;

import java.util.Comparator;

import jp.sourceforge.functional.UnaryConverter;

public class FunctionalComparable<T> extends UnaryConverter<T, Integer>
		implements Comparable<T> {

	private final Comparator<? super T> _comparator;
	private final T _standard;

	public FunctionalComparable(T standard, Comparator<? super T> comparator) {
		_standard = standard;
		this._comparator = comparator;
	}

	@Override
	public int compareTo(T o) {
		return convert(o);
	}

	@Override
	public Integer convert(T source) {
		return _comparator.compare(_standard, source);
	}
}
