package jp.sourceforge.functional.converter;

import jp.sourceforge.functional.BinaryConverter;
import jp.sourceforge.functional.Converter;
import jp.sourceforge.functional.pair.Pair;

public class DelegateBinaryConverter<T1, T2, R> extends
		BinaryConverter<T1, T2, R> {

	private final Converter<? super Pair<? extends T1, ? extends T2>, ? extends R> _converter;

	public DelegateBinaryConverter(
			Converter<? super Pair<? extends T1, ? extends T2>, ? extends R> converter) {
		_converter = converter;
	}

	@Override
	public R convert(T1 first, T2 second) {
		return convert(Pair.makePair(first, second));
	}

	@Override
	public R convert(Pair<? extends T1, ? extends T2> pair) {
		return _converter.convert(pair);
	}
}
