package jp.sourceforge.functional.converter;

import jp.sourceforge.functional.Converter;
import jp.sourceforge.functional.UnaryConverter;

public class DelegateUnaryConverter<T, R> extends UnaryConverter<T, R> {

	private final Converter<? super T, ? extends R> _converter;

	public DelegateUnaryConverter(Converter<? super T, ? extends R> converter) {
		_converter = converter;
	}

	@Override
	public R convert(T source) {
		return _converter.convert(source);
	}
}
