package jp.sourceforge.functional.getter;

import jp.sourceforge.functional.Getter;
import jp.sourceforge.functional.NullaryConverter;

public class SimpleHolder<T> extends NullaryConverter<T> implements Getter<T> {

	private final T _value;

	public SimpleHolder(T value) {
		this._value = value;
	}

	@Override
	public T get() {
		return _value;
	}

	public static <T> SimpleHolder<T> make(T value) {
		return new SimpleHolder<T>(value);
	}
}
