/**
 * 
 */
package jp.sourceforge.functional.pair;

import jp.sourceforge.functional.pair.Pair.Side;

public class PairFirst<E1, E2> implements Side<E1, E2, E1, E2> {

	protected PairFirst() {}

	@Override
	public E1 getElement(Pair<? extends E1, ? extends E2> pair) {
		return pair.first;
	}

	@Override
	public E2 getOppositeElement(Pair<? extends E1, ? extends E2> pair) {
		return pair.second;
	}

	@Override
	public Pair<E1, E2> makePair(E1 element, E2 opposite_element) {
		return Pair.makePair(element, opposite_element);
	}
}
