package jp.sourceforge.functional.util;

import jp.sourceforge.functional.BinaryClassifier;
import jp.sourceforge.functional.Classifier;
import jp.sourceforge.functional.Converter;
import jp.sourceforge.functional.UnaryClassifier;
import jp.sourceforge.functional.iterable.ConvertIterable;

public class ClassifyFunctors {

	public static <T> BinaryClassifier<Classifier<? super T>, T> classify() {
		return new BinaryClassifier<Classifier<? super T>, T>() {
			@Override
			public boolean classify(Classifier<? super T> classifier, T object) {
				return classifier.classify(object);
			}
		};
	}

	public static UnaryClassifier<Iterable<? extends Boolean>> allOf() {
		return new UnaryClassifier<Iterable<? extends Boolean>>() {
			@Override
			public boolean classify(Iterable<? extends Boolean> booleans) {
				for (Boolean bool : booleans) {
					if (!bool) return false;
				}
				return true;
			}
		};
	}

	public static UnaryClassifier<Iterable<? extends Boolean>> whichOf() {
		return new UnaryClassifier<Iterable<? extends Boolean>>() {
			@Override
			public boolean classify(Iterable<? extends Boolean> booleans) {
				for (Boolean bool : booleans) {
					if (bool) return true;
				}
				return false;
			}
		};
	}

	public static <T> BinaryClassifier<Iterable<? extends T>, Converter<? super T, ? extends Boolean>> isAllOf() {
		return allOf().arrangeToBinaryClassifier(
				ConvertIterable.<T, Boolean> getBuilder());
	}

	public static <T> BinaryClassifier<Iterable<? extends T>, Converter<? super T, ? extends Boolean>> isWhichOf() {
		return whichOf().arrangeToBinaryClassifier(
				ConvertIterable.<T, Boolean> getBuilder());
	}
}
