package jp.sourceforge.functional.util;

import java.util.Collection;

import jp.sourceforge.functional.BinaryClassifier;
import jp.sourceforge.functional.UnaryClassifier;
import jp.sourceforge.functional.UnaryConverter;
import jp.sourceforge.functional.visit.ReportableBinaryVisitor;

public class CollectionFunctors {

	private static final UnaryConverter<Collection<?>, Integer> _size = new UnaryConverter<Collection<?>, Integer>() {
		@Override
		public Integer convert(Collection<?> collection) {
			return collection.size();
		}
	};
	private static final ReportableBinaryVisitor<?, ?, Boolean> _add = new ReportableBinaryVisitor<Collection<Object>, Object, Boolean>() {
		@Override
		public Boolean convert(Collection<Object> collection, Object add_element) {
			return collection.add(add_element);
		}
	};
	private static final ReportableBinaryVisitor<?, ?, Boolean> _add_all = new ReportableBinaryVisitor<Collection<Object>, Collection<?>, Boolean>() {
		@Override
		public Boolean convert(Collection<Object> base_collection,
				Collection<?> add_collection) {
			return base_collection.addAll(add_collection);
		}
	};

	private static final ReportableBinaryVisitor<Collection<?>, Object, Boolean> _remove = new ReportableBinaryVisitor<Collection<?>, Object, Boolean>() {
		@Override
		public Boolean convert(Collection<?> collection, Object remove_element) {
			return collection.remove(remove_element);
		}
	};
	private static final ReportableBinaryVisitor<Collection<?>, Collection<?>, Boolean> _remove_all = new ReportableBinaryVisitor<Collection<?>, Collection<?>, Boolean>() {
		@Override
		public Boolean convert(Collection<?> base_collection,
				Collection<?> remove_collection) {
			return base_collection.removeAll(remove_collection);
		}
	};
	private static ReportableBinaryVisitor<Collection<?>, Collection<?>, Boolean> _retain_all = new ReportableBinaryVisitor<Collection<?>, Collection<?>, Boolean>() {
		@Override
		public Boolean convert(Collection<?> base_collection,
				Collection<?> retain_collection) {
			return base_collection.retainAll(retain_collection);
		}
	};
	private static final BinaryClassifier<Collection<?>, Object> _contains = new BinaryClassifier<Collection<?>, Object>() {
		@Override
		public boolean classify(Collection<?> collection, Object object) {
			return collection.contains(object);
		}
	};
	private static final BinaryClassifier<Collection<?>, Collection<?>> _contains_all = new BinaryClassifier<Collection<?>, Collection<?>>() {
		@Override
		public boolean classify(Collection<?> collection1,
				Collection<?> collection2) {
			return collection1.containsAll(collection2);
		}
	};
	private static final UnaryClassifier<Collection<?>> _is_empty = new UnaryClassifier<Collection<?>>() {
		@Override
		public boolean classify(Collection<?> collection) {
			return collection.isEmpty();
		}
	};

	public static UnaryConverter<Collection<?>, Integer> size() {
		return _size;
	}

	@SuppressWarnings("unchecked")
	public static <E> ReportableBinaryVisitor<Collection<? super E>, E, Boolean> add() {
		return (ReportableBinaryVisitor<Collection<? super E>, E, Boolean>) _add;
	}

	@SuppressWarnings("unchecked")
	public static <E> ReportableBinaryVisitor<Collection<? super E>, Collection<? extends E>, Boolean> addAll() {
		return (ReportableBinaryVisitor<Collection<? super E>, Collection<? extends E>, Boolean>) _add_all;
	}

	public static ReportableBinaryVisitor<Collection<?>, Object, Boolean> remove() {
		return _remove;
	}

	public static ReportableBinaryVisitor<Collection<?>, Collection<?>, Boolean> removeAll() {
		return _remove_all;
	}

	public static ReportableBinaryVisitor<Collection<?>, Collection<?>, Boolean> retainAll() {
		return _retain_all;
	}

	public static BinaryClassifier<Collection<?>, Object> contains() {
		return _contains;
	}

	public static BinaryClassifier<Collection<?>, Collection<?>> containsAll() {
		return _contains_all;
	}

	public static BinaryClassifier<Iterable<?>, Collection<?>> jointly() {
		return ClassifyFunctors.isWhichOf().arrangeSecond(
				contains().firstBinder());
	}

	public static UnaryClassifier<Collection<?>> isEmpty() {
		return _is_empty;
	}
}
