package jp.sourceforge.functional.util;

import jp.sourceforge.functional.BinaryClassifier;
import jp.sourceforge.functional.UnaryConverter;

public class ObjectFunctors {

	private static final BinaryClassifier<Object, Object> _equals = new BinaryClassifier<Object, Object>() {
		@Override
		public boolean classify(Object object1, Object object2) {
			return object1.equals(object2);
		}
	};

	private static final UnaryConverter<Object, Integer> _hash_code = new UnaryConverter<Object, Integer>() {
		@Override
		public Integer convert(Object object) {
			return object.hashCode();
		}
	};

	public static BinaryClassifier<Object, Object> equals() {
		return _equals;
	}

	public static UnaryConverter<Object, Integer> hashCodeGetter() {
		return _hash_code;
	}
}
