/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor;

import cx.ath.kgslab.svgeditor.CanvasPanel;
import cx.ath.kgslab.svgeditor.SaveListener;
import cx.ath.kgslab.svgeditor.ToolBar;
import cx.ath.kgslab.svgeditor.parser.SVGParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MainPanel
extends JPanel
implements SaveListener {
    ToolBar toolBar = new ToolBar();
    CanvasPanel canvas = new CanvasPanel();
    List saveListeners = new ArrayList();

    public MainPanel() {
        super(new BorderLayout(), true);
        this.init();
    }

    private void init() {
        this.add((Component)this.toolBar, "West");
        this.add((Component)this.canvas, "Center");
        this.toolBar.setCanvas(this.canvas);
        this.toolBar.addSaveListener(this);
    }

    public void load(InputSource is) throws ParserConfigurationException, SAXException, IOException {
        SVGParser parser = new SVGParser();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(is, (DefaultHandler)parser);
        this.canvas.setStrokes(parser.getResult());
    }

    public void save(String svg) throws Exception {
        Iterator ite = this.saveListeners.iterator();
        while (ite.hasNext()) {
            SaveListener element = (SaveListener)ite.next();
            element.save(svg);
        }
    }

    public void addSaveListener(SaveListener listener) {
        if (listener != null) {
            this.saveListeners.add(listener);
        }
    }
}

