/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor.items;

import cx.ath.kgslab.svgeditor.items.ClosedItem;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class Circle
extends ClosedItem {
    public static final String ELEMENT_NAME = "circle";
    protected int r = 0;
    protected Ellipse2D shape = new Ellipse2D.Double(0.0, 0.0, 0.0, 0.0);

    public Shape getShape() {
        if (this.changed) {
            this.shape.setFrame(this.x - this.r, this.y - this.r, this.r * 2, this.r * 2);
            this.changed = false;
        }
        return this.shape;
    }

    public String getSvgElement() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(ELEMENT_NAME);
        buf.append(" cx='").append(this.x).append("'");
        buf.append(" cy='").append(this.y).append("'");
        buf.append(" r='").append(this.r).append("'");
        buf.append(" fill='").append(this.getFillString()).append("'");
        buf.append(" stroke='").append(this.getColorString()).append("'");
        buf.append(" stroke-width='").append(this.lineWidth).append("'/>");
        return buf.toString();
    }

    public int getR() {
        return this.r;
    }

    public void setR(int i) {
        this.r = i;
        this.changed = true;
    }

    public void form(int x, int y) {
        int r = 0;
        int rx = Math.abs(x - this.getX());
        int ry = Math.abs(y - this.getY());
        r = x == this.getX() ? ry : (y == this.getY() ? rx : (int)Math.round(Math.sqrt(rx * rx + ry * ry)));
        this.setR(r);
    }

    public void initSample(int width, int height) {
        int x = width / 2;
        int y = height / 2;
        int n = y / 3 * 2;
        this.setX(x);
        this.setY(y);
        this.setR(n);
    }
}

