/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor.items;

import cx.ath.kgslab.svgeditor.items.StrokeItem;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Stroke
extends StrokeItem {
    public static final String ELEMENT_NAME = "polyline";
    private GeneralPath shape = null;
    private List path = new ArrayList();

    public Shape getShape() {
        if (this.shape == null || this.changed) {
            this.shape = new GeneralPath();
            int sx = this.x;
            int sy = this.y;
            Iterator ite = this.path.iterator();
            while (ite.hasNext()) {
                Point p = (Point)ite.next();
                int ex = p.x + this.x;
                int ey = p.y + this.y;
                this.shape.append(new Line2D.Double(sx, sy, ex, ey), true);
                sx = ex;
                sy = ey;
            }
        }
        return this.shape;
    }

    public String getSvgElement() {
        StringBuffer buf = new StringBuffer();
        buf.append("<").append(ELEMENT_NAME);
        buf.append(" points='");
        buf.append(this.x).append(',').append(this.y).append(' ');
        Iterator ite = this.path.iterator();
        while (ite.hasNext()) {
            Point p = (Point)ite.next();
            buf.append(p.x + this.x).append(',').append(p.y + this.y).append(' ');
        }
        buf.append("'");
        buf.append(" fill='none'");
        buf.append(" stroke='").append(this.getColorString()).append("'");
        buf.append(" stroke-width='").append(this.lineWidth).append("'/>");
        return buf.toString();
    }

    public void addPath(int x, int y) {
        Point point = new Point(x - this.x, y - this.y);
        this.path.add(point);
        this.changed = true;
    }

    public void form(int x, int y) {
        this.addPath(x, y);
    }

    public void initSample(int width, int height) {
        int x = width / 2;
        int y = height / 2;
        int m = x / 3 * 2;
        int n = y / 3 * 2;
        this.setX(x - m);
        this.setY(y);
        int t = m / 6;
        int i = 0;
        while (i < 12) {
            this.addPath(x - m + t * i, y - (int)(Math.sin((double)i / 2.0) * (double)n));
            ++i;
        }
    }
}

