/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.kgslab.svgeditor;

import cx.ath.kgslab.svgeditor.CanvasPanel;
import cx.ath.kgslab.svgeditor.SamplePanel;
import cx.ath.kgslab.svgeditor.SaveListener;
import cx.ath.kgslab.svgeditor.items.Item;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ToolBar
extends Box {
    private JPanel toolPallet = new JPanel(new GridLayout(4, 2));
    private JToggleButton select = new JToggleButton("\u2190");
    private JToggleButton rect = new JToggleButton("\u25a1");
    private JToggleButton stroke = new JToggleButton("\uff5e");
    private JToggleButton line = new JToggleButton("\uff0f");
    private JToggleButton text = new JToggleButton("\uff21");
    private JToggleButton circle = new JToggleButton("\u25cb");
    private JToggleButton ellipse = new JToggleButton("\u039f");
    private ButtonGroup toolGroup = new ButtonGroup();
    private JPanel colorPallet = new JPanel(new BorderLayout());
    private JPanel colorPallet2 = new JPanel(new GridLayout(4, 4));
    private ButtonGroup colorGroup = new ButtonGroup();
    private JPanel fillPallet = new JPanel(new BorderLayout());
    private JPanel fillPallet2 = new JPanel(new GridLayout(4, 4));
    private ButtonGroup fillGroup = new ButtonGroup();
    private JCheckBox noneColor = new JCheckBox("\u7dda\u7121\u3057");
    private JCheckBox noneFill = new JCheckBox("\u5857\u6f70\u3057\u7121\u3057");
    private JCheckBox colorBlack = null;
    private JCheckBox fillBlack = null;
    private CardLayout spinnerLayout = new CardLayout();
    private JPanel spinnerPanel = new JPanel(this.spinnerLayout);
    private JPanel lineSpinnerPanel = new JPanel(this.spinnerLayout);
    private SpinnerNumberModel lineModel = new SpinnerNumberModel(1, 1, 8, 1);
    private JSpinner lineSpinner = new JSpinner(this.lineModel);
    private JPanel fontSpinnerPanel = new JPanel(this.spinnerLayout);
    private SpinnerNumberModel fontModel = new SpinnerNumberModel(12, 8, 32, 2);
    private JSpinner fontSpinner = new JSpinner(this.fontModel);
    private Color[] colors = new Color[]{Color.WHITE, new Color(0, 0, 255), new Color(0, 255, 255), new Color(0, 255, 0), new Color(255, 255, 0), new Color(255, 0, 0), new Color(255, 0, 255), Color.LIGHT_GRAY, Color.DARK_GRAY, new Color(0, 0, 128), new Color(0, 128, 128), new Color(0, 128, 0), new Color(128, 128, 0), new Color(128, 0, 0), new Color(128, 0, 128), Color.BLACK};
    private SamplePanel dummy = new SamplePanel();
    private JPanel dummyPanel = new JPanel(new BorderLayout());
    private JButton save = new JButton("Save");
    private JButton clear = new JButton("Clear");
    private CanvasPanel canvas = null;
    private List saveListeners = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public ToolBar() {
        super(1);
        this.init();
    }

    private void init() {
        this.lineSpinnerPanel.setBorder(new TitledBorder("\u7dda\u306e\u592a\u3055(px)"));
        this.fontSpinnerPanel.setBorder(new TitledBorder("\u6587\u5b57\u30b5\u30a4\u30ba(pt)"));
        this.lineSpinnerPanel.add((Component)this.lineSpinner, "Center");
        this.lineSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = ToolBar.this.lineModel.getNumber().intValue();
                ToolBar.this.canvas.setSize(value);
                ToolBar.this.dummy.setSize(value);
                ToolBar.this.dummy.update();
                ToolBar.this.dummy.repaint();
            }
        });
        this.fontSpinnerPanel.add((Component)this.fontSpinner, "Center");
        this.fontSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int value = ToolBar.this.fontModel.getNumber().intValue();
                ToolBar.this.canvas.setSize(value);
                ToolBar.this.dummy.setSize(value);
                ToolBar.this.dummy.update();
                ToolBar.this.dummy.repaint();
            }
        });
        this.spinnerPanel.add((Component)this.lineSpinnerPanel, "line");
        this.spinnerPanel.add((Component)this.fontSpinnerPanel, "font");
        this.spinnerLayout.show(this.spinnerPanel, "line");
        this.dummyPanel.setBorder(new EtchedBorder());
        Dimension size = new Dimension(30, 30);
        this.dummyPanel.setPreferredSize(size);
        this.dummyPanel.setMinimumSize(size);
        this.dummyPanel.add((Component)this.dummy, "Center");
        this.add(this.dummyPanel);
        Insets zero = new Insets(0, 0, 0, 0);
        this.select.setMargin(zero);
        this.rect.setMargin(zero);
        this.stroke.setMargin(zero);
        this.line.setMargin(zero);
        this.circle.setMargin(zero);
        this.ellipse.setMargin(zero);
        this.text.setMargin(zero);
        this.toolGroup.add(this.select);
        this.toolGroup.add(this.stroke);
        this.toolGroup.add(this.text);
        this.toolGroup.add(this.line);
        this.toolGroup.add(this.rect);
        this.toolGroup.add(this.circle);
        this.toolGroup.add(this.ellipse);
        this.toolPallet.add(this.select);
        this.toolPallet.add(this.stroke);
        this.toolPallet.add(this.text);
        this.toolPallet.add(this.line);
        this.toolPallet.add(this.rect);
        this.toolPallet.add(this.circle);
        this.toolPallet.add(this.ellipse);
        this.add(this.toolPallet);
        ActionListener colorAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.this.canvas.setColor(((JToggleButton)e.getSource()).getBackground());
                ToolBar.this.dummy.setColor(((JToggleButton)e.getSource()).getBackground());
                ToolBar.this.dummy.update();
                ToolBar.this.dummy.repaint();
            }
        };
        this.colorPallet.setBorder(new TitledBorder("\u7dda\u8272"));
        this.colorBlack = this.createPallet(colorAction, this.colorPallet2, this.colorGroup);
        this.colorBlack.setSelected(true);
        this.colorPallet.add((Component)this.colorPallet2, "Center");
        this.noneColor.setBorder(new EmptyBorder(zero));
        this.noneColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.this.canvas.setColor(null);
                ToolBar.this.dummy.setColor(null);
                ToolBar.this.dummy.update();
                ToolBar.this.dummy.repaint();
                if (ToolBar.this.noneFill.isSelected()) {
                    ToolBar.this.fillBlack.setSelected(true);
                    ToolBar.this.fillBlack.doClick();
                }
            }
        });
        this.colorPallet.add((Component)this.noneColor, "North");
        this.colorGroup.add(this.noneColor);
        ActionListener fillAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.this.canvas.setFillColor(((JToggleButton)e.getSource()).getBackground());
                ToolBar.this.dummy.setFillColor(((JToggleButton)e.getSource()).getBackground());
                ToolBar.this.dummy.update();
                ToolBar.this.dummy.repaint();
            }
        };
        this.fillPallet.setBorder(new TitledBorder("\u5857\u6f70\u3057\u8272"));
        this.fillBlack = this.createPallet(fillAction, this.fillPallet2, this.fillGroup);
        this.fillPallet.add((Component)this.fillPallet2, "Center");
        this.noneFill.setBorder(new EmptyBorder(zero));
        this.fillPallet.add((Component)this.noneFill, "North");
        this.noneFill.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.this.canvas.setFillColor(null);
                ToolBar.this.dummy.setFillColor(null);
                ToolBar.this.dummy.update();
                ToolBar.this.dummy.repaint();
                if (ToolBar.this.noneColor.isSelected()) {
                    ToolBar.this.colorBlack.setSelected(true);
                    ToolBar.this.colorBlack.doClick();
                }
            }
        });
        this.fillGroup.add(this.noneFill);
        this.noneFill.setSelected(true);
        this.add(this.colorPallet);
        this.add(this.fillPallet);
        this.add(this.spinnerPanel);
        this.add(this.clear);
        this.add(this.save);
        this.select.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ToolBar.this.canvas.setClazz(null);
                    ToolBar.this.canvas.setSelecting(true);
                    ToolBar.this.dummy.setClazz(null);
                    ToolBar.this.dummy.initItem();
                    ToolBar.this.dummy.update();
                    ToolBar.this.dummy.repaint();
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (SecurityException e1) {
                    e1.printStackTrace();
                }
                catch (InstantiationException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
                catch (NoSuchMethodException e1) {
                    e1.printStackTrace();
                }
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cx.ath.kgslab.svgeditor.items.Rect");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.rect.addActionListener(new ItemsActionListener(clazz));
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("cx.ath.kgslab.svgeditor.items.Stroke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.stroke.addActionListener(new ItemsActionListener(clazz2));
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("cx.ath.kgslab.svgeditor.items.Line");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.line.addActionListener(new ItemsActionListener(clazz3));
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("cx.ath.kgslab.svgeditor.items.Circle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.circle.addActionListener(new ItemsActionListener(clazz4));
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("cx.ath.kgslab.svgeditor.items.Ellipse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ellipse.addActionListener(new ItemsActionListener(clazz5));
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("cx.ath.kgslab.svgeditor.items.Text");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.text.addActionListener(new ItemsActionListener(clazz6));
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.this.saveSvg();
            }
        });
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ToolBar.this.canvas.setStrokes(new ArrayList());
                ToolBar.this.canvas.update();
                ToolBar.this.canvas.repaint();
            }
        });
    }

    private JCheckBox createPallet(ActionListener colorAction, JPanel pallet, ButtonGroup group) {
        Insets zero = new Insets(0, 0, 0, 0);
        JCheckBox button = null;
        int idx = 0;
        while (idx < this.colors.length) {
            button = new JCheckBox();
            button.setBorder(new EmptyBorder(zero));
            button.setOpaque(true);
            button.setBackground(this.colors[idx]);
            button.setMargin(zero);
            pallet.add(button);
            group.add(button);
            button.addActionListener(colorAction);
            ++idx;
        }
        return button;
    }

    private void saveSvg() {
        List list = this.canvas.getStrokes();
        StringBuffer buf = new StringBuffer("<?xml version='1.0' encoding='UTF-8' ?>\n");
        buf.append("<svg");
        buf.append(" xmlns='").append("http://www.w3.org/2000/svg").append("'");
        buf.append(" xml:space='").append("default").append("'");
        buf.append(" width='").append(this.canvas.getWidth()).append("'");
        buf.append(" height='").append(this.canvas.getHeight()).append("'>\n");
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            Item element = (Item)ite.next();
            buf.append(element.getSvgElement()).append('\n');
        }
        buf.append("</svg>");
        try {
            this.save(buf.toString());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public CanvasPanel getCanvas() {
        return this.canvas;
    }

    public void setCanvas(CanvasPanel panel) {
        this.canvas = panel;
    }

    public void save(String svg) throws Exception {
        Iterator ite = this.saveListeners.iterator();
        while (ite.hasNext()) {
            SaveListener element = (SaveListener)ite.next();
            element.save(svg);
        }
    }

    public void addSaveListener(SaveListener listener) {
        if (listener != null) {
            this.saveListeners.add(listener);
        }
    }

    private class ItemsActionListener
    implements ActionListener {
        Class clazz = null;
        static /* synthetic */ Class class$0;

        public ItemsActionListener(Class clazz) {
            this.clazz = clazz;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("cx.ath.kgslab.svgeditor.items.Text");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.clazz.equals(clazz)) {
                    ToolBar.this.spinnerLayout.show(ToolBar.this.spinnerPanel, "font");
                    int value = ToolBar.this.fontModel.getNumber().intValue();
                    ToolBar.this.canvas.setSize(value);
                    ToolBar.this.dummy.setSize(value);
                } else {
                    ToolBar.this.spinnerLayout.show(ToolBar.this.spinnerPanel, "line");
                    int value = ToolBar.this.lineModel.getNumber().intValue();
                    ToolBar.this.canvas.setSize(value);
                    ToolBar.this.dummy.setSize(value);
                }
                ToolBar.this.canvas.setClazz(this.clazz);
                ToolBar.this.canvas.setSelecting(false);
                ToolBar.this.dummy.setClazz(this.clazz);
                ToolBar.this.dummy.initItem();
                ToolBar.this.dummy.update();
                ToolBar.this.dummy.repaint();
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
        }
    }
}

