/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.util.ClosableResource;
import com.mchange.v2.c3p0.impl.C3P0CallableStatement;
import com.mchange.v2.c3p0.impl.C3P0PreparedStatement;
import com.mchange.v2.c3p0.impl.C3P0Statement;
import com.mchange.v2.c3p0.impl.SetManagedDatabaseMetaData;
import com.mchange.v2.c3p0.impl.SetManagedResultSet;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.util.ConnectionEventSupport;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public final class C3P0PooledConnection
implements PooledConnection,
ClosableResource {
    static final ClassLoader CL = (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection).getClassLoader();
    static final Class[] PROXY_CTOR_ARGS = new Class[]{class$java$lang$reflect$InvocationHandler == null ? (class$java$lang$reflect$InvocationHandler = C3P0PooledConnection.class$("java.lang.reflect.InvocationHandler")) : class$java$lang$reflect$InvocationHandler};
    static final Constructor CON_PROXY_CTOR;
    static final Constructor STMT_PROXY_CTOR;
    static final Constructor PSTMT_PROXY_CTOR;
    static final Constructor CSTMT_PROXY_CTOR;
    static final Constructor RS_PROXY_CTOR;
    static final Method RS_CLOSE_METHOD;
    static final Method STMT_CLOSE_METHOD;
    static final Object[] CLOSE_ARGS;
    static final Set OBJECT_METHODS;
    final boolean autoCommitOnClose;
    final boolean forceIgnoreUnresolvedTransactions;
    final ConnectionEventSupport ces = new ConnectionEventSupport(this);
    volatile Connection physicalConnection;
    ProxyConnection exposedProxy;
    final Set uncachedActiveStatements = Collections.synchronizedSet(new HashSet());
    volatile GooGooStatementCache scache;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnection;
    static /* synthetic */ Class class$java$lang$reflect$InvocationHandler;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$CallableStatement;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$lang$Object;

    private static Constructor createProxyConstructor(Class intfc) throws NoSuchMethodException {
        Class[] proxyInterfaces = new Class[]{intfc};
        Class<?> proxyCl = Proxy.getProxyClass(CL, proxyInterfaces);
        return proxyCl.getConstructor(PROXY_CTOR_ARGS);
    }

    public C3P0PooledConnection(Connection con, boolean autoCommitOnClose, boolean forceIgnoreUnresolvedTransactions) {
        this.physicalConnection = con;
        this.autoCommitOnClose = autoCommitOnClose;
        this.forceIgnoreUnresolvedTransactions = forceIgnoreUnresolvedTransactions;
    }

    Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    boolean isClosed() throws SQLException {
        return this.physicalConnection == null;
    }

    void initStatementCache(GooGooStatementCache scache) {
        this.scache = scache;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.exposedProxy != null) {
            System.err.println("c3p0 -- Uh oh... getConnection() was called on a PooledConnection when it had already provided a client with a Connection that has not yet been closed. This probably indicates a bug in the connection pool!!!");
            return this.exposedProxy;
        }
        try {
            this.ensureOkay();
            this.exposedProxy = this.createProxyConnection();
            return this.exposedProxy;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Failed to acquire connection!");
        }
    }

    public void closeAll() throws SQLException {
        if (this.scache != null) {
            this.scache.closeAll(this.physicalConnection);
        }
    }

    public synchronized void close() throws SQLException {
        if (this.physicalConnection != null) {
            try {
                Exception exc = this.cleanupUncachedActiveStatements();
                if (exc != null) {
                    exc.printStackTrace();
                }
                try {
                    if (this.exposedProxy != null) {
                        this.exposedProxy.silentClose();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exc = e;
                }
                try {
                    this.closeAll();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exc = e;
                }
                try {
                    this.physicalConnection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    exc = e;
                }
                if (exc != null) {
                    throw new SQLException("At least one error occurred while attempting to close() the PooledConnection: " + exc);
                }
                Object var4_6 = null;
                this.physicalConnection = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.physicalConnection = null;
                throw throwable;
            }
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.ces.addConnectionEventListener(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.ces.removeConnectionEventListener(listener);
    }

    private void reset() throws SQLException {
        this.ensureOkay();
        if (!this.forceIgnoreUnresolvedTransactions && !this.physicalConnection.getAutoCommit()) {
            if (this.autoCommitOnClose) {
                this.physicalConnection.commit();
            } else {
                this.physicalConnection.rollback();
            }
            this.physicalConnection.setAutoCommit(true);
        }
    }

    boolean closeAndRemoveResultSets(Set rsSet) {
        boolean okay = true;
        Set set = rsSet;
        synchronized (set) {
            Iterator ii = rsSet.iterator();
            while (ii.hasNext()) {
                Object var8_7;
                ResultSet rs = (ResultSet)ii.next();
                try {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        okay = false;
                        var8_7 = null;
                        ii.remove();
                        continue;
                    }
                    var8_7 = null;
                    ii.remove();
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    ii.remove();
                    throw throwable;
                }
            }
        }
        return okay;
    }

    void ensureOkay() throws SQLException {
        if (this.physicalConnection == null) {
            throw new SQLException("Connection is broken");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean closeAndRemoveResourcesInSet(Set s, Method closeMethod) {
        HashSet temp;
        boolean okay = true;
        Set set = s;
        synchronized (set) {
            temp = new HashSet(s);
        }
        Iterator ii = temp.iterator();
        while (ii.hasNext()) {
            Object var11_10;
            Object rsrc = ii.next();
            try {
                try {
                    closeMethod.invoke(rsrc, CLOSE_ARGS);
                }
                catch (Exception e) {
                    Throwable t = e;
                    if (t instanceof InvocationTargetException) {
                        t = ((InvocationTargetException)e).getTargetException();
                    }
                    t.printStackTrace();
                    okay = false;
                    var11_10 = null;
                    s.remove(rsrc);
                    continue;
                }
                var11_10 = null;
                s.remove(rsrc);
            }
            catch (Throwable throwable) {
                var11_10 = null;
                s.remove(rsrc);
                throw throwable;
            }
        }
        return okay;
    }

    private SQLException cleanupUncachedActiveStatements() {
        boolean okay = this.closeAndRemoveResourcesInSet(this.uncachedActiveStatements, STMT_CLOSE_METHOD);
        if (okay) {
            return null;
        }
        return new SQLException("An exception occurred while trying to clean up orphaned resources.");
    }

    ProxyConnection createProxyConnection() throws Exception {
        ProxyConnectionInvocationHandler handler = new ProxyConnectionInvocationHandler();
        return (ProxyConnection)CON_PROXY_CTOR.newInstance(handler);
    }

    Statement createProxyStatement(Statement innerStmt, Constructor stmtProxyCtor) throws Exception {
        return this.createProxyStatement(false, innerStmt, stmtProxyCtor);
    }

    Statement createProxyStatement(final boolean inner_is_cached, final Statement innerStmt, Constructor stmtProxyCtor) throws Exception {
        final Set activeResultSets = Collections.synchronizedSet(new HashSet());
        final SetManagedResultSet mainResultSet = new SetManagedResultSet(activeResultSets);
        if (innerStmt instanceof CallableStatement) {
            return new C3P0CallableStatement((CallableStatement)innerStmt){
                WrapperStatementHelper wsh;
                {
                    class WrapperStatementHelper {
                        Statement wrappedStmt;
                        private final /* synthetic */ boolean val$inner_is_cached;
                        private final /* synthetic */ Set val$activeResultSets;
                        private final /* synthetic */ SetManagedResultSet val$mainResultSet;
                        private final /* synthetic */ Statement val$innerStmt;

                        public WrapperStatementHelper(boolean val$inner_is_cached, Set val$activeResultSets, SetManagedResultSet val$mainResultSet, Statement val$innerStmt, Statement wrappedStmt) {
                            this.val$inner_is_cached = val$inner_is_cached;
                            this.val$activeResultSets = val$activeResultSets;
                            this.val$mainResultSet = val$mainResultSet;
                            this.val$innerStmt = val$innerStmt;
                            this.wrappedStmt = wrappedStmt;
                            if (!val$inner_is_cached) {
                                C3P0PooledConnection.this.uncachedActiveStatements.add(wrappedStmt);
                            }
                        }

                        private boolean closeAndRemoveActiveResultSets() {
                            return C3P0PooledConnection.this.closeAndRemoveResultSets(this.val$activeResultSets);
                        }

                        public ResultSet wrap(ResultSet rs) {
                            if (this.val$mainResultSet.getInner() == null) {
                                this.val$mainResultSet.setInner(rs);
                                return this.val$mainResultSet;
                            }
                            SetManagedResultSet out = new SetManagedResultSet(this.val$activeResultSets);
                            out.setInner(rs);
                            return out;
                        }

                        public void doClose() throws SQLException {
                            boolean okay = this.closeAndRemoveActiveResultSets();
                            if (this.val$inner_is_cached) {
                                C3P0PooledConnection.this.scache.checkinStatement(this.val$innerStmt);
                            } else {
                                this.val$innerStmt.close();
                                C3P0PooledConnection.this.uncachedActiveStatements.remove(this.wrappedStmt);
                            }
                            if (!okay) {
                                throw new SQLException("Failed to close an orphaned ResultSet properly.");
                            }
                        }
                    }
                    this.wsh = new WrapperStatementHelper(inner_is_cached, activeResultSets, mainResultSet, innerStmt, this);
                }

                public ResultSet getResultSet() throws SQLException {
                    return this.wsh.wrap(super.getResultSet());
                }

                public ResultSet executeQuery(String sql) throws SQLException {
                    return this.wsh.wrap(super.executeQuery(sql));
                }

                public ResultSet executeQuery() throws SQLException {
                    return this.wsh.wrap(super.executeQuery());
                }

                public void close() throws SQLException {
                    this.wsh.doClose();
                }
            };
        }
        if (innerStmt instanceof PreparedStatement) {
            return new C3P0PreparedStatement((PreparedStatement)innerStmt){
                WrapperStatementHelper wsh;
                {
                    this.wsh = new WrapperStatementHelper(inner_is_cached, activeResultSets, mainResultSet, innerStmt, this);
                }

                public ResultSet getResultSet() throws SQLException {
                    return this.wsh.wrap(super.getResultSet());
                }

                public ResultSet executeQuery(String sql) throws SQLException {
                    return this.wsh.wrap(super.executeQuery(sql));
                }

                public ResultSet executeQuery() throws SQLException {
                    return this.wsh.wrap(super.executeQuery());
                }

                public void close() throws SQLException {
                    this.wsh.doClose();
                }
            };
        }
        return new C3P0Statement(innerStmt){
            WrapperStatementHelper wsh;
            {
                this.wsh = new WrapperStatementHelper(inner_is_cached, activeResultSets, mainResultSet, innerStmt, this);
            }

            public ResultSet getResultSet() throws SQLException {
                return this.wsh.wrap(super.getResultSet());
            }

            public ResultSet executeQuery(String sql) throws SQLException {
                return this.wsh.wrap(super.executeQuery(sql));
            }

            public void close() throws SQLException {
                this.wsh.doClose();
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            CON_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection == null ? (class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection = C3P0PooledConnection.class$("com.mchange.v2.c3p0.impl.C3P0PooledConnection$ProxyConnection")) : class$com$mchange$v2$c3p0$impl$C3P0PooledConnection$ProxyConnection);
            STMT_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$java$sql$Statement == null ? (class$java$sql$Statement = C3P0PooledConnection.class$("java.sql.Statement")) : class$java$sql$Statement);
            PSTMT_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = C3P0PooledConnection.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
            CSTMT_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = C3P0PooledConnection.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement);
            RS_PROXY_CTOR = C3P0PooledConnection.createProxyConstructor(class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = C3P0PooledConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet);
            Class[] argClasses = new Class[]{};
            RS_CLOSE_METHOD = (class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = C3P0PooledConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet).getMethod("close", argClasses);
            STMT_CLOSE_METHOD = (class$java$sql$Statement == null ? (class$java$sql$Statement = C3P0PooledConnection.class$("java.sql.Statement")) : class$java$sql$Statement).getMethod("close", argClasses);
            CLOSE_ARGS = new Object[0];
            OBJECT_METHODS = Collections.unmodifiableSet(new HashSet<Method>(Arrays.asList((class$java$lang$Object == null ? (class$java$lang$Object = C3P0PooledConnection.class$("java.lang.Object")) : class$java$lang$Object).getMethods())));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError("Something is very wrong, or this is a pre 1.3 JVM.We cannot set up dynamic proxies and/or methods!");
        }
    }

    static interface ProxyConnection
    extends Connection {
        public void silentClose() throws SQLException;
    }

    class ProxyConnectionInvocationHandler
    implements InvocationHandler {
        volatile Connection activeConnection;
        volatile DatabaseMetaData metaData;
        final Set activeMetaDataResultSets;

        ProxyConnectionInvocationHandler() {
            this.activeConnection = C3P0PooledConnection.this.physicalConnection;
            this.metaData = null;
            this.activeMetaDataResultSets = Collections.synchronizedSet(new HashSet());
        }

        private Exception doSilentClose(Object pc) {
            C3P0PooledConnection c3P0PooledConnection = C3P0PooledConnection.this;
            synchronized (c3P0PooledConnection) {
                if (C3P0PooledConnection.this.exposedProxy == pc) {
                    C3P0PooledConnection.this.exposedProxy = null;
                }
            }
            this.activeConnection = null;
            Throwable out = null;
            Exception exc1 = null;
            SQLException exc2 = null;
            Throwable exc3 = null;
            Exception exc4 = null;
            try {
                C3P0PooledConnection.this.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
                exc1 = e;
            }
            exc2 = C3P0PooledConnection.this.cleanupUncachedActiveStatements();
            if (exc2 != null) {
                exc2.printStackTrace();
            }
            if (!C3P0PooledConnection.this.closeAndRemoveResultSets(this.activeMetaDataResultSets)) {
                exc3 = new SQLException("Failed to close some DatabaseMetaData Result Sets.");
            }
            if (exc3 != null) {
                exc3.printStackTrace();
            }
            if (C3P0PooledConnection.this.scache != null) {
                try {
                    C3P0PooledConnection.this.scache.checkinAll(C3P0PooledConnection.this.physicalConnection);
                }
                catch (Exception e) {
                    exc4 = e;
                }
                if (exc4 != null) {
                    exc4.printStackTrace();
                }
            }
            if (exc1 != null) {
                out = exc1;
            } else if (exc2 != null) {
                out = exc2;
            } else if (exc3 != null) {
                out = exc3;
            } else if (exc4 != null) {
                out = exc4;
            }
            return out;
        }

        public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
            if (OBJECT_METHODS.contains(m)) {
                return m.invoke((Object)this, args);
            }
            C3P0PooledConnection.this.ensureOkay();
            try {
                String mname = m.getName();
                if (this.activeConnection != null) {
                    if (mname.equals("createStatement")) {
                        Object stmt = m.invoke((Object)this.activeConnection, args);
                        return C3P0PooledConnection.this.createProxyStatement((Statement)stmt, STMT_PROXY_CTOR);
                    }
                    if (mname.equals("prepareStatement")) {
                        if (C3P0PooledConnection.this.scache == null) {
                            Object pstmt = m.invoke((Object)this.activeConnection, args);
                            return C3P0PooledConnection.this.createProxyStatement((Statement)pstmt, PSTMT_PROXY_CTOR);
                        }
                        Object pstmt = C3P0PooledConnection.this.scache.checkoutStatement(C3P0PooledConnection.this.physicalConnection, m, args);
                        return C3P0PooledConnection.this.createProxyStatement(true, (Statement)pstmt, PSTMT_PROXY_CTOR);
                    }
                    if (mname.equals("prepareCall")) {
                        if (C3P0PooledConnection.this.scache == null) {
                            Object cstmt = m.invoke((Object)this.activeConnection, args);
                            return C3P0PooledConnection.this.createProxyStatement((Statement)cstmt, CSTMT_PROXY_CTOR);
                        }
                        Object cstmt = C3P0PooledConnection.this.scache.checkoutStatement(C3P0PooledConnection.this.physicalConnection, m, args);
                        return C3P0PooledConnection.this.createProxyStatement(true, (Statement)cstmt, CSTMT_PROXY_CTOR);
                    }
                    if (mname.equals("getMetaData")) {
                        DatabaseMetaData innerMd = this.activeConnection.getMetaData();
                        if (this.metaData == null) {
                            this.metaData = new SetManagedDatabaseMetaData(innerMd, this.activeMetaDataResultSets);
                        }
                        return this.metaData;
                    }
                    if (mname.equals("silentClose")) {
                        this.doSilentClose(proxy);
                        return null;
                    }
                    if (mname.equals("close")) {
                        Exception e = this.doSilentClose(proxy);
                        C3P0PooledConnection.this.ces.fireConnectionClosed();
                        if (e != null) {
                            throw e;
                        }
                        return null;
                    }
                    return m.invoke((Object)this.activeConnection, args);
                }
                if (mname.equals("close") || mname.equals("silentClose")) {
                    return null;
                }
                if (mname.equals("isClosed")) {
                    return new Boolean(true);
                }
                throw new SQLException("You can't operate on a closed connection!!!");
            }
            catch (InvocationTargetException e) {
                Throwable throwMe = e.getTargetException();
                SQLException sqle = SqlUtils.toSQLException(throwMe);
                C3P0PooledConnection.this.ces.fireConnectionErrorOccurred(sqle);
                throw sqle;
            }
        }
    }
}

