/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.stmt;

import com.mchange.v1.db.sql.StatementUtils;
import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.c3p0.stmt.StatementCacheKey;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;

public final class GooGooStatementCache {
    HashMap cxnToStmtSets = new HashMap();
    HashMap stmtToKey = new HashMap();
    HashMap keyToKeyRec = new HashMap();
    TreeMap longsToStmts = new TreeMap();
    HashMap stmtsToLongs = new HashMap();
    HashSet checkedOut = new HashSet();
    long last_long = -1L;
    int stmt_count;
    AsynchronousRunner blockingTaskAsyncRunner;
    int max_statements;

    public GooGooStatementCache(AsynchronousRunner blockingTaskAsyncRunner, int max_statements) {
        this.blockingTaskAsyncRunner = blockingTaskAsyncRunner;
        this.max_statements = max_statements;
    }

    public synchronized Object checkoutStatement(Connection physicalConnection, Method stmtProducingMethod, Object[] args) throws SQLException {
        Object out = null;
        StatementCacheKey key = StatementCacheKey.find(physicalConnection, stmtProducingMethod, args);
        LinkedList l = this.checkoutQueue(key);
        if (l == null || l.isEmpty()) {
            out = this.acquireStatement(physicalConnection, stmtProducingMethod, args);
            int size = this.countCachedStatements();
            if (size < this.max_statements || size == this.max_statements && this.cullFromDeathmarch()) {
                this.assimilateNewCheckedOutStatement(key, physicalConnection, out);
            }
        } else {
            out = l.get(0);
            l.remove(0);
            this.undeathmarchStatement(out);
            if (!this.checkedOut.add(out)) {
                throw new RuntimeException("Internal inconsistency: Checking out a statement marked as already checked out!");
            }
        }
        return out;
    }

    public synchronized void checkinStatement(Object pstmt) throws SQLException {
        if (!this.checkedOut.remove(pstmt)) {
            if (!this.ourResource(pstmt)) {
                this.destroyStatement(pstmt);
            }
            return;
        }
        try {
            this.refreshStatement((PreparedStatement)pstmt);
        }
        catch (Exception e) {
            System.err.println("Problem with checked-in Statement, discarding.");
            e.printStackTrace();
            this.removeStatement(pstmt, true);
            return;
        }
        StatementCacheKey key = (StatementCacheKey)this.stmtToKey.get(pstmt);
        if (key == null) {
            throw new RuntimeException("Internal inconsistency: A checked-out statement has no key associated with it!");
        }
        LinkedList l = this.checkoutQueue(key);
        l.add(pstmt);
        this.deathmarchStatement(pstmt);
    }

    public synchronized void checkinAll(Connection pcon) throws SQLException {
        HashSet stmtSet = this.connectionSet(pcon);
        if (stmtSet != null) {
            Iterator ii = stmtSet.iterator();
            while (ii.hasNext()) {
                Object stmt = ii.next();
                if (!this.checkedOut.contains(stmt)) continue;
                this.checkinStatement(stmt);
            }
        }
    }

    public synchronized void closeAll(Connection pcon) throws SQLException {
        HashSet cSet = this.connectionSet(pcon);
        if (cSet != null) {
            HashSet stmtSet = (HashSet)cSet.clone();
            Iterator ii = stmtSet.iterator();
            while (ii.hasNext()) {
                Object stmt = ii.next();
                this.removeStatement(stmt, true);
            }
        }
    }

    public synchronized void close() throws SQLException {
        Iterator ii = this.stmtToKey.keySet().iterator();
        while (ii.hasNext()) {
            this.destroyStatement(ii.next());
        }
        this.cxnToStmtSets = null;
        this.stmtToKey = null;
        this.keyToKeyRec = null;
        this.longsToStmts = null;
        this.stmtsToLongs = null;
        this.checkedOut = null;
        this.stmt_count = -1;
    }

    private void destroyStatement(final Object pstmt) {
        Runnable r = new Runnable(){

            public void run() {
                StatementUtils.attemptClose((PreparedStatement)pstmt);
            }
        };
        this.blockingTaskAsyncRunner.postRunnable(r);
    }

    private void assimilateNewCheckedOutStatement(StatementCacheKey key, Connection pConn, Object ps) {
        this.stmtToKey.put(ps, key);
        HashSet ks = this.keySet(key);
        if (ks == null) {
            this.keyToKeyRec.put(key, new KeyRec());
        }
        this.keySet(key).add(ps);
        HashSet<Object> cSet = this.connectionSet(pConn);
        if (cSet == null) {
            cSet = new HashSet<Object>();
            this.cxnToStmtSets.put(pConn, cSet);
        }
        cSet.add(ps);
        ++this.stmt_count;
        this.checkedOut.add(ps);
    }

    private void removeStatement(Object ps, boolean force_destroy) {
        StatementCacheKey sck = (StatementCacheKey)this.stmtToKey.remove(ps);
        this.removeFromKeySet(sck, ps);
        Connection pConn = sck.physicalConnection;
        this.removeFromConnectionSet(pConn, ps);
        --this.stmt_count;
        if (!this.checkedOut.contains(ps)) {
            this.undeathmarchStatement(ps);
            this.removeFromCheckoutQueue(sck, ps);
            this.destroyStatement(ps);
        } else {
            this.checkedOut.remove(ps);
            if (force_destroy) {
                this.destroyStatement(ps);
            }
        }
    }

    private boolean cullFromDeathmarch() {
        if (this.longsToStmts.isEmpty()) {
            return false;
        }
        Long l = (Long)this.longsToStmts.firstKey();
        Object ps = this.longsToStmts.get(l);
        this.removeStatement(ps, true);
        return true;
    }

    private Object acquireStatement(final Connection pConn, final Method stmtProducingMethod, final Object[] args) throws SQLException {
        try {
            final Object[] outHolder = new Object[1];
            final SQLException[] exceptionHolder = new SQLException[1];
            Runnable r = new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    GooGooStatementCache gooGooStatementCache;
                    try {
                        try {
                            outHolder[0] = stmtProducingMethod.invoke((Object)pConn, args);
                        }
                        catch (InvocationTargetException e) {
                            Throwable targetException = e.getTargetException();
                            exceptionHolder[0] = targetException instanceof SQLException ? (SQLException)targetException : SqlUtils.toSQLException(targetException);
                            Object var4_2 = null;
                            GooGooStatementCache gooGooStatementCache3 = GooGooStatementCache.this;
                            synchronized (gooGooStatementCache3) {
                                GooGooStatementCache.this.notifyAll();
                                return;
                            }
                        }
                        catch (Exception e) {
                            exceptionHolder[0] = SqlUtils.toSQLException(e);
                            Object var4_3 = null;
                            GooGooStatementCache gooGooStatementCache4 = GooGooStatementCache.this;
                            synchronized (gooGooStatementCache4) {
                                GooGooStatementCache.this.notifyAll();
                                return;
                            }
                        }
                        Object var4_1 = null;
                        gooGooStatementCache = GooGooStatementCache.this;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        GooGooStatementCache gooGooStatementCache2 = GooGooStatementCache.this;
                        synchronized (gooGooStatementCache2) {
                            GooGooStatementCache.this.notifyAll();
                            throw throwable;
                        }
                    }
                    synchronized (gooGooStatementCache) {
                        GooGooStatementCache.this.notifyAll();
                        return;
                    }
                }
            };
            this.blockingTaskAsyncRunner.postRunnable(r);
            while (outHolder[0] == null && exceptionHolder[0] == null) {
                this.wait();
            }
            if (exceptionHolder[0] != null) {
                throw exceptionHolder[0];
            }
            Object out = outHolder[0];
            return out;
        }
        catch (InterruptedException e) {
            throw SqlUtils.toSQLException(e);
        }
    }

    private HashSet connectionSet(Connection pcon) {
        return (HashSet)this.cxnToStmtSets.get(pcon);
    }

    private boolean removeFromConnectionSet(Connection pcon, Object stmt) {
        boolean out;
        HashSet stmtSet = (HashSet)this.cxnToStmtSets.get(pcon);
        if (stmtSet != null) {
            out = stmtSet.remove(stmt);
            if (stmtSet.isEmpty()) {
                this.cxnToStmtSets.remove(pcon);
            }
        } else {
            out = false;
        }
        return out;
    }

    private KeyRec keyRec(StatementCacheKey key) {
        return (KeyRec)this.keyToKeyRec.get(key);
    }

    private HashSet keySet(StatementCacheKey key) {
        KeyRec rec = this.keyRec(key);
        return rec == null ? null : rec.allStmts;
    }

    private boolean removeFromKeySet(StatementCacheKey key, Object pstmt) {
        HashSet stmtSet = this.keySet(key);
        boolean out = stmtSet.remove(pstmt);
        if (stmtSet.isEmpty() && this.checkoutQueue(key).isEmpty()) {
            this.keyToKeyRec.remove(key);
        }
        return out;
    }

    private LinkedList checkoutQueue(StatementCacheKey key) {
        KeyRec rec = this.keyRec(key);
        return rec == null ? null : rec.checkoutQueue;
    }

    private boolean removeFromCheckoutQueue(StatementCacheKey key, Object pstmt) {
        LinkedList q = this.checkoutQueue(key);
        boolean out = q.remove(pstmt);
        if (q.isEmpty() && this.keySet(key).isEmpty()) {
            this.keyToKeyRec.remove(key);
        }
        return out;
    }

    private void deathmarchStatement(Object ps) {
        Long old = (Long)this.stmtsToLongs.get(ps);
        if (old != null) {
            throw new RuntimeException("Internal inconsistency: A checking-in statement is already in deathmarch.");
        }
        Long youth = this.getNextLong();
        this.stmtsToLongs.put(ps, youth);
        this.longsToStmts.put(youth, ps);
    }

    private void undeathmarchStatement(Object ps) {
        Long old = (Long)this.stmtsToLongs.remove(ps);
        if (old == null) {
            throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
        }
        Object check = this.longsToStmts.remove(old);
        if (old == null) {
            throw new RuntimeException("Internal inconsistency: A (not new) checking-out statement is not in deathmarch.");
        }
    }

    private boolean isCheckedIn(Object ps) {
        return this.stmtsToLongs.keySet().contains(ps);
    }

    private boolean ourResource(Object ps) {
        return this.stmtToKey.keySet().contains(ps);
    }

    private void refreshStatement(PreparedStatement ps) throws Exception {
        ps.clearParameters();
    }

    private int countCachedStatements() {
        return this.stmtToKey.size();
    }

    private Long getNextLong() {
        return new Long(++this.last_long);
    }

    private void printStats() {
        int total_size = this.countCachedStatements();
        int checked_out_size = this.checkedOut.size();
        int checked_in_size_stmts = this.stmtsToLongs.size();
        int checked_in_size_longs = this.longsToStmts.size();
        int num_connections = this.cxnToStmtSets.size();
        int num_keys = this.keyToKeyRec.size();
        System.err.println("GooGooStatementCache stats:");
        System.err.println("\ttotal size: " + total_size);
        System.err.println("\tchecked out: " + checked_out_size);
        System.err.println("\tchecked in (deathmarch stmts): " + checked_in_size_stmts);
        System.err.println("\tchecked in (deathmarch longs): " + checked_in_size_longs);
        System.err.println("\tnum connections: " + num_connections);
        System.err.println("\tnum keys: " + num_keys);
        if (total_size != checked_out_size + checked_in_size_stmts || checked_in_size_stmts != checked_in_size_longs) {
            throw new RuntimeException("Inconsistency!");
        }
    }

    private static class KeyRec {
        HashSet allStmts = new HashSet();
        LinkedList checkoutQueue = new LinkedList();

        private KeyRec() {
        }
    }
}

