/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.resourcepool;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.holders.SynchronizedIntHolder;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolEventSupport;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolListener;
import com.mchange.v2.resourcepool.ResourcePoolUtils;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.util.ResourceClosedException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

class BasicResourcePool
implements ResourcePool {
    static final int CULL_FREQUENCY_DIVISOR = 8;
    HashMap managed = new HashMap();
    LinkedList unused = new LinkedList();
    HashSet excluded = new HashSet();
    ResourcePool.Manager mgr;
    BasicResourcePoolFactory factory;
    AsynchronousRunner taskRunner;
    RunnableQueue asyncEventQueue;
    Timer cullAndIdleRefurbishTimer;
    TimerTask cullTask;
    TimerTask idleRefurbishTask;
    HashSet interruptableWaiters = new HashSet();
    Set idleCheckResources = new HashSet();
    ResourcePoolEventSupport rpes = new ResourcePoolEventSupport(this);
    boolean broken = false;
    Object exampleResource;
    int start;
    int min;
    int max;
    int inc;
    int num_acq_attempts;
    int acq_attempt_delay;
    long check_idle_resources_delay;
    long max_resource_age;
    boolean age_is_absolute;
    SynchronizedIntHolder pendingAcquiresCounter = new SynchronizedIntHolder();

    public BasicResourcePool(ResourcePool.Manager mgr, int start, int min, int max, int inc, int num_acq_attempts, int acq_attempt_delay, long check_idle_resources_delay, long max_resource_age, boolean age_is_absolute, AsynchronousRunner taskRunner, RunnableQueue asyncEventQueue, Timer cullAndIdleRefurbishTimer, BasicResourcePoolFactory factory) throws ResourcePoolException {
        try {
            this.mgr = mgr;
            this.start = start;
            this.min = min;
            this.max = max;
            this.inc = inc;
            this.num_acq_attempts = num_acq_attempts;
            this.acq_attempt_delay = acq_attempt_delay;
            this.check_idle_resources_delay = check_idle_resources_delay;
            this.max_resource_age = max_resource_age;
            this.age_is_absolute = age_is_absolute;
            this.factory = factory;
            this.taskRunner = taskRunner;
            this.asyncEventQueue = asyncEventQueue;
            this.cullAndIdleRefurbishTimer = cullAndIdleRefurbishTimer;
            this.pendingAcquiresCounter.setValue(0);
            this.ensureStartResources();
            if (max_resource_age > 0L) {
                long cull_frequency = max_resource_age / 8L;
                this.cullTask = new CullTask();
                cullAndIdleRefurbishTimer.schedule(this.cullTask, max_resource_age, cull_frequency);
            } else {
                age_is_absolute = false;
            }
            if (check_idle_resources_delay > 0L) {
                this.idleRefurbishTask = new CheckIdleResourcesTask();
                cullAndIdleRefurbishTimer.schedule(this.idleRefurbishTask, check_idle_resources_delay, check_idle_resources_delay);
            }
        }
        catch (Exception e) {
            throw ResourcePoolUtils.convertThrowable(e);
        }
    }

    public Object checkoutResource() throws ResourcePoolException, InterruptedException {
        try {
            return this.checkoutResource(0L);
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            throw new ResourcePoolException("Huh??? TimeoutException with no timeout set!!!");
        }
    }

    public synchronized Object checkoutResource(long timeout) throws TimeoutException, ResourcePoolException, InterruptedException {
        try {
            this.ensureNotBroken();
            int available = this.unused.size();
            if (available == 0) {
                int msz = this.managed.size();
                if (msz < this.max) {
                    this.postAcquireMore();
                }
                this.awaitAcquire(timeout);
            }
            Object resc = this.unused.get(0);
            this.unused.remove(0);
            if (this.idleCheckResources.contains(resc)) {
                this.unused.add(resc);
                Thread t = Thread.currentThread();
                this.interruptableWaiters.add(t);
                this.wait(timeout);
                this.interruptableWaiters.remove(t);
                return this.checkoutResource(timeout);
            }
            if (this.isExpired(resc) || !this.attemptRefurbishResourceOnCheckout(resc)) {
                this.removeResource(resc);
                this.ensureMinResources();
                return this.checkoutResource(timeout);
            }
            this.asyncFireResourceCheckedOut(resc, this.managed.size(), this.unused.size(), this.excluded.size());
            return resc;
        }
        catch (ResourceClosedException e) {
            e.printStackTrace();
            this.unexpectedBreak();
            throw e;
        }
    }

    public synchronized void checkinResource(Object resc) throws ResourcePoolException {
        block4: {
            try {
                if (this.managed.keySet().contains(resc)) {
                    this.doCheckinManaged(resc);
                    break block4;
                }
                if (this.excluded.contains(resc)) {
                    this.doCheckinExcluded(resc);
                    break block4;
                }
                throw new ResourcePoolException("ResourcePool: Tried to check-in a foreign resource!");
            }
            catch (ResourceClosedException e) {
                e.printStackTrace();
                this.unexpectedBreak();
            }
        }
    }

    public synchronized void checkinAll() throws ResourcePoolException {
        try {
            HashSet checkedOutNotExcluded = new HashSet(this.managed.keySet());
            checkedOutNotExcluded.removeAll(this.unused);
            Iterator ii = checkedOutNotExcluded.iterator();
            while (ii.hasNext()) {
                this.doCheckinManaged(ii.next());
            }
            Iterator ii2 = this.excluded.iterator();
            while (ii2.hasNext()) {
                this.doCheckinExcluded(ii2.next());
            }
        }
        catch (ResourceClosedException e) {
            e.printStackTrace();
            this.unexpectedBreak();
        }
    }

    public synchronized int statusInPool(Object resc) throws ResourcePoolException {
        try {
            if (this.unused.contains(resc)) {
                return 0;
            }
            if (this.managed.keySet().contains(resc) || this.excluded.contains(resc)) {
                return 1;
            }
            return -1;
        }
        catch (ResourceClosedException e) {
            e.printStackTrace();
            this.unexpectedBreak();
            throw e;
        }
    }

    public synchronized void markBroken(Object resc) {
        try {
            this._markBroken(resc);
            this.ensureMinResources();
        }
        catch (ResourceClosedException e) {
            e.printStackTrace();
            this.unexpectedBreak();
        }
    }

    public int getMinPoolSize() {
        return this.min;
    }

    public int getMaxPoolSize() {
        return this.max;
    }

    public synchronized int getPoolSize() throws ResourcePoolException {
        return this.managed.size();
    }

    public synchronized void setPoolSize(int sz) throws ResourcePoolException {
        try {
            Exception exc = this.doSetPoolSize(sz);
            if (exc != null) {
                if (exc instanceof RuntimeException) {
                    throw (RuntimeException)exc;
                }
                throw ResourcePoolUtils.convertThrowable(exc);
            }
        }
        catch (ResourceClosedException e) {
            e.printStackTrace();
            this.unexpectedBreak();
        }
    }

    public synchronized void resetPool() {
        try {
            Iterator ii = this.cloneOfManaged().keySet().iterator();
            while (ii.hasNext()) {
                this.markBroken(ii.next());
            }
            this.ensureMinResources();
        }
        catch (ResourceClosedException e) {
            e.printStackTrace();
            this.unexpectedBreak();
        }
    }

    public synchronized void close() throws ResourcePoolException {
        this.close(true);
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public void addResourcePoolListener(ResourcePoolListener rpl) {
        this.rpes.addResourcePoolListener(rpl);
    }

    public void removeResourcePoolListener(ResourcePoolListener rpl) {
        this.rpes.removeResourcePoolListener(rpl);
    }

    private synchronized void unexpectedBreak() {
        this.close(false);
    }

    private void postAcquireUntil(int num) {
        this.taskRunner.postRunnable(new AcquireTask(num));
    }

    private void postRemoveTowards(int num) {
        System.err.println("postRemoveTowards(" + num + ")");
        this.taskRunner.postRunnable(new RemoveTask(num));
    }

    private void asyncFireResourceAcquired(final Object resc, final int pool_size, final int available_size, final int removed_but_unreturned_size) {
        Runnable r = new Runnable(){

            public void run() {
                BasicResourcePool.this.rpes.fireResourceAcquired(resc, pool_size, available_size, removed_but_unreturned_size);
            }
        };
        this.asyncEventQueue.postRunnable(r);
    }

    private void asyncFireResourceCheckedIn(final Object resc, final int pool_size, final int available_size, final int removed_but_unreturned_size) {
        Runnable r = new Runnable(){

            public void run() {
                BasicResourcePool.this.rpes.fireResourceCheckedIn(resc, pool_size, available_size, removed_but_unreturned_size);
            }
        };
        this.asyncEventQueue.postRunnable(r);
    }

    private void asyncFireResourceCheckedOut(final Object resc, final int pool_size, final int available_size, final int removed_but_unreturned_size) {
        Runnable r = new Runnable(){

            public void run() {
                BasicResourcePool.this.rpes.fireResourceCheckedOut(resc, pool_size, available_size, removed_but_unreturned_size);
            }
        };
        this.asyncEventQueue.postRunnable(r);
    }

    private void asyncFireResourceRemoved(final Object resc, final boolean checked_out_resource, final int pool_size, final int available_size, final int removed_but_unreturned_size) {
        Runnable r = new Runnable(){

            public void run() {
                BasicResourcePool.this.rpes.fireResourceRemoved(resc, checked_out_resource, pool_size, available_size, removed_but_unreturned_size);
            }
        };
        this.asyncEventQueue.postRunnable(r);
    }

    private void destroyResource(final Object resc) {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    BasicResourcePool.this.mgr.destroyResource(resc);
                }
                catch (Exception e) {
                    System.err.println("Failed to destroy resource: " + resc);
                    e.printStackTrace();
                }
            }
        };
        this.taskRunner.postRunnable(r);
    }

    private void acquireUntil(int num) throws Exception {
        int msz;
        do {
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                msz = this.managed.size();
                if (msz < num) {
                    this.assimilateResource();
                }
            }
            Thread.currentThread();
            Thread.yield();
        } while (msz < num);
    }

    private void _markBroken(Object resc) {
        if (this.unused.contains(resc)) {
            this.removeResource(resc);
        } else {
            this.excludeResource(resc);
        }
    }

    private void close(boolean close_checked_out_resources) {
        Collection<Object> cleanupResources;
        this.broken = true;
        Collection<Object> collection = cleanupResources = close_checked_out_resources ? this.cloneOfManaged().keySet() : this.cloneOfUnused();
        if (this.cullTask != null) {
            this.cullTask.cancel();
        }
        if (this.idleRefurbishTask != null) {
            this.idleRefurbishTask.cancel();
        }
        Iterator<Object> ii = cleanupResources.iterator();
        while (ii.hasNext()) {
            try {
                this.removeResource(ii.next());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Iterator ii2 = this.interruptableWaiters.iterator();
        while (ii2.hasNext()) {
            ((Thread)ii2.next()).interrupt();
        }
        if (this.factory != null) {
            this.factory.markBroken(this);
        }
    }

    private void doCheckinManaged(Object resc) throws ResourcePoolException {
        if (!this.unused.contains(resc)) {
            boolean resc_okay = this.attemptRefurbishResourceOnCheckin(resc);
            if (resc_okay) {
                this.unused.add(resc);
                if (!this.age_is_absolute) {
                    this.managed.put(resc, new Date());
                }
            } else {
                this.removeResource(resc);
                this.ensureMinResources();
            }
            this.asyncFireResourceCheckedIn(resc, this.managed.size(), this.unused.size(), this.excluded.size());
            this.notifyAll();
        }
    }

    private void doCheckinExcluded(Object resc) {
        this.excluded.remove(resc);
        this.destroyResource(resc);
    }

    private Exception doSetPoolSize(int sz) {
        try {
            try {
                if (sz > this.max) {
                    throw new IllegalArgumentException("Requested size [" + sz + "] is greater than max [" + this.max + "].");
                }
                if (sz < this.min) {
                    throw new IllegalArgumentException("Requested size [" + sz + "] is less than min [" + this.min + "].");
                }
                int msz = this.managed.size();
                if (sz > msz) {
                    this.acquireUntil(sz);
                } else if (sz < msz) {
                    int num_to_cull = msz - sz;
                    int usz = this.unused.size();
                    int num_from_unused = Math.min(num_to_cull, usz);
                    int i = 0;
                    while (i < num_from_unused) {
                        this.removeResource(this.unused.get(0));
                        ++i;
                    }
                    int num_outstanding_to_cull = num_to_cull - num_from_unused;
                    Iterator ii = this.cloneOfManaged().keySet().iterator();
                    int i2 = 0;
                    while (i2 < num_outstanding_to_cull) {
                        this.excludeResource(ii.next());
                        ++i2;
                    }
                }
                Exception exception = null;
                Object var11_13 = null;
                this.notifyAll();
                return exception;
            }
            catch (Exception e) {
                Exception exception = e;
                Object var11_14 = null;
                this.notifyAll();
                return exception;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.notifyAll();
            throw throwable;
        }
    }

    private void postAcquireMore() {
        int msz = this.managed.size();
        int pending_acquires = this.pendingAcquiresCounter.getValue();
        int num_desired = msz + Math.max(this.inc, pending_acquires + 1);
        this.postAcquireUntil(Math.min(num_desired, this.max));
    }

    private void awaitAcquire(long timeout) throws InterruptedException, TimeoutException {
        int avail;
        Thread t = Thread.currentThread();
        this.interruptableWaiters.add(t);
        long start = timeout > 0L ? System.currentTimeMillis() : -1L;
        while ((avail = this.unused.size()) == 0) {
            if (this.pendingAcquiresCounter.getValue() == 0) {
                this.postAcquireMore();
            }
            this.wait(timeout);
            if (timeout <= 0L || System.currentTimeMillis() - start <= timeout) continue;
            throw new TimeoutException("internal -- timeot at awaitAcquire()");
        }
        this.interruptableWaiters.remove(t);
    }

    private void assimilateResource() throws Exception {
        Object resc = this.mgr.acquireResource();
        this.managed.put(resc, new Date());
        this.unused.add(resc);
        this.asyncFireResourceAcquired(resc, this.managed.size(), this.unused.size(), this.excluded.size());
        this.notifyAll();
        if (this.exampleResource == null) {
            this.exampleResource = resc;
        }
    }

    private void removeResource(Object resc) {
        this.managed.remove(resc);
        this.unused.remove(resc);
        this.destroyResource(resc);
        this.asyncFireResourceRemoved(resc, false, this.managed.size(), this.unused.size(), this.excluded.size());
    }

    private void excludeResource(Object resc) {
        this.managed.remove(resc);
        this.excluded.add(resc);
        if (this.unused.contains(resc)) {
            throw new InternalError("We should only \"exclude\" checked-out resources!");
        }
        this.asyncFireResourceRemoved(resc, true, this.managed.size(), this.unused.size(), this.excluded.size());
    }

    private void removeTowards(int new_sz) {
        int num_to_remove = this.managed.size() - new_sz;
        int count = 0;
        Iterator ii = this.cloneOfUnused().iterator();
        while (ii.hasNext() && count < num_to_remove) {
            Object resc = ii.next();
            this.removeResource(resc);
            ++count;
        }
    }

    private void cullExpiredAndUnused() {
        Iterator ii = this.cloneOfUnused().iterator();
        while (ii.hasNext()) {
            Object resc = ii.next();
            if (!this.isExpired(resc)) continue;
            this.removeResource(resc);
        }
        this.ensureMinResources();
    }

    private void checkIdleResources() {
        LinkedList u = this.cloneOfUnused();
        Iterator ii = u.iterator();
        while (ii.hasNext()) {
            Object resc = ii.next();
            if (!this.idleCheckResources.add(resc)) continue;
            this.taskRunner.postRunnable(new AsyncTestIdleResourceTask(resc));
        }
    }

    private boolean isExpired(Object resc) {
        if (this.max_resource_age > 0L) {
            Date d = (Date)this.managed.get(resc);
            long now = System.currentTimeMillis();
            return now - d.getTime() > this.max_resource_age;
        }
        return false;
    }

    private void ensureStartResources() {
        this.postAcquireUntil(Math.max(this.start, this.min));
    }

    private void ensureMinResources() {
        if (this.managed.size() < this.min) {
            this.postAcquireUntil(this.min);
        }
    }

    private boolean attemptRefurbishResourceOnCheckout(Object resc) {
        try {
            this.mgr.refurbishResourceOnCheckout(resc);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean attemptRefurbishResourceOnCheckin(Object resc) {
        try {
            this.mgr.refurbishResourceOnCheckin(resc);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void ensureNotBroken() throws ResourcePoolException {
        if (this.broken) {
            throw new ResourcePoolException("Attempted to use a closed or broken resource pool");
        }
    }

    private void trace() {
        String exampleResStr = this.exampleResource == null ? "" : " Ex: " + this.exampleResource;
        System.err.println(this + "  [managed: " + this.managed.size() + ", " + "unused: " + this.unused.size() + ", excluded: " + this.excluded.size() + ']' + exampleResStr);
    }

    private final HashMap cloneOfManaged() {
        return (HashMap)this.managed.clone();
    }

    private final LinkedList cloneOfUnused() {
        return (LinkedList)this.unused.clone();
    }

    private final HashSet cloneOfExcluded() {
        return (HashSet)this.excluded.clone();
    }

    class AsyncTestIdleResourceTask
    implements Runnable {
        Object resc;
        boolean pending = true;
        boolean failed;

        AsyncTestIdleResourceTask(Object resc) {
            this.resc = resc;
        }

        public void run() {
            BasicResourcePool basicResourcePool;
            try {
                boolean failed;
                try {
                    BasicResourcePool.this.mgr.refurbishIdleResource(this.resc);
                    failed = false;
                }
                catch (Exception e) {
                    System.err.println("c3p0-TRAVIS: An idle resource is broken and must be purged.");
                    System.err.print("c3p0-TRAVIS: ");
                    e.printStackTrace();
                    failed = true;
                }
                BasicResourcePool basicResourcePool2 = BasicResourcePool.this;
                synchronized (basicResourcePool2) {
                    if (failed && BasicResourcePool.this.managed.keySet().contains(this.resc)) {
                        BasicResourcePool.this.removeResource(this.resc);
                        BasicResourcePool.this.ensureMinResources();
                    }
                }
                Object var5_5 = null;
                basicResourcePool = BasicResourcePool.this;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                BasicResourcePool basicResourcePool3 = BasicResourcePool.this;
                synchronized (basicResourcePool3) {
                    BasicResourcePool.this.idleCheckResources.remove(this.resc);
                    BasicResourcePool.this.notifyAll();
                }
                throw throwable;
            }
            synchronized (basicResourcePool) {
                BasicResourcePool.this.idleCheckResources.remove(this.resc);
                BasicResourcePool.this.notifyAll();
            }
        }
    }

    class CheckIdleResourcesTask
    extends TimerTask {
        CheckIdleResourcesTask() {
        }

        public void run() {
            try {
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.checkIdleResources();
                }
            }
            catch (ResourceClosedException e) {
                e.printStackTrace();
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class RemoveTask
    implements Runnable {
        int num;

        public RemoveTask(int num) {
            this.num = num;
        }

        public void run() {
            try {
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.removeTowards(this.num);
                }
            }
            catch (ResourceClosedException e) {
                e.printStackTrace();
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class CullTask
    extends TimerTask {
        CullTask() {
        }

        public void run() {
            try {
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.cullExpiredAndUnused();
                }
            }
            catch (ResourceClosedException e) {
                e.printStackTrace();
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class AcquireTask
    implements Runnable {
        boolean success = false;
        int num;

        public AcquireTask(int num) {
            this.num = num;
            BasicResourcePool.this.pendingAcquiresCounter.increment();
        }

        public void run() {
            try {
                block8: {
                    try {
                        int i = 0;
                        while (this.shouldTry(i)) {
                            try {
                                if (i > 0) {
                                    Thread.sleep(BasicResourcePool.this.acq_attempt_delay);
                                }
                                BasicResourcePool.this.acquireUntil(this.num);
                                this.success = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ++i;
                        }
                        if (this.success) break block8;
                        BasicResourcePool.this.unexpectedBreak();
                    }
                    catch (ResourceClosedException e) {
                        e.printStackTrace();
                        BasicResourcePool.this.unexpectedBreak();
                        Object var4_5 = null;
                        BasicResourcePool.this.pendingAcquiresCounter.decrement();
                    }
                }
                Object var4_4 = null;
                BasicResourcePool.this.pendingAcquiresCounter.decrement();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                BasicResourcePool.this.pendingAcquiresCounter.decrement();
                throw throwable;
            }
        }

        private boolean shouldTry(int attempt_num) {
            return !this.success && (BasicResourcePool.this.num_acq_attempts <= 0 || attempt_num < BasicResourcePool.this.num_acq_attempts);
        }
    }
}

