/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.ser;

import com.mchange.v1.io.InputStreamUtils;
import com.mchange.v1.io.OutputStreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class SerializableUtils {
    private SerializableUtils() {
    }

    public static byte[] toByteArray(Object obj) throws NotSerializableException {
        return SerializableUtils.serializeToByteArray(obj);
    }

    public static byte[] serializeToByteArray(Object obj) throws NotSerializableException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(obj);
            return baos.toByteArray();
        }
        catch (NotSerializableException e) {
            e.fillInStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("IOException writing to a byte array!");
        }
    }

    public static Object fromByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        return SerializableUtils.deserializeFromByteArray(bytes);
    }

    public static Object deserializeFromByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return in.readObject();
    }

    public static Object testSerializeDeserialize(Object o) throws IOException, ClassNotFoundException {
        byte[] bytes = SerializableUtils.serializeToByteArray(o);
        return SerializableUtils.deserializeFromByteArray(bytes);
    }

    public static final Object unmarshallObjectFromFile(File file) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            object = in.readObject();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            InputStreamUtils.attemptClose(in);
            throw throwable;
        }
        InputStreamUtils.attemptClose(in);
        return object;
    }

    public static final void marshallObjectToFile(Object o, File file) throws IOException {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            out.writeObject(o);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            OutputStreamUtils.attemptClose(out);
            throw throwable;
        }
        OutputStreamUtils.attemptClose(out);
    }
}

