/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class DigitFilter
extends TokenFilter {
    boolean preRead = false;
    Token preReadToken = null;

    public DigitFilter(TokenStream tokenStream) {
        this.input = tokenStream;
    }

    public final Token next() throws IOException {
        if (this.preRead) {
            this.preRead = false;
            return this.preReadToken;
        }
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        String string = token.termText();
        if (string.length() == 1 && Character.isDigit(string.charAt(0))) {
            int n = token.startOffset();
            int n2 = token.endOffset();
            String string2 = token.type();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(token.termText());
            while (true) {
                if ((token = this.input.next()) == null || token.termText().length() != 1 || !Character.isDigit(token.termText().charAt(0))) {
                    this.preRead = true;
                    this.preReadToken = token;
                    return new Token(new String(stringBuffer), n, n2, string2);
                }
                stringBuffer.append(token.termText());
                n2 = token.endOffset();
            }
        }
        return token;
    }
}

