/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.DigitFilter;
import org.apache.lucene.analysis.ja.JapaneseAnalyzerException;
import org.apache.lucene.analysis.ja.KatakanaStemFilter;
import org.apache.lucene.analysis.ja.MonitorFilter;
import org.apache.lucene.analysis.ja.NormalizeReader;
import org.apache.lucene.analysis.ja.POSFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JapaneseAnalyzer
extends Analyzer {
    public static final String PROPERTY_NAME = "org.apache.lucene.ja.config.file";
    public static final String VERBOSE_FLAG = "org.apache.lucene.ja.config.verbose";
    public static final String PROPERTY_FILE_NAME = "org/apache/lucene/analysis/ja/analyzer-sen.xml";
    private Set stopTable;
    private Hashtable posTable;
    private String tokenizer;
    private boolean verbose;
    static /* synthetic */ Class class$java$io$Reader;

    public JapaneseAnalyzer() {
        InputStream inputStream;
        String string = System.getProperty(PROPERTY_NAME);
        if (string == null) {
            string = PROPERTY_FILE_NAME;
        }
        if ((inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string)) == null) {
            throw new JapaneseAnalyzerException("Can't find a Japanese tokenizer property file: " + string);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.parseConfig(inputStream, arrayList, arrayList2);
        if (this.tokenizer == null) {
            throw new JapaneseAnalyzerException("Can't find Japanese tokenizer class.");
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        this.stopTable = StopFilter.makeStopSet((String[])stringArray);
        String[] stringArray2 = arrayList2.toArray(new String[0]);
        this.posTable = POSFilter.makePOSTable(stringArray2);
        this.verbose = Boolean.getBoolean(VERBOSE_FLAG);
    }

    private void parseConfig(InputStream inputStream, ArrayList arrayList, ArrayList arrayList2) throws FactoryConfigurationError {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            NodeList nodeList = document.getFirstChild().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                String string2;
                Node node;
                int n;
                NodeList nodeList2;
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1) continue;
                String string3 = node2.getNodeName();
                String string4 = node2.getFirstChild().getNodeValue();
                if (string3.equals("tokenizerClass")) {
                    this.tokenizer = string4;
                    continue;
                }
                if (string3.equals("stop")) {
                    nodeList2 = node2.getChildNodes();
                    for (n = 0; n < nodeList2.getLength(); ++n) {
                        node = nodeList2.item(n);
                        if (node.getNodeType() != 1) continue;
                        string2 = node.getNodeName();
                        if (node.getFirstChild() == null) {
                            throw new IllegalArgumentException("element '" + string2 + "' is empty");
                        }
                        string = node.getFirstChild().getNodeValue();
                        if (string2.equals("letters")) {
                            for (int j = 0; j < string.length(); ++j) {
                                arrayList.add("" + string.charAt(j));
                            }
                            continue;
                        }
                        if (!string2.equals("word")) continue;
                        arrayList.add(string);
                    }
                    continue;
                }
                if (!string3.equals("accept")) continue;
                nodeList2 = node2.getChildNodes();
                for (n = 0; n < nodeList2.getLength(); ++n) {
                    node = nodeList2.item(n);
                    if (node.getNodeType() != 1) continue;
                    string2 = node.getNodeName();
                    if (node.getFirstChild() == null) {
                        throw new IllegalArgumentException("element '" + string2 + "' is empty");
                    }
                    string = node.getFirstChild().getNodeValue();
                    if (!string2.equals("pos")) continue;
                    arrayList2.add(string);
                }
            }
            inputStream.close();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public final TokenStream tokenStream(String string, Reader reader) {
        Object object;
        reader = new NormalizeReader(reader);
        Class[] classArray = new Class[]{class$java$io$Reader == null ? (class$java$io$Reader = JapaneseAnalyzer.class$("java.io.Reader")) : class$java$io$Reader};
        Object[] objectArray = new Object[]{reader};
        try {
            object = (TokenStream)Class.forName(this.tokenizer).getConstructor(classArray).newInstance(objectArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JapaneseAnalyzerException("Can't load a Japanese tokenizer: " + exception.getMessage());
        }
        object = new POSFilter((TokenStream)object, this.posTable);
        object = new DigitFilter((TokenStream)object);
        object = new LowerCaseFilter(object);
        object = new KatakanaStemFilter((TokenStream)object);
        object = new StopFilter(object, this.stopTable);
        if (this.verbose) {
            object = new MonitorFilter((TokenStream)object);
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

