/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class KatakanaStemFilter
extends TokenFilter {
    static final char COMBINING_KATAKANA_HIRAGANA_VOICED_SOUND_MARK = '\u3099';
    static final char COMBINING_KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK = '\u309a';
    static final char KATAKANA_HIRAGANA_VOICED_SOUND_MARK = '\u309b';
    static final char KATAKANA_HIRAGANA_SEMI_VOICED_SOUND_MARK = '\u309c';
    static final char KATAKANA_HIRAGANA_PROLONGED_SOUND_MARK = '\u30fc';

    public KatakanaStemFilter(TokenStream tokenStream) {
        this.input = tokenStream;
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        String string = token.termText();
        int n = string.length();
        if (n > 3 && string.charAt(n - 1) == '\u30fc' && this.isKatakanaString(string)) {
            token = new Token(string.substring(0, n - 1), token.startOffset(), token.endOffset(), token.type());
        }
        return token;
    }

    boolean isKatakanaString(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.UnicodeBlock.of(c) == Character.UnicodeBlock.KATAKANA || c == '\u3099' || c == '\u309a' || c == '\u309b' || c == '\u309c') continue;
            return false;
        }
        return true;
    }
}

