/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class POSFilter
extends TokenFilter {
    Hashtable table;

    public POSFilter(TokenStream tokenStream, String[] stringArray) {
        this.input = tokenStream;
        this.table = POSFilter.makePOSTable(stringArray);
    }

    public POSFilter(TokenStream tokenStream, Hashtable hashtable) {
        this.input = tokenStream;
        this.table = hashtable;
    }

    public static final Hashtable makePOSTable(String[] stringArray) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            hashtable.put(stringArray[i], stringArray[i]);
        }
        return hashtable;
    }

    public final Token next() throws IOException {
        Token token;
        do {
            if ((token = this.input.next()) != null) continue;
            return null;
        } while (!this.table.contains(token.type()));
        return token;
    }
}

