/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.lucene.demo.CharsetDetector;
import org.apache.lucene.demo.html.HTMLParser;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class HTMLJDocument {
    static char dirSep = System.getProperty("file.separator").charAt(0);

    public static String uid(File file) {
        return file.getPath().replace(dirSep, '\u0000') + "\u0000" + DateField.timeToString((long)file.lastModified());
    }

    public static String uid2url(String string) {
        String string2 = string.replace('\u0000', '/');
        return string2.substring(0, string2.lastIndexOf(47));
    }

    public static Document Document(File file, String string) throws IOException, InterruptedException {
        CharsetDetector charsetDetector;
        Document document = new Document();
        document.add(Field.UnIndexed((String)"url", (String)file.getPath().replace(dirSep, '/')));
        document.add(Field.Keyword((String)"modified", (String)DateField.timeToString((long)file.lastModified())));
        document.add(new Field("uid", HTMLJDocument.uid(file), false, true, false));
        try {
            charsetDetector = new CharsetDetector(file);
            string = charsetDetector.detect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        charsetDetector = new HTMLParser((Reader)new InputStreamReader((InputStream)new FileInputStream(file), string));
        document.add(Field.Text((String)"contents", (Reader)charsetDetector.getReader()));
        document.add(Field.Text((String)"charset", (String)string));
        document.add(Field.UnIndexed((String)"summary", (String)charsetDetector.getSummary()));
        document.add(Field.Text((String)"title", (String)charsetDetector.getTitle()));
        return document;
    }

    private HTMLJDocument() {
    }
}

