/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.File;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.JapaneseAnalyzer;
import org.apache.lucene.demo.FileJDocument;
import org.apache.lucene.index.IndexWriter;

class IndexJFiles {
    IndexJFiles() {
    }

    public static void main(String[] stringArray) {
        try {
            String string = "index";
            String string2 = System.getProperty("file.encoding");
            boolean bl = false;
            File file = null;
            String string3 = "IndexJFiles [-charset <default charset>] [-create] [-index <index>] <root_directory>";
            if (stringArray.length == 0) {
                System.err.println("Usage: " + string3);
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-index")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-charset")) {
                    string2 = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-create")) {
                    bl = true;
                    continue;
                }
                if (i != stringArray.length - 1) {
                    System.err.println("Usage: " + string3);
                    return;
                }
                file = new File(stringArray[i]);
            }
            Date date = new Date();
            IndexWriter indexWriter = new IndexWriter(string, (Analyzer)new JapaneseAnalyzer(), bl);
            IndexJFiles.indexDocs(indexWriter, file, string2);
            indexWriter.optimize();
            indexWriter.close();
            Date date2 = new Date();
            System.out.print(date2.getTime() - date.getTime());
            System.out.println(" total milliseconds");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void indexDocs(IndexWriter indexWriter, File file, String string) throws Exception {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    IndexJFiles.indexDocs(indexWriter, new File(file, stringArray[i]), string);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("fail indexing: " + file.toString());
                    return;
                }
            }
        } else {
            System.out.println("adding " + file);
            indexWriter.addDocument(FileJDocument.Document(file, string));
        }
    }
}

