/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class CustomBooleanEditor
extends PropertyEditorSupport {
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    private final boolean allowEmpty;

    public CustomBooleanEditor(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText(text)) {
            this.setValue(null);
        } else if (text.equalsIgnoreCase(VALUE_TRUE)) {
            this.setValue(Boolean.TRUE);
        } else if (text.equalsIgnoreCase(VALUE_FALSE)) {
            this.setValue(Boolean.FALSE);
        } else {
            throw new IllegalArgumentException("Invalid Boolean value [" + text + "]");
        }
    }

    public String getAsText() {
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return this.allowEmpty ? "" : "null";
    }
}

