/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.model.RssVersion;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class RssDocument
implements RssVersion,
Cloneable,
Serializable {
    private Vector channels = new Vector();
    private String version;
    private Vector warnings = new Vector();

    public RssDocument() {
    }

    public RssDocument(String string) {
        this.setVersion(string);
    }

    public void addChannel(RssChannel rssChannel) {
        this.channels.addElement(rssChannel);
    }

    public Enumeration channels() {
        return this.channels.elements();
    }

    public void setVersion(String string) {
        if (string.equals("0.9") || string.equals(".90") || string.equals(".9")) {
            string = "0.90";
        }
        if (string.equals(".91")) {
            string = "0.91";
        }
        if (string.equals("1.00")) {
            string = "1.0";
        }
        if ("0.90".equals(string) || "0.91".equals(string) || "1.0".equals(string)) {
            this.version = string;
            return;
        }
        throw new IllegalArgumentException("Invalid RSS version: '" + string + "' - must be one of 0.90|0.91|1.0");
    }

    public String getVersion() {
        return this.version;
    }

    public void addWarning(String string) {
        if (!this.warnings.contains(string)) {
            this.warnings.addElement(string);
        }
    }

    public Enumeration warnings() {
        return this.warnings.elements();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("RSS Document: version " + this.version + " Channels: " + this.channels.size() + "\n");
        Enumeration enumeration = this.channels.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(" " + enumeration.nextElement());
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 31;
        Enumeration enumeration = this.channels.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e == null) continue;
            n = 31 * n + e.hashCode();
        }
        n = 31 * n + (this.version == null ? 0 : this.version.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof RssDocument)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return this.hashCode() == object.hashCode();
    }

    public Object clone() {
        return this.clone();
    }
}

