/*
 * Decompiled with CFR 0.152.
 */
package churchillobjects.rss4j.generator;

import churchillobjects.rss4j.RssChannel;
import churchillobjects.rss4j.RssChannelImage;
import churchillobjects.rss4j.RssChannelItem;
import churchillobjects.rss4j.RssChannelTextInput;
import churchillobjects.rss4j.RssDocument;
import churchillobjects.rss4j.generator.RssGenerationException;
import churchillobjects.rss4j.generator.RssGenerator;
import java.util.Enumeration;
import org.w3c.dom.Element;

class RssGeneratorImpl090
extends RssGenerator {
    RssGeneratorImpl090() throws RssGenerationException {
    }

    protected void setMaxLengths() {
        this.channelTitleMax = 40;
        this.channelDescriptionMax = 500;
        this.channelLinkMax = 500;
        this.imageTitleMax = 40;
        this.imageUrlMax = 500;
        this.imageLinkMax = 500;
        this.itemTitleMax = 100;
        this.itemLinkMax = 500;
        this.textInputTitleMax = 40;
        this.textInputDescriptionMax = 100;
        this.textInputNameMax = 500;
        this.textInputLinkMax = 500;
    }

    protected void finishDocument() throws RssGenerationException {
    }

    protected void createRssDocument(RssDocument rssDocument) {
        this.doc = this.domImpl.createDocument("http://my.netscape.com/rdf/simple/0.9/", "rdf:RDF", null);
        this.rootElement = this.doc.getDocumentElement();
        this.rootElement.setAttribute("xmlns:rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.rootElement.setAttribute("xmlns", "http://my.netscape.com/rdf/simple/0.9/");
    }

    protected void handleChannel(RssChannel rssChannel) throws RssGenerationException {
        Element element = this.doc.createElement("channel");
        this.rootElement.appendChild(element);
        this.handleChannelTitle(rssChannel, element);
        this.handleChannelDescription(rssChannel, element);
        this.handleChannelLink(rssChannel, element);
        this.handleTextInput(rssChannel, element);
        this.handleImage(rssChannel, element);
        this.handleItems(rssChannel, element);
    }

    private void handleImage(RssChannel rssChannel, Element element) throws RssGenerationException {
        RssChannelImage rssChannelImage = rssChannel.getChannelImage();
        if (rssChannelImage != null) {
            Element element2 = this.doc.createElement("image");
            this.handleImageTitle(rssChannelImage, element2);
            this.handleImageUrl(rssChannelImage, element2);
            this.handleImageLink(rssChannelImage, element2);
            element.appendChild(element2);
        }
    }

    private void handleItems(RssChannel rssChannel, Element element) throws RssGenerationException {
        if (rssChannel.getItemCount() > 15) {
            throw new RssGenerationException("Channel in 0.91 RSS cannot have more than 15 items");
        }
        Enumeration enumeration = rssChannel.items();
        while (enumeration.hasMoreElements()) {
            RssChannelItem rssChannelItem = (RssChannelItem)enumeration.nextElement();
            if (rssChannelItem == null) continue;
            Element element2 = this.doc.createElement("item");
            this.handleItemTitle(rssChannelItem, element2);
            this.handleItemLink(rssChannelItem, element2);
            element.appendChild(element2);
        }
    }

    private void handleTextInput(RssChannel rssChannel, Element element) throws RssGenerationException {
        RssChannelTextInput rssChannelTextInput = rssChannel.getChannelTextInput();
        if (rssChannelTextInput != null) {
            Element element2 = this.doc.createElement("textInput");
            this.handleTextInputTitle(rssChannelTextInput, element2);
            this.handleTextInputDescription(rssChannelTextInput, element2);
            this.handleTextInputName(rssChannelTextInput, element2);
            this.handleTextInputLink(rssChannelTextInput, element2);
            element.appendChild(element2);
        }
    }

    protected void handleChannelTitle(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelTitle();
        string = this.truncate(string, this.channelTitleMax);
        this.validateValueRequired(string, "Channel title", this.channelTitleMax);
        this.add(element, "title", string);
    }

    protected void handleChannelDescription(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelDescription();
        string = this.truncate(string, this.channelDescriptionMax);
        this.validateValueRequired(string, "Channel description", this.channelDescriptionMax);
        this.add(element, "description", string);
    }

    protected void handleChannelLink(RssChannel rssChannel, Element element) throws RssGenerationException {
        String string = rssChannel.getChannelLink();
        this.validateUri(string);
        this.validateValueRequired(string, "Channel link", this.channelLinkMax);
        this.add(element, "link", string);
    }

    protected void handleImageTitle(RssChannelImage rssChannelImage, Element element) throws RssGenerationException {
        String string = rssChannelImage.getImageTitle();
        string = this.truncate(string, this.imageTitleMax);
        this.validateValueRequired(string, "Image title", this.imageTitleMax);
        this.add(element, "title", string);
    }

    protected void handleImageUrl(RssChannelImage rssChannelImage, Element element) throws RssGenerationException {
        String string = rssChannelImage.getImageUrl();
        this.validateUri(string);
        this.validateValueRequired(string, "Image URL", this.imageUrlMax);
        this.add(element, "url", string);
    }

    protected void handleImageLink(RssChannelImage rssChannelImage, Element element) throws RssGenerationException {
        String string = rssChannelImage.getImageLink();
        this.validateUri(string);
        this.validateValueRequired(string, "Image link", this.imageLinkMax);
        this.add(element, "link", string);
    }

    protected void handleItemTitle(RssChannelItem rssChannelItem, Element element) throws RssGenerationException {
        String string = rssChannelItem.getItemTitle();
        string = this.truncate(string, this.itemTitleMax);
        this.validateValueRequired(string, "Item title", this.itemTitleMax);
        this.add(element, "title", string);
    }

    protected void handleItemLink(RssChannelItem rssChannelItem, Element element) throws RssGenerationException {
        String string = rssChannelItem.getItemLink();
        this.validateUri(string);
        this.validateValueRequired(string, "Item link", this.itemLinkMax);
        this.add(element, "link", string);
    }

    protected void handleTextInputTitle(RssChannelTextInput rssChannelTextInput, Element element) throws RssGenerationException {
        String string = rssChannelTextInput.getInputTitle();
        string = this.truncate(string, this.textInputTitleMax);
        this.validateValueRequired(string, "Text input title", this.textInputTitleMax);
        this.add(element, "title", string);
    }

    protected void handleTextInputDescription(RssChannelTextInput rssChannelTextInput, Element element) throws RssGenerationException {
        String string = rssChannelTextInput.getInputDescription();
        string = this.truncate(string, this.textInputDescriptionMax);
        this.validateValueRequired(string, "Text input description", this.textInputDescriptionMax);
        this.add(element, "description", string);
    }

    protected void handleTextInputName(RssChannelTextInput rssChannelTextInput, Element element) throws RssGenerationException {
        String string = rssChannelTextInput.getInputName();
        this.validateValueRequired(string, "Text input name", this.textInputNameMax);
        this.add(element, "name", string);
    }

    protected void handleTextInputLink(RssChannelTextInput rssChannelTextInput, Element element) throws RssGenerationException {
        String string = rssChannelTextInput.getInputLink();
        this.validateUri(string);
        this.validateValueRequired(string, "Text input link", this.textInputLinkMax);
        this.add(element, "link", string);
    }
}

