/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;
import net.sf.hibernate.util.StringHelper;

public class MySQLDialect
extends Dialect {
    public MySQLDialect() {
        this.registerColumnType(-7, "BIT");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "TINYINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "LONGTEXT");
        this.registerColumnType(12, 0xFFFFFF, "MEDIUMTEXT");
        this.registerColumnType(12, 65535, "TEXT");
        this.registerColumnType(12, 255, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "DATETIME");
        this.registerColumnType(-3, "LONGBLOB");
        this.registerColumnType(-3, 0xFFFFFF, "MEDIUMBLOB");
        this.registerColumnType(-3, 65535, "BLOB");
        this.registerColumnType(-3, 255, "VARCHAR($l) BINARY");
        this.registerColumnType(2, "NUMERIC(19, $l)");
        this.registerColumnType(2004, "LONGBLOB");
        this.registerColumnType(2004, 0xFFFFFF, "MEDIUMBLOB");
        this.registerColumnType(2004, 65535, "BLOB");
        this.registerColumnType(2005, "LONGTEXT");
        this.registerColumnType(2005, 0xFFFFFF, "MEDIUMTEXT");
        this.registerColumnType(2005, 65535, "TEXT");
        this.registerFunction("ascii", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("bin", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("char_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("character_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("lcase", new StandardSQLFunction());
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("ltrim", new StandardSQLFunction());
        this.registerFunction("ord", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("quote", new StandardSQLFunction());
        this.registerFunction("reverse", new StandardSQLFunction());
        this.registerFunction("rtrim", new StandardSQLFunction());
        this.registerFunction("soundex", new StandardSQLFunction());
        this.registerFunction("space", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("ucase", new StandardSQLFunction());
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("unhex", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("abs", new StandardSQLFunction());
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("crc32", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("exp", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log2", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("rand", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sin", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sqrt", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tan", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("ceiling", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("ceil", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("floor", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("round", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("curdate", new NoArgSQLFunction(Hibernate.DATE));
        this.registerFunction("current_date", new NoArgSQLFunction(Hibernate.DATE));
        this.registerFunction("curtime", new NoArgSQLFunction(Hibernate.TIME));
        this.registerFunction("current_time", new NoArgSQLFunction(Hibernate.TIME));
        this.registerFunction("current_timestamp", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("date", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("day", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofmonth", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("dayofweek", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("from_days", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("from_unixtime", new StandardSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("hour", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("last_day", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("localtime", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("localtimestamp", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("microseconds", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("minute", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("monthname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("now", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("quarter", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("second", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("sec_to_time", new StandardSQLFunction(Hibernate.TIME));
        this.registerFunction("sysdate", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("time", new StandardSQLFunction(Hibernate.TIME));
        this.registerFunction("time", new StandardSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("time_to_sec", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("to_days", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("unix_timestamp", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("utc_date", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("utc_time", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("utc_timestamp", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("week", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("weekday", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("weekofyear", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("yearweek", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("hex", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("oct", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("octet_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("bit_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("bit_count", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("encrypt", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("md5", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("sha1", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("sha", new StandardSQLFunction(Hibernate.STRING));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "SELECT LAST_INSERT_ID()";
    }

    public String getIdentityColumnString() {
        return "NOT NULL AUTO_INCREMENT";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        String cols = StringHelper.join(", ", foreignKey);
        return new StringBuffer(30).append(" add index (").append(cols).append("), add constraint ").append(constraintName).append(" foreign key (").append(cols).append(") references ").append(referencedTable).append(" (").append(StringHelper.join(", ", primaryKey)).append(')').toString();
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 20).append(sql).append(hasOffset ? " limit ?, ?" : " limit ?").toString();
    }

    public char closeQuote() {
        return '`';
    }

    public char openQuote() {
        return '`';
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public char getSchemaSeperator() {
        return '_';
    }
}

