/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;

public class Oracle9Dialect
extends Dialect {
    public Oracle9Dialect() {
        this.registerColumnType(-7, "NUMBER(1,0)");
        this.registerColumnType(-5, "NUMBER(19,0)");
        this.registerColumnType(5, "NUMBER(5,0)");
        this.registerColumnType(-6, "NUMBER(3,0)");
        this.registerColumnType(4, "NUMBER(10,0)");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR2($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "DATE");
        this.registerColumnType(93, "DATE");
        this.registerColumnType(-3, "LONG RAW");
        this.registerColumnType(-3, 255, "RAW($l)");
        this.registerColumnType(2, "NUMBER(19, $l)");
        this.registerColumnType(2004, "BLOB");
        this.registerColumnType(2005, "CLOB");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.registerFunction("abs", new StandardSQLFunction());
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cosh", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sinh", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tanh", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction());
        this.registerFunction("trunc", new StandardSQLFunction());
        this.registerFunction("ceil", new StandardSQLFunction());
        this.registerFunction("floor", new StandardSQLFunction());
        this.registerFunction("chr", new StandardSQLFunction(Hibernate.CHARACTER));
        this.registerFunction("initcap", new StandardSQLFunction());
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("ltrim", new StandardSQLFunction());
        this.registerFunction("rtrim", new StandardSQLFunction());
        this.registerFunction("soundex", new StandardSQLFunction());
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("ascii", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("to_char", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("to_date", new StandardSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("lastday", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("sysdate", new NoArgSQLFunction(Hibernate.DATE, false));
        this.registerFunction("uid", new NoArgSQLFunction(Hibernate.INTEGER, false));
        this.registerFunction("user", new NoArgSQLFunction(Hibernate.STRING, false));
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public boolean supportsForUpdateNowait() {
        return true;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (hasOffset) {
            pagingSelect.append(" ) row_ where rownum <= ?) where rownum_ > ?");
        } else {
            pagingSelect.append(" ) where rownum <= ?");
        }
        return pagingSelect.toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsForUpdateOf() {
        return false;
    }

    public String getQuerySequencesString() {
        return "select SEQUENCE_NAME from user_sequences";
    }
}

