/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.hql;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.dialect.SQLFunction;
import net.sf.hibernate.hql.Parser;
import net.sf.hibernate.hql.ParserHelper;
import net.sf.hibernate.hql.PathExpressionParser;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.hql.SelectPathExpressionParser;
import net.sf.hibernate.type.Type;

public class SelectParser
implements Parser {
    private static final Set COUNT_MODIFIERS = new HashSet();
    private LinkedList aggregateFuncTokenList = new LinkedList();
    private boolean ready;
    private boolean aggregate;
    private boolean first;
    private boolean afterNew;
    private boolean insideNew;
    private Class holderClass;
    private final SelectPathExpressionParser pathExpressionParser = new SelectPathExpressionParser();
    private final PathExpressionParser aggregatePathExpressionParser = new PathExpressionParser();

    public SelectParser() {
        this.pathExpressionParser.setUseThetaStyleJoin(true);
        this.aggregatePathExpressionParser.setUseThetaStyleJoin(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void token(String token, QueryTranslator q) throws QueryException {
        String lctoken = token.toLowerCase();
        if (this.first) {
            this.first = false;
            if ("distinct".equals(lctoken)) {
                q.setDistinct(true);
                return;
            }
            if ("all".equals(lctoken)) {
                q.setDistinct(false);
                return;
            }
        }
        if (this.afterNew) {
            this.afterNew = false;
            this.holderClass = q.getImportedClass(token);
            if (this.holderClass == null) {
                throw new QueryException("class not found: " + token);
            }
            q.setHolderClass(this.holderClass);
            this.insideNew = true;
            return;
        } else if (token.equals(",")) {
            if (this.ready) {
                throw new QueryException("alias or expression expected in SELECT");
            }
            q.appendScalarSelectToken(", ");
            this.ready = true;
            return;
        } else if ("new".equals(lctoken)) {
            this.afterNew = true;
            this.ready = false;
            return;
        } else if ("(".equals(token)) {
            if (this.insideNew && !this.aggregate && !this.ready) {
                this.ready = true;
            } else {
                if (!this.aggregate) throw new QueryException("aggregate function expected before ( in SELECT");
                q.appendScalarSelectToken(token);
            }
            this.ready = true;
            return;
        } else if (")".equals(token)) {
            if (this.insideNew && !this.aggregate && !this.ready) {
                this.insideNew = false;
                return;
            } else {
                if (!this.aggregate || !this.ready) throw new QueryException("( expected before ) in select");
                q.appendScalarSelectToken(token);
                this.aggregateFuncTokenList.removeLast();
                if (this.aggregateFuncTokenList.size() >= 1) return;
                this.aggregate = false;
                this.ready = false;
            }
            return;
        } else if (COUNT_MODIFIERS.contains(lctoken)) {
            if (!this.ready || !this.aggregate) {
                throw new QueryException(token + " only allowed inside aggregate function in SELECT");
            }
            q.appendScalarSelectToken(token);
            if (!"*".equals(token)) return;
            q.addSelectScalar(Hibernate.INTEGER);
            return;
        } else if (this.getFunction(lctoken, q) != null) {
            if (!this.ready) {
                throw new QueryException(", expected before aggregate function in SELECT: " + token);
            }
            this.aggregate = true;
            this.aggregateFuncTokenList.add(lctoken);
            this.ready = false;
            q.appendScalarSelectToken(token);
            if (this.aggregateHasArgs(lctoken, q)) return;
            q.addSelectScalar(this.aggregateType(this.aggregateFuncTokenList, null, q));
            if (this.aggregateFuncNoArgsHasParenthesis(lctoken, q)) return;
            this.aggregateFuncTokenList.removeLast();
            if (this.aggregateFuncTokenList.size() < 1) {
                this.aggregate = false;
                this.ready = false;
                return;
            } else {
                this.ready = true;
            }
            return;
        } else if (this.aggregate) {
            if (!this.ready) {
                throw new QueryException("( expected after aggregate function in SELECT");
            }
            ParserHelper.parse(this.aggregatePathExpressionParser, q.unalias(token), ".", q);
            if (this.aggregatePathExpressionParser.isCollectionValued()) {
                q.addCollection(this.aggregatePathExpressionParser.getCollectionName(), this.aggregatePathExpressionParser.getCollectionRole());
            }
            q.appendScalarSelectToken(this.aggregatePathExpressionParser.getWhereColumn());
            q.addSelectScalar(this.aggregateType(this.aggregateFuncTokenList, this.aggregatePathExpressionParser.getWhereColumnType(), q));
            this.aggregatePathExpressionParser.addAssociation(q);
            return;
        } else {
            if (!this.ready) {
                throw new QueryException(", expected in SELECT");
            }
            ParserHelper.parse(this.pathExpressionParser, q.unalias(token), ".", q);
            if (this.pathExpressionParser.isCollectionValued()) {
                q.addCollection(this.pathExpressionParser.getCollectionName(), this.pathExpressionParser.getCollectionRole());
            } else if (this.pathExpressionParser.getWhereColumnType().isEntityType()) {
                q.addSelectClass(this.pathExpressionParser.getSelectName());
            }
            q.appendScalarSelectTokens(this.pathExpressionParser.getWhereColumns());
            q.addSelectScalar(this.pathExpressionParser.getWhereColumnType());
            this.pathExpressionParser.addAssociation(q);
            this.ready = false;
        }
    }

    public boolean aggregateHasArgs(String funcToken, QueryTranslator q) {
        return this.getFunction(funcToken, q).hasArguments();
    }

    public boolean aggregateFuncNoArgsHasParenthesis(String funcToken, QueryTranslator q) {
        return this.getFunction(funcToken, q).hasParenthesesIfNoArguments();
    }

    public Type aggregateType(List funcTokenList, Type type, QueryTranslator q) throws QueryException {
        Type retType = type;
        for (int i = funcTokenList.size() - 1; i >= 0; --i) {
            Type argType = retType;
            String funcToken = (String)funcTokenList.get(i);
            retType = this.getFunction(funcToken, q).getReturnType(argType, q.getFactory());
        }
        return retType;
    }

    private SQLFunction getFunction(String name, QueryTranslator q) {
        return (SQLFunction)q.getFactory().getDialect().getFunctions().get(name);
    }

    public void start(QueryTranslator q) {
        this.ready = true;
        this.first = true;
        this.aggregate = false;
        this.afterNew = false;
        this.insideNew = false;
        this.holderClass = null;
        this.aggregateFuncTokenList.clear();
    }

    public void end(QueryTranslator q) {
    }

    static {
        COUNT_MODIFIERS.add("distinct");
        COUNT_MODIFIERS.add("all");
        COUNT_MODIFIERS.add("*");
    }
}

