/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.CallbackException;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.Lifecycle;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.NonUniqueObjectException;
import net.sf.hibernate.ObjectDeletedException;
import net.sf.hibernate.ObjectNotFoundException;
import net.sf.hibernate.PersistentObjectException;
import net.sf.hibernate.PropertyValueException;
import net.sf.hibernate.Query;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.ReplicationMode;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.StaleObjectStateException;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.TransactionException;
import net.sf.hibernate.TransientObjectException;
import net.sf.hibernate.UnresolvableObjectException;
import net.sf.hibernate.Validatable;
import net.sf.hibernate.WrongClassException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.collection.ArrayHolder;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.Batcher;
import net.sf.hibernate.engine.CacheSynchronization;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.CollectionSnapshot;
import net.sf.hibernate.engine.Key;
import net.sf.hibernate.engine.QueryParameters;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.Versioning;
import net.sf.hibernate.hql.FilterTranslator;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.impl.BatchingBatcher;
import net.sf.hibernate.impl.CacheEntry;
import net.sf.hibernate.impl.CriteriaImpl;
import net.sf.hibernate.impl.DirtyCollectionSearchVisitor;
import net.sf.hibernate.impl.EvictVisitor;
import net.sf.hibernate.impl.FilterImpl;
import net.sf.hibernate.impl.FlushVisitor;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.impl.NonBatchingBatcher;
import net.sf.hibernate.impl.OnLockVisitor;
import net.sf.hibernate.impl.OnReplicateVisitor;
import net.sf.hibernate.impl.OnUpdateVisitor;
import net.sf.hibernate.impl.Printer;
import net.sf.hibernate.impl.ProxyVisitor;
import net.sf.hibernate.impl.QueryImpl;
import net.sf.hibernate.impl.SQLQueryImpl;
import net.sf.hibernate.impl.ScheduledCollectionRecreate;
import net.sf.hibernate.impl.ScheduledCollectionRemove;
import net.sf.hibernate.impl.ScheduledCollectionUpdate;
import net.sf.hibernate.impl.ScheduledDeletion;
import net.sf.hibernate.impl.ScheduledIdentityInsertion;
import net.sf.hibernate.impl.ScheduledInsertion;
import net.sf.hibernate.impl.ScheduledUpdate;
import net.sf.hibernate.impl.SessionFactoryImpl;
import net.sf.hibernate.impl.WrapVisitor;
import net.sf.hibernate.loader.CriteriaLoader;
import net.sf.hibernate.loader.SQLLoader;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.OuterJoinLoadable;
import net.sf.hibernate.persister.SQLLoadable;
import net.sf.hibernate.persister.UniqueKeyLoadable;
import net.sf.hibernate.proxy.HibernateProxy;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.proxy.LazyInitializer;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ArrayHelper;
import net.sf.hibernate.util.EmptyIterator;
import net.sf.hibernate.util.IdentityMap;
import net.sf.hibernate.util.JoinedIterator;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.collections.SequencedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SessionImpl
implements SessionImplementor {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$impl$SessionImpl == null ? (class$net$sf$hibernate$impl$SessionImpl = SessionImpl.class$("net.sf.hibernate.impl.SessionImpl")) : class$net$sf$hibernate$impl$SessionImpl));
    private SessionFactoryImpl factory;
    private final boolean autoClose;
    private final long timestamp;
    private boolean isCurrentTransaction;
    private boolean closed = false;
    private FlushMode flushMode = FlushMode.AUTO;
    private final Map entitiesByKey;
    private final Map proxiesByKey;
    private transient Map entityEntries;
    private transient Map arrayHolders;
    private transient Map collectionEntries;
    private final Map collectionsByKey;
    private HashSet nullifiables = new HashSet();
    private final HashSet nonExists;
    private Interceptor interceptor;
    private transient Connection connection;
    private transient boolean connect;
    private transient ArrayList insertions;
    private transient ArrayList deletions;
    private transient ArrayList updates;
    private transient ArrayList collectionCreations;
    private transient ArrayList collectionUpdates;
    private transient ArrayList collectionRemovals;
    private transient ArrayList executions;
    private transient Map loadingCollections;
    private transient List nonlazyCollections;
    private transient Map batchLoadableEntityKeys;
    private static final Object MARKER = new Object();
    private transient int dontFlushFromFind = 0;
    private transient int cascading = 0;
    private transient int loadCounter = 0;
    private transient boolean flushing = false;
    private transient Batcher batcher;
    private static final Status LOADED = new Status("LOADED");
    private static final Status DELETED = new Status("DELETED");
    private static final Status GONE = new Status("GONE");
    private static final Status LOADING = new Status("LOADING");
    private static final Status SAVING = new Status("SAVING");
    private static final Object[] NO_ARGS = ArrayHelper.EMPTY_STRING_ARRAY;
    private static final Type[] NO_TYPES = ArrayHelper.EMPTY_TYPE_ARRAY;
    private static final int[] NO_INTS = new int[0];
    private transient Class lastClass;
    private transient ClassPersister lastResultForClass;
    private static final Collection EMPTY = new ArrayList();
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionImpl;

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object e;
        log.trace((Object)"deserializing session");
        ois.defaultReadObject();
        this.entityEntries = IdentityMap.deserialize(ois.readObject());
        this.collectionEntries = IdentityMap.deserialize(ois.readObject());
        this.arrayHolders = IdentityMap.deserialize(ois.readObject());
        this.initTransientState();
        Iterator iter = this.collectionEntries.entrySet().iterator();
        while (iter.hasNext()) {
            try {
                e = iter.next();
                ((PersistentCollection)e.getKey()).setCurrentSession(this);
                CollectionEntry ce = (CollectionEntry)e.getValue();
                if (ce.getRole() == null) continue;
                ce.setLoadedPersister(this.factory.getCollectionPersister(ce.getRole()));
            }
            catch (HibernateException he) {
                throw new InvalidObjectException(he.getMessage());
            }
        }
        iter = this.proxiesByKey.values().iterator();
        while (iter.hasNext()) {
            Map.Entry proxy = iter.next();
            if (proxy instanceof HibernateProxy) {
                HibernateProxyHelper.getLazyInitializer((HibernateProxy)((Object)proxy)).setSession(this);
                continue;
            }
            iter.remove();
        }
        iter = this.entityEntries.entrySet().iterator();
        while (iter.hasNext()) {
            e = (EntityEntry)iter.next().getValue();
            try {
                ((EntityEntry)e).persister = this.factory.getPersister(((EntityEntry)e).className);
            }
            catch (MappingException me) {
                throw new InvalidObjectException(me.getMessage());
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Cannot serialize a Session while connected");
        }
        if (this.insertions.size() != 0 || this.deletions.size() != 0) {
            throw new IllegalStateException("Cannot serialize a Session which has work waiting to be flushed");
        }
        log.trace((Object)"serializing session");
        oos.defaultWriteObject();
        oos.writeObject(IdentityMap.serialize(this.entityEntries));
        oos.writeObject(IdentityMap.serialize(this.collectionEntries));
        oos.writeObject(IdentityMap.serialize(this.arrayHolders));
    }

    SessionImpl(Connection connection, SessionFactoryImpl factory, boolean autoclose, long timestamp, Interceptor interceptor) {
        this.connection = connection;
        this.connect = connection == null;
        this.interceptor = interceptor;
        this.autoClose = autoclose;
        this.timestamp = timestamp;
        this.factory = factory;
        this.entitiesByKey = new HashMap(50);
        this.proxiesByKey = new HashMap(10);
        this.nonExists = new HashSet(10);
        this.entityEntries = IdentityMap.instantiateSequenced(50);
        this.collectionEntries = IdentityMap.instantiateSequenced(30);
        this.collectionsByKey = new HashMap(30);
        this.arrayHolders = IdentityMap.instantiate(10);
        this.initTransientState();
        log.debug((Object)"opened session");
    }

    public Batcher getBatcher() {
        return this.batcher;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection close() throws HibernateException {
        log.trace((Object)"closing session");
        try {
            Connection connection = this.connection == null ? null : this.disconnect();
            return connection;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTransactionCompletion(boolean success) {
        log.trace((Object)"transaction completion");
        this.isCurrentTransaction = false;
        Iterator iter = this.entityEntries.values().iterator();
        while (iter.hasNext()) {
            ((EntityEntry)iter.next()).lockMode = LockMode.NONE;
        }
        int size = this.executions.size();
        boolean invalidateQueryCache = this.factory.isQueryCacheEnabled();
        for (int i = 0; i < size; ++i) {
            try {
                Object var8_9;
                Executable exec = (Executable)this.executions.get(i);
                try {
                    exec.afterTransactionCompletion(success);
                    var8_9 = null;
                    if (!invalidateQueryCache) continue;
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    if (invalidateQueryCache) {
                        this.factory.getUpdateTimestampsCache().invalidate(exec.getPropertySpaces());
                    }
                    throw throwable;
                }
                this.factory.getUpdateTimestampsCache().invalidate(exec.getPropertySpaces());
                {
                    continue;
                }
            }
            catch (CacheException ce) {
                log.error((Object)"could not release a cache lock", (Throwable)ce);
                continue;
            }
            catch (Exception e) {
                throw new AssertionFailure("Exception releasing cache locks", e);
            }
        }
        this.executions.clear();
    }

    private void initTransientState() {
        this.insertions = new ArrayList(20);
        this.deletions = new ArrayList(20);
        this.updates = new ArrayList(20);
        this.collectionCreations = new ArrayList(20);
        this.collectionRemovals = new ArrayList(20);
        this.collectionUpdates = new ArrayList(20);
        this.executions = new ArrayList(50);
        this.batchLoadableEntityKeys = new SequencedHashMap(30);
        this.loadingCollections = new HashMap();
        this.nonlazyCollections = new ArrayList(20);
        this.batcher = this.factory.isJdbcBatchUpdateEnabled() ? new BatchingBatcher(this) : new NonBatchingBatcher(this);
    }

    private void cleanup() {
        this.closed = true;
        this.entitiesByKey.clear();
        this.proxiesByKey.clear();
        this.entityEntries.clear();
        this.arrayHolders.clear();
        this.collectionEntries.clear();
        this.nullifiables.clear();
        this.batchLoadableEntityKeys.clear();
        this.collectionsByKey.clear();
        this.nonExists.clear();
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        if (object == null) {
            throw new NullPointerException("null object passed to getCurrentLockMode()");
        }
        if (object instanceof HibernateProxy && (object = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (e.status != LOADED) {
            throw new ObjectDeletedException("The given object was deleted", e.id, object.getClass());
        }
        return e.lockMode;
    }

    public LockMode getLockMode(Object object) {
        return this.getEntry((Object)object).lockMode;
    }

    private void addEntity(Key key, Object object) {
        this.entitiesByKey.put(key, object);
        if (key.isBatchLoadable()) {
            this.batchLoadableEntityKeys.remove(key);
        }
    }

    public Object getEntity(Key key) {
        return this.entitiesByKey.get(key);
    }

    private Object removeEntity(Key key) {
        return this.entitiesByKey.remove(key);
    }

    public void setLockMode(Object entity, LockMode lockMode) {
        this.getEntry((Object)entity).lockMode = lockMode;
    }

    private EntityEntry addEntry(Object object, Status status, Object[] loadedState, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, ClassPersister persister, boolean disableVersionIncrement) {
        EntityEntry e = new EntityEntry(status, loadedState, id, version, lockMode, existsInDatabase, persister, disableVersionIncrement);
        this.entityEntries.put(object, e);
        return e;
    }

    private EntityEntry getEntry(Object object) {
        return (EntityEntry)this.entityEntries.get(object);
    }

    private EntityEntry removeEntry(Object object) {
        return (EntityEntry)this.entityEntries.remove(object);
    }

    private boolean isEntryFor(Object object) {
        return this.entityEntries.containsKey(object);
    }

    private CollectionEntry getCollectionEntry(PersistentCollection coll) {
        return (CollectionEntry)this.collectionEntries.get(coll);
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public Serializable save(Object obj) throws HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to save null");
        }
        Object object = this.unproxy(obj);
        EntityEntry e = this.getEntry(object);
        if (e != null) {
            if (e.status == DELETED) {
                this.forceFlush(e);
            } else {
                log.trace((Object)"object already associated with session");
                return e.id;
            }
        }
        Serializable id = this.saveWithGeneratedIdentifier(object, Cascades.ACTION_SAVE_UPDATE, null);
        this.reassociateProxy(obj, id);
        return id;
    }

    private void forceFlush(EntityEntry e) throws HibernateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("flushing to force deletion of re-saved object: " + MessageHelper.infoString(e.persister, e.id)));
        }
        if (this.cascading > 0) {
            throw new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", e.id, e.persister.getMappedClass());
        }
        this.flush();
    }

    private Serializable saveWithGeneratedIdentifier(Object object, Cascades.CascadingAction action, Object anything) throws HibernateException {
        ClassPersister persister = this.getPersister(object);
        try {
            Serializable id = persister.getIdentifierGenerator().generate(this, object);
            if (id == null) {
                throw new IdentifierGenerationException("null identifier generated");
            }
            if (id == IdentifierGeneratorFactory.SHORT_CIRCUIT_INDICATOR) {
                return this.getIdentifier(object);
            }
            if (id == IdentifierGeneratorFactory.IDENTITY_COLUMN_INDICATOR) {
                return this.doSave(object, null, persister, true, action, anything);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("generated identifier: " + id));
            }
            return this.doSave(object, id, persister, false, action, anything);
        }
        catch (SQLException sqle) {
            throw new JDBCException("Could not save object", sqle);
        }
    }

    public void save(Object obj, Serializable id) throws HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to insert null");
        }
        if (id == null) {
            throw new NullPointerException("null identifier passed to insert()");
        }
        Object object = this.unproxy(obj);
        EntityEntry e = this.getEntry(object);
        if (e != null) {
            if (e.status == DELETED) {
                this.forceFlush(e);
            } else {
                if (!id.equals(e.id)) {
                    throw new PersistentObjectException("object passed to save() was already persistent: " + MessageHelper.infoString(e.persister, id));
                }
                log.trace((Object)"object already associated with session");
            }
        }
        this.doSave(object, id, this.getPersister(object), false, Cascades.ACTION_SAVE_UPDATE, null);
        this.reassociateProxy(obj, id);
    }

    private Serializable doSave(Object object, Serializable id, ClassPersister persister, boolean useIdentityColumn, Cascades.CascadingAction cascadeAction, Object anything) throws HibernateException {
        Key key;
        if (log.isTraceEnabled()) {
            log.trace((Object)("saving " + MessageHelper.infoString(persister, id)));
        }
        if (useIdentityColumn) {
            key = null;
        } else {
            key = new Key(id, persister);
            Object old = this.getEntity(key);
            if (old != null) {
                EntityEntry e = this.getEntry(old);
                if (e.status == DELETED) {
                    this.forceFlush(e);
                } else {
                    throw new NonUniqueObjectException(id, persister.getMappedClass());
                }
            }
            persister.setIdentifier(object, id);
        }
        if (persister.implementsLifecycle()) {
            log.debug((Object)"calling onSave()");
            if (((Lifecycle)object).onSave(this)) {
                log.debug((Object)"insertion vetoed by onSave()");
                return id;
            }
        }
        return this.doSave(object, key, persister, false, useIdentityColumn, cascadeAction, anything);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable doSave(Object object, Key key, ClassPersister persister, boolean replicate, boolean useIdentityColumn, Cascades.CascadingAction cascadeAction, Object anything) throws HibernateException {
        Serializable id;
        if (persister.implementsValidatable()) {
            ((Validatable)object).validate();
        }
        if (useIdentityColumn) {
            id = null;
            this.executeInserts();
        } else {
            id = key.getIdentifier();
        }
        this.addEntry(object, SAVING, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false);
        ++this.cascading;
        try {
            Cascades.cascade(this, persister, object, cascadeAction, 2, anything);
        }
        finally {
            --this.cascading;
        }
        Object[] values = persister.getPropertyValues(object);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = false;
        if (!replicate) {
            substitute = this.interceptor.onSave(object, id, values, persister.getPropertyNames(), types);
            if (persister.isVersioned()) {
                boolean bl = substitute = Versioning.seedVersion(values, persister.getVersionProperty(), persister.getVersionType()) || substitute;
            }
        }
        if (persister.hasCollections()) {
            ProxyVisitor visitor;
            if (replicate) {
                visitor = new OnReplicateVisitor(this, id);
                visitor.processValues(values, types);
            }
            visitor = new WrapVisitor(this);
            ((WrapVisitor)visitor).processValues(values, types);
            boolean bl = substitute = substitute || ((WrapVisitor)visitor).isSubstitutionRequired();
        }
        if (substitute) {
            persister.setPropertyValues(object, values);
        }
        TypeFactory.deepCopy(values, types, persister.getPropertyUpdateability(), values);
        this.nullifyTransientReferences(values, types, useIdentityColumn, object);
        SessionImpl.checkNullability(values, persister, false);
        if (useIdentityColumn) {
            ScheduledIdentityInsertion insert = new ScheduledIdentityInsertion(values, object, persister, this);
            insert.execute();
            this.executions.add(insert);
            id = insert.getGeneratedId();
            persister.setIdentifier(object, id);
            key = new Key(id, persister);
            this.checkUniqueness(key, object);
        }
        Object version = Versioning.getVersion(values, persister);
        this.addEntity(key, object);
        this.addEntry(object, LOADED, values, id, version, LockMode.WRITE, useIdentityColumn, persister, replicate);
        if (!useIdentityColumn) {
            this.insertions.add(new ScheduledInsertion(id, values, object, persister, this));
        }
        ++this.cascading;
        try {
            Cascades.cascade(this, persister, object, cascadeAction, 1, anything);
        }
        finally {
            --this.cascading;
        }
        return id;
    }

    boolean reassociateIfUninitializedProxy(Object value) throws MappingException {
        if (!Hibernate.isInitialized(value)) {
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer(proxy);
            this.reassociateProxy(li, proxy);
            return true;
        }
        return false;
    }

    private void reassociateProxy(Object value, Serializable id) throws MappingException {
        if (value instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)value;
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer(proxy);
            li.setIdentifier(id);
            this.reassociateProxy(li, proxy);
        }
    }

    private Object unproxy(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer(proxy);
            if (li.isUninitialized()) {
                throw new PersistentObjectException("object was an uninitialized proxy for: " + li.getPersistentClass().getName());
            }
            return li.getImplementation();
        }
        return maybeProxy;
    }

    private Object unproxyAndReassociate(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer(proxy);
            this.reassociateProxy(li, proxy);
            return li.getImplementation();
        }
        return maybeProxy;
    }

    private void reassociateProxy(LazyInitializer li, HibernateProxy proxy) throws MappingException {
        if (li.getSession() != this) {
            ClassPersister persister = this.getClassPersister(li.getPersistentClass());
            Key key = new Key(li.getIdentifier(), persister);
            if (!this.proxiesByKey.containsKey(key)) {
                this.proxiesByKey.put(key, proxy);
            }
            HibernateProxyHelper.getLazyInitializer(proxy).setSession(this);
        }
    }

    private void nullifyTransientReferences(Object[] values, Type[] types, boolean earlyInsert, Object self) throws HibernateException {
        for (int i = 0; i < types.length; ++i) {
            values[i] = this.nullifyTransientReferences(values[i], types[i], earlyInsert, self);
        }
    }

    private Object nullifyTransientReferences(Object value, Type type, boolean earlyInsert, Object self) throws HibernateException {
        if (value == null) {
            return null;
        }
        if (type.isEntityType() || type.isObjectType()) {
            return this.isUnsaved(value, earlyInsert, self) ? null : value;
        }
        if (type.isComponentType()) {
            AbstractComponentType actype = (AbstractComponentType)type;
            Object[] subvalues = actype.getPropertyValues(value, this);
            Type[] subtypes = actype.getSubtypes();
            boolean substitute = false;
            for (int i = 0; i < subvalues.length; ++i) {
                Object replacement = this.nullifyTransientReferences(subvalues[i], subtypes[i], earlyInsert, self);
                if (replacement == subvalues[i]) continue;
                substitute = true;
                subvalues[i] = replacement;
            }
            if (substitute) {
                actype.setPropertyValues(value, subvalues);
            }
            return value;
        }
        return value;
    }

    private boolean isUnsaved(Object object, boolean earlyInsert, Object self) throws HibernateException {
        if (object instanceof HibernateProxy) {
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
            if (li.getImplementation(this) == null) {
                return false;
            }
            object = li.getImplementation();
        }
        if (object == self) {
            return earlyInsert;
        }
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            return this.getPersister(object).isUnsaved(object);
        }
        return e.status == SAVING || (earlyInsert ? !e.existsInDatabase : this.nullifiables.contains(new Key(e.id, e.persister)));
    }

    public void delete(Object object) throws HibernateException {
        ClassPersister persister;
        if (object == null) {
            throw new NullPointerException("attempted to delete null");
        }
        EntityEntry entry = this.getEntry(object = this.unproxyAndReassociate(object));
        if (entry == null) {
            log.trace((Object)"deleting a transient instance");
            persister = this.getPersister(object);
            Serializable id = persister.getIdentifier(object);
            if (id == null) {
                throw new TransientObjectException("the transient instance passed to delete() had a null identifier");
            }
            Object old = this.getEntity(new Key(id, persister));
            if (old != null) {
                throw new NonUniqueObjectException(id, persister.getMappedClass());
            }
            new OnUpdateVisitor(this, id).process(object, persister);
            this.addEntity(new Key(id, persister), object);
            entry = this.addEntry(object, LOADED, persister.getPropertyValues(object), id, persister.getVersion(object), LockMode.NONE, true, persister, false);
        } else {
            log.trace((Object)"deleting a persistent instance");
            if (entry.status == DELETED || entry.status == GONE) {
                log.trace((Object)"object was already deleted");
                return;
            }
            persister = entry.persister;
        }
        if (!persister.isMutable()) {
            throw new HibernateException("attempted to delete an object of immutable class: " + MessageHelper.infoString(persister));
        }
        this.doDelete(object, entry, persister);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDelete(Object object, EntityEntry entry, ClassPersister persister) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("deleting " + MessageHelper.infoString(persister, entry.id)));
        }
        Type[] types = persister.getPropertyTypes();
        Object version = entry.version;
        Object[] loadedState = entry.loadedState == null ? persister.getPropertyValues(object) : entry.loadedState;
        entry.deletedState = new Object[types.length];
        TypeFactory.deepCopy(loadedState, types, persister.getPropertyUpdateability(), entry.deletedState);
        this.interceptor.onDelete(object, entry.id, entry.deletedState, persister.getPropertyNames(), types);
        entry.status = DELETED;
        Key key = new Key(entry.id, persister);
        List deletionsByOnDelete = null;
        HashSet nullifiablesAfterOnDelete = null;
        if (persister.implementsLifecycle()) {
            HashSet oldNullifiables = (HashSet)this.nullifiables.clone();
            ArrayList oldDeletions = (ArrayList)this.deletions.clone();
            this.nullifiables.add(key);
            try {
                log.debug((Object)"calling onDelete()");
                if (((Lifecycle)object).onDelete(this)) {
                    entry.status = LOADED;
                    entry.deletedState = null;
                    this.nullifiables = oldNullifiables;
                    log.debug((Object)"deletion vetoed by onDelete()");
                    return;
                }
            }
            catch (CallbackException ce) {
                entry.status = LOADED;
                entry.deletedState = null;
                this.nullifiables = oldNullifiables;
                throw ce;
            }
            if (oldDeletions.size() > this.deletions.size()) {
                throw new HibernateException("session was flushed during onDelete()");
            }
            deletionsByOnDelete = this.deletions.subList(oldDeletions.size(), this.deletions.size());
            this.deletions = oldDeletions;
            nullifiablesAfterOnDelete = this.nullifiables;
            this.nullifiables = oldNullifiables;
        }
        ++this.cascading;
        try {
            Cascades.cascade(this, persister, object, Cascades.ACTION_DELETE, 1);
        }
        finally {
            --this.cascading;
        }
        this.nullifyTransientReferences(entry.deletedState, types, false, object);
        SessionImpl.checkNullability(entry.deletedState, persister, true);
        this.nullifiables.add(key);
        ScheduledDeletion delete = new ScheduledDeletion(entry.id, version, object, persister, this);
        this.deletions.add(delete);
        if (persister.implementsLifecycle()) {
            this.nullifiables.addAll(nullifiablesAfterOnDelete);
            this.deletions.addAll(deletionsByOnDelete);
        }
        ++this.cascading;
        try {
            Cascades.cascade(this, persister, object, Cascades.ACTION_DELETE, 2);
        }
        finally {
            --this.cascading;
        }
    }

    private static void checkNullability(Object[] values, ClassPersister persister, boolean isUpdate) throws PropertyValueException {
        boolean[] nullability = persister.getPropertyNullability();
        boolean[] checkability = isUpdate ? persister.getPropertyUpdateability() : persister.getPropertyInsertability();
        for (int i = 0; i < values.length; ++i) {
            if (nullability[i] || !checkability[i] || values[i] != null) continue;
            throw new PropertyValueException("not-null property references a null or transient value: ", persister.getMappedClass(), persister.getPropertyNames()[i]);
        }
    }

    void removeCollection(CollectionPersister role, Serializable id) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("collection dereferenced while transient " + MessageHelper.infoString(role, id)));
        }
        this.collectionRemovals.add(new ScheduledCollectionRemove(role, id, false, this));
    }

    static boolean isCollectionSnapshotValid(CollectionSnapshot snapshot) {
        return snapshot != null && snapshot.getRole() != null && snapshot.getKey() != null;
    }

    static boolean isOwnerUnchanged(CollectionSnapshot snapshot, CollectionPersister persister, Serializable id) {
        return SessionImpl.isCollectionSnapshotValid(snapshot) && persister.getRole().equals(snapshot.getRole()) && id.equals(snapshot.getKey());
    }

    void reattachCollection(PersistentCollection collection, CollectionSnapshot snapshot) throws HibernateException {
        if (collection.wasInitialized()) {
            this.addInitializedDetachedCollection(collection, snapshot);
        } else {
            if (!SessionImpl.isCollectionSnapshotValid(snapshot)) {
                throw new HibernateException("could not reassociate uninitialized transient collection");
            }
            this.addUninitializedDetachedCollection(collection, this.getCollectionPersister(snapshot.getRole()), snapshot.getKey());
        }
    }

    public void update(Object obj) throws HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to update null");
        }
        if (this.reassociateIfUninitializedProxy(obj)) {
            return;
        }
        Object object = this.unproxyAndReassociate(obj);
        ClassPersister persister = this.getPersister(object);
        if (this.isEntryFor(object)) {
            log.trace((Object)"object already associated with session");
        } else {
            Serializable id = persister.getIdentifier(object);
            if (id == null) {
                throw new HibernateException("The given object has a null identifier property " + MessageHelper.infoString(persister));
            }
            this.doUpdate(object, id, persister);
        }
    }

    public void saveOrUpdate(Object obj) throws HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to update null");
        }
        if (this.reassociateIfUninitializedProxy(obj)) {
            return;
        }
        Object object = this.unproxyAndReassociate(obj);
        EntityEntry e = this.getEntry(object);
        if (e != null && e.status != DELETED) {
            log.trace((Object)"saveOrUpdate() persistent instance");
        } else if (e != null) {
            log.trace((Object)"saveOrUpdate() deleted instance");
            this.save(obj);
        } else {
            Boolean isUnsaved = this.interceptor.isUnsaved(object);
            ClassPersister persister = this.getPersister(object);
            if (isUnsaved == null) {
                if (persister.isUnsaved(object)) {
                    log.trace((Object)"saveOrUpdate() unsaved instance");
                    this.save(obj);
                } else {
                    Serializable id = persister.getIdentifier(object);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("saveOrUpdate() previously saved instance with id: " + id));
                    }
                    this.doUpdate(object, id, persister);
                }
            } else if (isUnsaved.booleanValue()) {
                log.trace((Object)"saveOrUpdate() unsaved instance");
                this.save(obj);
            } else {
                log.trace((Object)"saveOrUpdate() previously saved instance");
                this.doUpdate(object, persister.getIdentifier(object), persister);
            }
        }
    }

    public void update(Object obj, Serializable id) throws HibernateException {
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        if (obj == null) {
            throw new NullPointerException("attempted to update null");
        }
        if (obj instanceof HibernateProxy) {
            HibernateProxyHelper.getLazyInitializer((HibernateProxy)obj).setIdentifier(id);
        }
        if (this.reassociateIfUninitializedProxy(obj)) {
            return;
        }
        Object object = this.unproxyAndReassociate(obj);
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            ClassPersister persister = this.getPersister(object);
            persister.setIdentifier(object, id);
            this.doUpdate(object, id, persister);
        } else if (!e.id.equals(id)) {
            throw new PersistentObjectException("The instance passed to update() was already persistent: " + MessageHelper.infoString(e.persister, id));
        }
    }

    private void doUpdateMutable(Object object, Serializable id, ClassPersister persister) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("updating " + MessageHelper.infoString(persister, id)));
        }
        Key key = new Key(id, persister);
        this.checkUniqueness(key, object);
        if (persister.implementsLifecycle()) {
            log.debug((Object)"calling onUpdate()");
            if (((Lifecycle)object).onUpdate(this)) {
                log.debug((Object)"update vetoed by onUpdate()");
                this.reassociate(object, id, persister);
                return;
            }
        }
        new OnUpdateVisitor(this, id).process(object, persister);
        this.addEntity(key, object);
        this.addEntry(object, LOADED, null, id, persister.getVersion(object), LockMode.NONE, true, persister, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Object object, Serializable id, ClassPersister persister) throws HibernateException {
        if (!persister.isMutable()) {
            log.trace((Object)"immutable instance passed to doUpdate(), locking");
            this.reassociate(object, id, persister);
        } else {
            this.doUpdateMutable(object, id, persister);
        }
        ++this.cascading;
        try {
            Cascades.cascade(this, persister, object, Cascades.ACTION_SAVE_UPDATE, 0);
        }
        finally {
            --this.cascading;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReplicate(Object object, Serializable id, Object version, ReplicationMode replicationMode, ClassPersister persister) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("replicating changes to " + MessageHelper.infoString(persister, id)));
        }
        new OnReplicateVisitor(this, id).process(object, persister);
        Key key = new Key(id, persister);
        this.addEntity(key, object);
        this.addEntry(object, LOADED, null, id, version, LockMode.NONE, true, persister, true);
        ++this.cascading;
        try {
            Cascades.cascade(this, persister, object, Cascades.ACTION_REPLICATE, 0, replicationMode);
        }
        finally {
            --this.cascading;
        }
    }

    public List find(String query) throws HibernateException {
        return this.find(query, NO_ARGS, NO_TYPES);
    }

    public List find(String query, Object value, Type type) throws HibernateException {
        return this.find(query, new Object[]{value}, new Type[]{type});
    }

    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        return this.find(query, new QueryParameters(types, values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List find(String query, QueryParameters queryParameters) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("find: " + query));
            queryParameters.traceParameters(this.factory);
        }
        queryParameters.validateParameters();
        QueryTranslator[] q = this.getQueries(query, false);
        List results = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        try {
            for (int i = 0; i < q.length; ++i) {
                List currentResults;
                try {
                    currentResults = q[i].list(this, queryParameters);
                }
                catch (SQLException sqle) {
                    throw new JDBCException("Could not execute query", sqle);
                }
                currentResults.addAll(results);
                results = currentResults;
            }
        }
        finally {
            --this.dontFlushFromFind;
        }
        return results;
    }

    private QueryTranslator[] getQueries(String query, boolean scalar) throws HibernateException {
        QueryTranslator[] q = this.factory.getQuery(query, scalar);
        HashSet qs = new HashSet();
        for (int i = 0; i < q.length; ++i) {
            qs.addAll(q[i].getQuerySpaces());
        }
        this.autoFlushIfRequired(qs);
        return q;
    }

    public Iterator iterate(String query) throws HibernateException {
        return this.iterate(query, NO_ARGS, NO_TYPES);
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        return this.iterate(query, new Object[]{value}, new Type[]{type});
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        return this.iterate(query, new QueryParameters(types, values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        boolean many;
        QueryTranslator[] q;
        if (log.isTraceEnabled()) {
            log.trace((Object)("iterate: " + query));
            queryParameters.traceParameters(this.factory);
        }
        if ((q = this.getQueries(query, true)).length == 0) {
            return EmptyIterator.INSTANCE;
        }
        Iterator result = null;
        Iterator[] results = null;
        boolean bl = many = q.length > 1;
        if (many) {
            results = new Iterator[q.length];
        }
        ++this.dontFlushFromFind;
        try {
            for (int i = 0; i < q.length; ++i) {
                try {
                    result = q[i].iterate(queryParameters, this);
                }
                catch (SQLException sqle) {
                    throw new JDBCException("Could not execute query", sqle);
                }
                if (!many) continue;
                results[i] = result;
            }
            JoinedIterator joinedIterator = many ? new JoinedIterator(results) : result;
            return joinedIterator;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        QueryTranslator[] q;
        if (log.isTraceEnabled()) {
            log.trace((Object)("scroll: " + query));
            queryParameters.traceParameters(this.factory);
        }
        if ((q = this.factory.getQuery(query, true)).length != 1) {
            throw new QueryException("implicit polymorphism not supported for scroll() queries");
        }
        this.autoFlushIfRequired(q[0].getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = q[0].scroll(queryParameters, this);
            return scrollableResults;
        }
        catch (SQLException sqle) {
            throw new JDBCException("Could not execute query", sqle);
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    public int delete(String query) throws HibernateException {
        return this.delete(query, NO_ARGS, NO_TYPES);
    }

    public int delete(String query, Object value, Type type) throws HibernateException {
        return this.delete(query, new Object[]{value}, new Type[]{type});
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("delete: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        List list = this.find(query, values, types);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.delete(list.get(i));
        }
        return size;
    }

    private void checkUniqueness(Key key, Object object) throws HibernateException {
        Object entity = this.getEntity(key);
        if (entity == object) {
            throw new AssertionFailure("object already associated in doSave()");
        }
        if (entity != null) {
            throw new NonUniqueObjectException(key.getIdentifier(), key.getMappedClass());
        }
    }

    private EntityEntry reassociate(Object object, Serializable id, ClassPersister persister) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("reassociating transient instance: " + MessageHelper.infoString(persister, id)));
        }
        Key key = new Key(id, persister);
        this.checkUniqueness(key, object);
        this.addEntity(key, object);
        Object[] values = persister.getPropertyValues(object);
        TypeFactory.deepCopy(values, persister.getPropertyTypes(), persister.getPropertyUpdateability(), values);
        Object version = Versioning.getVersion(values, persister);
        EntityEntry newEntry = this.addEntry(object, LOADED, values, id, version, LockMode.NONE, true, persister, false);
        new OnLockVisitor(this, id).process(object, persister);
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object object, LockMode lockMode) throws HibernateException {
        if (object == null) {
            throw new NullPointerException("attempted to lock null");
        }
        if (lockMode == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for lock()");
        }
        EntityEntry entry = this.getEntry(object = this.unproxyAndReassociate(object));
        if (entry == null) {
            ClassPersister persister = this.getPersister(object);
            Serializable id = persister.getIdentifier(object);
            if (!this.isSaved(object)) {
                throw new HibernateException("cannot lock an unsaved transient instance: " + MessageHelper.infoString(persister));
            }
            entry = this.reassociate(object, id, persister);
            ++this.cascading;
            try {
                Cascades.cascade(this, persister, object, Cascades.ACTION_LOCK, 0, lockMode);
            }
            finally {
                --this.cascading;
            }
        }
        this.upgradeLock(object, entry, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void upgradeLock(Object object, EntityEntry entry, LockMode lockMode) throws HibernateException {
        if (!lockMode.greaterThan(entry.lockMode)) return;
        if (entry.status != LOADED) {
            throw new ObjectDeletedException("attempted to lock a deleted instance", entry.id, object.getClass());
        }
        ClassPersister persister = entry.persister;
        if (log.isTraceEnabled()) {
            log.trace((Object)("locking " + MessageHelper.infoString(persister, entry.id) + " in mode: " + lockMode));
        }
        CacheConcurrencyStrategy.SoftLock lock = null;
        if (persister.hasCache()) {
            lock = persister.getCache().lock(entry.id);
        }
        try {
            persister.lock(entry.id, entry.version, object, lockMode, this);
            entry.lockMode = lockMode;
            Object var7_6 = null;
            if (!persister.hasCache()) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!persister.hasCache()) throw throwable;
            persister.getCache().release(entry.id, lock);
            throw throwable;
        }
        persister.getCache().release(entry.id, lock);
    }

    public Query createFilter(Object collection, String queryString) {
        return new FilterImpl(queryString, collection, this);
    }

    public Query createQuery(String queryString) {
        return new QueryImpl(queryString, this);
    }

    public Query getNamedQuery(String queryName) throws MappingException {
        String queryString = this.factory.getNamedQuery(queryName);
        if (queryString != null) {
            return this.createQuery(queryString);
        }
        SessionFactoryImpl.InternalNamedSQLQuery nq = this.factory.getNamedSQLQuery(queryName);
        if (nq == null) {
            throw new MappingException("Named query not known: " + queryName);
        }
        return this.createSQLQuery(nq.getQueryString(), nq.getReturnAliases(), nq.getReturnClasses(), nq.getQuerySpaces());
    }

    public Object instantiate(Class clazz, Serializable id) throws HibernateException {
        return this.instantiate(this.factory.getPersister(clazz), id);
    }

    public Object instantiate(ClassPersister persister, Serializable id) throws HibernateException {
        Object result = this.interceptor.instantiate(persister.getMappedClass(), id);
        if (result == null) {
            result = persister.instantiate(id);
        }
        return result;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    private boolean autoFlushIfRequired(Set querySpaces) throws HibernateException {
        if (this.flushMode == FlushMode.AUTO && this.dontFlushFromFind == 0) {
            int oldSize = this.collectionRemovals.size();
            this.flushEverything();
            if (this.areTablesToBeUpdated(querySpaces)) {
                log.trace((Object)"Need to execute flush");
                this.execute();
                this.postFlush();
                return true;
            }
            log.trace((Object)"Dont need to execute flush");
            this.collectionCreations.clear();
            this.collectionUpdates.clear();
            this.updates.clear();
            for (int i = this.collectionRemovals.size() - 1; i >= oldSize; --i) {
                this.collectionRemovals.remove(i);
            }
        }
        return false;
    }

    public Object narrowProxy(Object proxy, ClassPersister persister, Key key, Object object) throws HibernateException {
        if (!persister.getConcreteProxyClass().isAssignableFrom(proxy.getClass())) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Narrowing proxy to " + persister.getConcreteProxyClass() + " - this operation breaks =="));
            }
            if (object != null) {
                this.proxiesByKey.remove(key);
                return object;
            }
            proxy = persister.createProxy(key.getIdentifier(), this);
            this.proxiesByKey.put(key, proxy);
            return proxy;
        }
        return proxy;
    }

    public Object proxyFor(ClassPersister persister, Key key, Object impl) throws HibernateException {
        if (!persister.hasProxy()) {
            return impl;
        }
        Object proxy = this.proxiesByKey.get(key);
        if (proxy != null) {
            return this.narrowProxy(proxy, persister, key, impl);
        }
        return impl;
    }

    public Object proxyFor(Object impl) throws HibernateException {
        EntityEntry e = this.getEntry(impl);
        ClassPersister p = this.getPersister(impl);
        return this.proxyFor(p, new Key(e.id, p), impl);
    }

    public void addUninitializedEntity(Key key, Object object, LockMode lockMode) {
        this.addEntity(key, object);
        this.addEntry(object, LOADING, null, key.getIdentifier(), null, lockMode, true, null, false);
    }

    public void postHydrate(ClassPersister persister, Serializable id, Object[] values, Object object, LockMode lockMode) throws HibernateException {
        Object version = Versioning.getVersion(values, persister);
        this.addEntry(object, LOADING, values, id, version, lockMode, true, persister, false);
        if (log.isTraceEnabled() && version != null) {
            log.trace((Object)("Version: " + version));
        }
    }

    public void load(Object object, Serializable id) throws HibernateException {
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        this.doLoadByObject(object, id, LockMode.NONE);
    }

    public Object load(Class clazz, Serializable id) throws HibernateException {
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        Object result = this.doLoadByClass(clazz, id, true, true);
        ObjectNotFoundException.throwIfNull(result, id, clazz);
        return result;
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        return this.doLoadByClass(clazz, id, true, false);
    }

    public Object immediateLoad(Class clazz, Serializable id) throws HibernateException {
        Object result = this.doLoad(clazz, id, null, LockMode.NONE, false);
        ObjectNotFoundException.throwIfNull(result, id, clazz);
        return result;
    }

    public Object internalLoadOneToOne(Class clazz, Serializable id) throws HibernateException {
        return this.doLoadByClass(clazz, id, false, false);
    }

    public Object internalLoad(Class clazz, Serializable id) throws HibernateException {
        Object result = this.doLoadByClass(clazz, id, false, true);
        UnresolvableObjectException.throwIfNull(result, id, clazz);
        return result;
    }

    private void doLoadByObject(Object object, Serializable id, LockMode lockMode) throws HibernateException {
        Class<?> clazz = object.getClass();
        if (this.getEntry(object) != null) {
            throw new PersistentObjectException("attempted to load into an instance that was already associated with the Session: " + MessageHelper.infoString(clazz, id));
        }
        Object result = this.doLoad(clazz, id, object, lockMode, true);
        ObjectNotFoundException.throwIfNull(result, id, clazz);
        if (result != object) {
            throw new NonUniqueObjectException(id, clazz);
        }
    }

    private Object doLoadByClass(Class clazz, Serializable id, boolean checkDeleted, boolean allowProxyCreation) throws HibernateException {
        ClassPersister persister;
        if (log.isTraceEnabled()) {
            log.trace((Object)("loading " + MessageHelper.infoString(clazz, id)));
        }
        if (!(persister = this.getClassPersister(clazz)).hasProxy()) {
            return this.doLoad(clazz, id, null, LockMode.NONE, checkDeleted);
        }
        Key key = new Key(id, persister);
        if (this.getEntity(key) != null) {
            return this.proxyFor(persister, key, this.doLoad(clazz, id, null, LockMode.NONE, checkDeleted));
        }
        Object proxy = this.proxiesByKey.get(key);
        if (proxy != null) {
            return this.narrowProxy(proxy, persister, key, null);
        }
        if (allowProxyCreation) {
            proxy = persister.createProxy(id, this);
            if (persister.isBatchLoadable()) {
                this.batchLoadableEntityKeys.put(key, MARKER);
            }
            this.proxiesByKey.put(key, proxy);
            return proxy;
        }
        return this.doLoad(clazz, id, null, LockMode.NONE, checkDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object doLoad(Class clazz, Serializable id, LockMode lockMode, boolean allowNull) throws HibernateException {
        Object result;
        ClassPersister persister;
        block7: {
            if (id == null) {
                throw new NullPointerException("null is not a valid identifier");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("loading " + MessageHelper.infoString(clazz, id) + " in lock mode: " + lockMode));
            }
            persister = this.getClassPersister(clazz);
            CacheConcurrencyStrategy.SoftLock lock = null;
            if (persister.hasCache()) {
                lock = persister.getCache().lock(id);
            }
            try {
                result = this.doLoad(clazz, id, null, lockMode, true);
                Object var9_8 = null;
                if (!persister.hasCache()) break block7;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                if (persister.hasCache()) {
                    persister.getCache().release(id, lock);
                }
                throw throwable;
            }
            persister.getCache().release(id, lock);
        }
        if (!allowNull) {
            ObjectNotFoundException.throwIfNull(result, id, persister.getMappedClass());
        }
        return this.proxyFor(persister, new Key(id, persister), result);
    }

    public Object load(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        if (lockMode == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for load()");
        }
        if (lockMode == LockMode.NONE) {
            return this.load(clazz, id);
        }
        return this.doLoad(clazz, id, lockMode, false);
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        if (lockMode == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for get()");
        }
        if (lockMode == LockMode.NONE) {
            return this.get(clazz, id);
        }
        return this.doLoad(clazz, id, lockMode, true);
    }

    private Object doLoad(Class clazz, Serializable id, Object optionalObject, LockMode lockMode, boolean checkDeleted) throws HibernateException {
        Object result;
        CacheEntry entry;
        Object old;
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to resolve " + MessageHelper.infoString(clazz, id)));
        }
        ClassPersister persister = this.getClassPersister(clazz);
        Key key = new Key(id, persister);
        if (optionalObject != null) {
            persister.setIdentifier(optionalObject, id);
        }
        if ((old = this.getEntity(key)) != null) {
            EntityEntry oldEntry = this.getEntry(old);
            Status status = oldEntry.status;
            if (checkDeleted && (status == DELETED || status == GONE)) {
                throw new ObjectDeletedException("The object with that id was deleted", id, clazz);
            }
            this.upgradeLock(old, oldEntry, lockMode);
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved object in session cache " + MessageHelper.infoString(persister, id)));
            }
            return old;
        }
        if (this.nonExists.contains(key)) {
            return null;
        }
        CacheEntry cacheEntry = entry = persister.hasCache() && lockMode.lessThan(LockMode.READ) ? (CacheEntry)persister.getCache().get(id, this.getTimestamp()) : null;
        if (entry != null) {
            return this.assembleCacheEntry(entry, id, persister, optionalObject);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("object not resolved in any cache " + MessageHelper.infoString(persister, id)));
        }
        if ((result = persister.load(id, optionalObject, lockMode, this)) == null) {
            this.addNonExist(key);
        }
        return result;
    }

    private Object assembleCacheEntry(CacheEntry entry, Serializable id, ClassPersister persister, Object optionalObject) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("resolved object in second-level cache " + MessageHelper.infoString(persister, id)));
        }
        ClassPersister subclassPersister = this.getClassPersister(entry.getSubclass());
        Object result = optionalObject == null ? this.instantiate(subclassPersister, id) : optionalObject;
        this.addEntry(result, LOADING, null, id, null, LockMode.NONE, true, subclassPersister, false);
        this.addEntity(new Key(id, persister), result);
        Type[] types = subclassPersister.getPropertyTypes();
        Object[] values = entry.assemble(result, id, subclassPersister, this.interceptor, this);
        TypeFactory.deepCopy(values, types, subclassPersister.getPropertyUpdateability(), values);
        Object version = Versioning.getVersion(values, subclassPersister);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Cached Version: " + version));
        }
        this.addEntry(result, LOADED, values, id, version, LockMode.NONE, true, subclassPersister, false);
        this.initializeNonLazyCollections();
        return result;
    }

    public void refresh(Object object) throws HibernateException {
        this.refresh(object, LockMode.READ);
    }

    public void refresh(Object obj, LockMode lockMode) throws HibernateException {
        Serializable id;
        ClassPersister persister;
        if (obj == null) {
            throw new NullPointerException("attempted to refresh null");
        }
        if (this.reassociateIfUninitializedProxy(obj)) {
            return;
        }
        Object object = this.unproxyAndReassociate(obj);
        EntityEntry e = this.removeEntry(object);
        if (e == null) {
            persister = this.getPersister(object);
            id = persister.getIdentifier(object);
            if (log.isTraceEnabled()) {
                log.trace((Object)("refreshing transient " + MessageHelper.infoString(persister, id)));
            }
            if (this.getEntry(new Key(id, persister)) != null) {
                throw new PersistentObjectException("attempted to refresh transient instance when persistent instance was already associated with the Session: " + MessageHelper.infoString(persister, id));
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("refreshing " + MessageHelper.infoString(e.persister, e.id)));
            }
            if (!e.existsInDatabase) {
                throw new HibernateException("this instance does not yet exist as a row in the database");
            }
            persister = e.persister;
            id = e.id;
            Key key = new Key(id, persister);
            this.removeEntity(key);
            if (persister.hasCollections()) {
                new EvictVisitor(this).process(obj, persister);
            }
        }
        if (persister.hasCache()) {
            persister.getCache().remove(id);
        }
        this.evictCachedCollections(persister, id);
        Object result = persister.load(id, object, lockMode, this);
        UnresolvableObjectException.throwIfNull(result, id, persister.getMappedClass());
    }

    public void initializeEntity(Object object) throws HibernateException {
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        ClassPersister persister = e.persister;
        Serializable id = e.id;
        Object[] hydratedState = e.loadedState;
        Type[] types = persister.getPropertyTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolving associations for " + MessageHelper.infoString(persister, id)));
        }
        for (int i = 0; i < hydratedState.length; ++i) {
            hydratedState[i] = types[i].resolveIdentifier(hydratedState[i], this, object);
        }
        this.interceptor.onLoad(object, id, hydratedState, persister.getPropertyNames(), types);
        persister.setPropertyValues(object, hydratedState);
        if (persister.hasCache()) {
            log.debug((Object)("adding entity to second-level cache " + MessageHelper.infoString(persister, id)));
            persister.getCache().put(id, new CacheEntry(object, persister, this), this.getTimestamp());
        }
        if (persister.implementsLifecycle()) {
            log.debug((Object)"calling onLoad()");
            ((Lifecycle)object).onLoad(this, id);
        }
        TypeFactory.deepCopy(hydratedState, persister.getPropertyTypes(), persister.getPropertyUpdateability(), hydratedState);
        e.status = LOADED;
        if (log.isDebugEnabled()) {
            log.debug((Object)("done materializing entity " + MessageHelper.infoString(persister, id)));
        }
    }

    public Transaction beginTransaction() throws HibernateException {
        Transaction tx = this.factory.getTransactionFactory().beginTransaction(this);
        this.isCurrentTransaction = true;
        return tx;
    }

    public void flush() throws HibernateException {
        if (this.cascading > 0) {
            throw new HibernateException("Flush during cascade is dangerous");
        }
        this.flushEverything();
        this.execute();
        this.postFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushEverything() throws HibernateException {
        log.trace((Object)"flushing session");
        this.interceptor.preFlush(this.entitiesByKey.values().iterator());
        this.preFlushEntities();
        this.preFlushCollections();
        this.flushing = true;
        try {
            this.flushEntities();
            this.flushCollections();
        }
        finally {
            this.flushing = false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flushed: " + this.insertions.size() + " insertions, " + this.updates.size() + " updates, " + this.deletions.size() + " deletions to " + this.entityEntries.size() + " objects"));
            log.debug((Object)("Flushed: " + this.collectionCreations.size() + " (re)creations, " + this.collectionUpdates.size() + " updates, " + this.collectionRemovals.size() + " removals to " + this.collectionEntries.size() + " collections"));
            new Printer(this.factory).toString(this.entitiesByKey.values().iterator());
        }
    }

    private boolean areTablesToBeUpdated(Set tables) {
        return SessionImpl.areTablesToUpdated(this.updates, tables) || SessionImpl.areTablesToUpdated(this.insertions, tables) || SessionImpl.areTablesToUpdated(this.deletions, tables) || SessionImpl.areTablesToUpdated(this.collectionUpdates, tables) || SessionImpl.areTablesToUpdated(this.collectionCreations, tables) || SessionImpl.areTablesToUpdated(this.collectionRemovals, tables);
    }

    private static boolean areTablesToUpdated(List executables, Set set) {
        int size = executables.size();
        for (int j = 0; j < size; ++j) {
            Serializable[] spaces = ((Executable)executables.get(j)).getPropertySpaces();
            for (int i = 0; i < spaces.length; ++i) {
                if (!set.contains(spaces[i])) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("changes must be flushed to space: " + spaces[i]));
                }
                return true;
            }
        }
        return false;
    }

    private void executeInserts() throws HibernateException {
        log.trace((Object)"executing insertions");
        this.executeAll(this.insertions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty() throws HibernateException {
        boolean bl;
        log.debug((Object)"checking session dirtiness");
        if (this.insertions.size() > 0 || this.deletions.size() > 0) {
            log.debug((Object)"session dirty (scheduled updates and insertions)");
            return true;
        }
        int oldSize = this.collectionRemovals.size();
        try {
            this.flushEverything();
            boolean result = this.updates.size() > 0 || this.insertions.size() > 0 || this.deletions.size() > 0 || this.collectionUpdates.size() > 0 || this.collectionRemovals.size() > 0 || this.collectionCreations.size() > 0;
            log.debug((Object)(result ? "session dirty" : "session not dirty"));
            bl = result;
            Object var5_4 = null;
            this.collectionCreations.clear();
            this.collectionUpdates.clear();
            this.updates.clear();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.collectionCreations.clear();
            this.collectionUpdates.clear();
            this.updates.clear();
            for (int i = this.collectionRemovals.size() - 1; i >= oldSize; --i) {
                this.collectionRemovals.remove(i);
            }
            throw throwable;
        }
        for (int i = this.collectionRemovals.size() - 1; i >= oldSize; --i) {
            this.collectionRemovals.remove(i);
        }
        return bl;
    }

    private void execute() throws HibernateException {
        log.trace((Object)"executing flush");
        try {
            this.beforeExecutionsAll(this.collectionRemovals);
            this.beforeExecutionsAll(this.collectionUpdates);
            this.beforeExecutionsAll(this.collectionCreations);
            this.executeAll(this.insertions);
            this.executeAll(this.updates);
            this.executeAll(this.collectionRemovals);
            this.executeAll(this.collectionUpdates);
            this.executeAll(this.collectionCreations);
            this.executeAll(this.deletions);
        }
        catch (HibernateException he) {
            log.error((Object)"Could not synchronize database state with session", (Throwable)he);
            throw he;
        }
    }

    public void postInsert(Object obj) {
        EntityEntry entry = this.getEntry(obj);
        if (entry == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        entry.existsInDatabase = true;
    }

    public void postDelete(Object obj) {
        EntityEntry entry = this.removeEntry(obj);
        if (entry == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        entry.status = GONE;
        entry.existsInDatabase = false;
        Key key = new Key(entry.id, entry.persister);
        this.removeEntity(key);
        this.proxiesByKey.remove(key);
    }

    public void postUpdate(Object obj, Object[] updatedState, Object nextVersion) throws HibernateException {
        EntityEntry entry = this.getEntry(obj);
        if (entry == null) {
            throw new AssertionFailure("possible nonthreadsafe access to session");
        }
        entry.loadedState = updatedState;
        entry.lockMode = LockMode.WRITE;
        if (entry.persister.isVersioned()) {
            entry.version = nextVersion;
            entry.persister.setPropertyValue(obj, entry.persister.getVersionProperty(), nextVersion);
        }
    }

    private void executeAll(List list) throws HibernateException {
        boolean lockQueryCache = this.factory.isQueryCacheEnabled();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Executable executable = (Executable)list.get(i);
            this.executions.add(executable);
            if (lockQueryCache) {
                this.factory.getUpdateTimestampsCache().preinvalidate(executable.getPropertySpaces());
            }
            executable.execute();
        }
        list.clear();
        if (this.batcher != null) {
            this.batcher.executeBatch();
        }
    }

    private void beforeExecutionsAll(List list) throws HibernateException {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Executable executable = (Executable)list.get(i);
            executable.beforeExecutions();
        }
    }

    private void flushEntities() throws HibernateException {
        log.trace((Object)"Flushing entities and processing referenced collections");
        List list = IdentityMap.concurrentEntries(this.entityEntries);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry me = (Map.Entry)list.get(i);
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.status;
            if (status == LOADING || status == GONE) continue;
            this.flushEntity(me.getKey(), entry);
        }
    }

    private void flushEntity(Object object, EntityEntry entry) throws HibernateException {
        boolean cannotDirtyCheck;
        boolean interceptorHandledDirtyCheck;
        ClassPersister persister = entry.persister;
        Status status = entry.status;
        SessionImpl.checkId(object, persister, entry.id);
        Object[] values = status == DELETED ? entry.deletedState : persister.getPropertyValues(object);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = false;
        if (persister.hasCollections()) {
            WrapVisitor visitor = new WrapVisitor(this);
            visitor.processValues(values, types);
            substitute = visitor.isSubstitutionRequired();
        }
        boolean dirtyCheckDoneBySelect = false;
        Object[] currentPersistentState = null;
        int[] dirtyProperties = this.interceptor.findDirty(object, entry.id, values, entry.loadedState, persister.getPropertyNames(), types);
        if (dirtyProperties == null) {
            interceptorHandledDirtyCheck = false;
            boolean bl = cannotDirtyCheck = entry.loadedState == null;
            if (!cannotDirtyCheck) {
                dirtyProperties = persister.findDirty(values, entry.loadedState, object, this);
            } else {
                currentPersistentState = persister.getCurrentPersistentState(entry.id, entry.version, this);
                if (currentPersistentState != null) {
                    dirtyProperties = persister.findModified(currentPersistentState, values, object, this);
                    cannotDirtyCheck = false;
                    dirtyCheckDoneBySelect = true;
                }
            }
        } else {
            cannotDirtyCheck = false;
            interceptorHandledDirtyCheck = true;
        }
        if (this.isUpdateNecessary(persister, cannotDirtyCheck, status, dirtyProperties, values, types)) {
            if (log.isTraceEnabled()) {
                if (status == DELETED) {
                    log.trace((Object)("Updating deleted entity: " + MessageHelper.infoString(persister, entry.id)));
                } else {
                    log.trace((Object)("Updating entity: " + MessageHelper.infoString(persister, entry.id)));
                }
            }
            if (!entry.isBeingReplicated) {
                boolean intercepted = this.interceptor.onFlushDirty(object, entry.id, values, entry.loadedState, persister.getPropertyNames(), types);
                if (intercepted && !cannotDirtyCheck && !interceptorHandledDirtyCheck) {
                    dirtyProperties = dirtyCheckDoneBySelect ? persister.findModified(currentPersistentState, values, object, this) : persister.findDirty(values, entry.loadedState, object, this);
                }
                boolean bl = substitute = substitute || intercepted;
            }
            if (status == LOADED && persister.implementsValidatable()) {
                ((Validatable)object).validate();
            }
            Object nextVersion = this.getNextVersion(persister, values, entry);
            Object[] updatedState = null;
            if (status == LOADED) {
                updatedState = new Object[values.length];
                TypeFactory.deepCopy(values, types, persister.getPropertyUpdateability(), updatedState);
            }
            if (!cannotDirtyCheck && dirtyProperties == null) {
                dirtyProperties = NO_INTS;
            }
            SessionImpl.checkNullability(values, persister, true);
            this.updates.add(new ScheduledUpdate(entry.id, values, dirtyProperties, entry.loadedState, entry.version, nextVersion, object, updatedState, persister, this));
        }
        if (status != DELETED) {
            if (substitute) {
                persister.setPropertyValues(object, values);
            }
            if (persister.hasCollections()) {
                new FlushVisitor(this, object).processValues(values, types);
            }
        }
    }

    private boolean isUpdateNecessary(ClassPersister persister, boolean cannotDirtyCheck, Status status, int[] dirtyProperties, Object[] values, Type[] types) throws HibernateException {
        if (!persister.isMutable()) {
            return false;
        }
        if (cannotDirtyCheck) {
            return true;
        }
        if (dirtyProperties != null && dirtyProperties.length != 0) {
            return true;
        }
        if (status == LOADED && persister.isVersioned() && persister.hasCollections()) {
            DirtyCollectionSearchVisitor visitor = new DirtyCollectionSearchVisitor(this);
            visitor.processValues(values, types);
            return visitor.wasDirtyCollectionFound();
        }
        return false;
    }

    private Object getNextVersion(ClassPersister persister, Object[] values, EntityEntry entry) throws HibernateException {
        if (persister.isVersioned()) {
            if (entry.isBeingReplicated) {
                return Versioning.getVersion(values, persister);
            }
            Object nextVersion = entry.status == DELETED ? entry.version : Versioning.increment(entry.version, persister.getVersionType());
            Versioning.setVersion(values, nextVersion, persister);
            return nextVersion;
        }
        return null;
    }

    private static void checkId(Object object, ClassPersister persister, Serializable id) throws HibernateException {
        if (persister.hasIdentifierPropertyOrEmbeddedCompositeIdentifier()) {
            Serializable oid = persister.getIdentifier(object);
            if (id == null) {
                throw new AssertionFailure("null id in entry (don't flush the Session after an exception occurs)");
            }
            if (!id.equals(oid)) {
                throw new HibernateException("identifier of an instance of " + persister.getClassName() + " altered from " + id + " to " + oid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preFlushEntities() throws HibernateException {
        List list = IdentityMap.concurrentEntries(this.entityEntries);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry me = (Map.Entry)list.get(i);
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.status;
            if (status == LOADING || status == GONE || status == DELETED) continue;
            Object object = me.getKey();
            ++this.cascading;
            try {
                Cascades.cascade(this, entry.persister, object, Cascades.ACTION_SAVE_UPDATE, 0);
                continue;
            }
            finally {
                --this.cascading;
            }
        }
    }

    ClassPersister getClassPersister(Class theClass) throws MappingException {
        if (this.lastClass != theClass) {
            this.lastResultForClass = this.factory.getPersister(theClass);
            this.lastClass = theClass;
        }
        return this.lastResultForClass;
    }

    public ClassPersister getPersister(Object object) throws MappingException {
        return this.getClassPersister(object.getClass());
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        if (object instanceof HibernateProxy) {
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
            if (li.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return li.getIdentifier();
        }
        EntityEntry entry = this.getEntry(object);
        if (entry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entry.id;
    }

    public Serializable getEntityIdentifier(Object object) {
        if (object instanceof HibernateProxy) {
            return HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getIdentifier();
        }
        EntityEntry entry = this.getEntry(object);
        return entry != null ? entry.id : null;
    }

    public boolean isSaved(Object object) throws HibernateException {
        if (object instanceof HibernateProxy) {
            return true;
        }
        EntityEntry entry = this.getEntry(object);
        if (entry != null) {
            return true;
        }
        Boolean isUnsaved = this.interceptor.isUnsaved(object);
        if (isUnsaved != null) {
            return isUnsaved == false;
        }
        return !this.getPersister(object).isUnsaved(object);
    }

    public Serializable getEntityIdentifierIfNotUnsaved(Object object) throws HibernateException {
        ClassPersister persister;
        if (object == null) {
            return null;
        }
        if (object instanceof HibernateProxy) {
            return HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getIdentifier();
        }
        EntityEntry entry = this.getEntry(object);
        if (entry != null) {
            return entry.id;
        }
        Boolean isUnsaved = this.interceptor.isUnsaved(object);
        if (isUnsaved != null && isUnsaved.booleanValue()) {
            SessionImpl.throwTransientObjectException(object);
        }
        if ((persister = this.getPersister(object)).isUnsaved(object)) {
            SessionImpl.throwTransientObjectException(object);
        }
        return persister.getIdentifier(object);
    }

    private static void throwTransientObjectException(Object object) throws TransientObjectException {
        throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + object.getClass().getName());
    }

    private void flushCollections() throws HibernateException {
        Map.Entry me;
        int i;
        log.trace((Object)"Processing unreferenced collections");
        List list = IdentityMap.entries(this.collectionEntries);
        int size = list.size();
        for (i = 0; i < size; ++i) {
            me = (Map.Entry)list.get(i);
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.reached || ce.ignore) continue;
            this.updateUnreachableCollection((PersistentCollection)me.getKey());
        }
        log.trace((Object)"Scheduling collection removes/(re)creates/updates");
        list = IdentityMap.entries(this.collectionEntries);
        size = list.size();
        for (i = 0; i < size; ++i) {
            me = (Map.Entry)list.get(i);
            PersistentCollection coll = (PersistentCollection)me.getKey();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.dorecreate) {
                this.collectionCreations.add(new ScheduledCollectionRecreate(coll, ce.currentPersister, ce.currentKey, this));
            }
            if (ce.doremove) {
                this.collectionRemovals.add(new ScheduledCollectionRemove(ce.loadedPersister, ce.loadedKey, ce.snapshotIsEmpty(), this));
            }
            if (!ce.doupdate) continue;
            this.collectionUpdates.add(new ScheduledCollectionUpdate(coll, ce.loadedPersister, ce.loadedKey, ce.snapshotIsEmpty(), this));
        }
    }

    private void postFlush() throws HibernateException {
        log.trace((Object)"post flush");
        this.collectionsByKey.clear();
        Iterator iter = this.collectionEntries.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            PersistentCollection pc = (PersistentCollection)me.getKey();
            if (ce.reached) {
                this.collectionsByKey.put(new CollectionKey(ce.currentPersister.getRole(), ce.currentKey), pc);
            }
            ce.postFlush(pc);
        }
        this.interceptor.postFlush(this.entitiesByKey.values().iterator());
    }

    private void preFlushCollections() throws HibernateException {
        List list = IdentityMap.entries(this.collectionEntries);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map.Entry e = (Map.Entry)list.get(i);
            ((CollectionEntry)e.getValue()).preFlush((PersistentCollection)e.getKey());
        }
    }

    void updateReachableCollection(PersistentCollection coll, Type type, Object owner) throws HibernateException {
        CollectionPersister persister;
        CollectionEntry ce = this.getCollectionEntry(coll);
        if (ce == null) {
            throw new HibernateException("Found two representations of same collection");
        }
        if (ce.reached) {
            throw new HibernateException("Found shared references to a collection");
        }
        ce.reached = true;
        ce.currentPersister = persister = this.getCollectionPersister(((PersistentCollectionType)type).getRole());
        ce.currentKey = this.getEntityIdentifier(owner);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Collection found: " + MessageHelper.infoString(persister, ce.currentKey) + ", was: " + MessageHelper.infoString(ce.loadedPersister, ce.loadedKey)));
        }
        this.prepareCollectionForUpdate(coll, ce);
    }

    private void updateUnreachableCollection(PersistentCollection coll) throws HibernateException {
        CollectionEntry entry = this.getCollectionEntry(coll);
        if (log.isDebugEnabled() && entry.loadedPersister != null) {
            log.debug((Object)("Collection dereferenced: " + MessageHelper.infoString(entry.loadedPersister, entry.loadedKey)));
        }
        if (entry.loadedPersister != null && entry.loadedPersister.hasOrphanDelete()) {
            Key key = new Key(entry.loadedKey, this.getClassPersister(entry.loadedPersister.getOwnerClass()));
            Object owner = this.getEntity(key);
            if (owner == null) {
                throw new AssertionFailure("owner not associated with session");
            }
            EntityEntry e = this.getEntry(owner);
            if (e != null && e.status != DELETED && e.status != GONE) {
                throw new HibernateException("You may not dereference a collection with cascade=\"all-delete-orphan\"");
            }
        }
        entry.currentPersister = null;
        entry.currentKey = null;
        this.prepareCollectionForUpdate(coll, entry);
    }

    private void prepareCollectionForUpdate(PersistentCollection coll, CollectionEntry entry) throws HibernateException {
        if (entry.processed) {
            throw new AssertionFailure("Hibernate has a bug processing collections");
        }
        entry.processed = true;
        if (entry.loadedPersister != null || entry.currentPersister != null) {
            if (entry.loadedPersister != entry.currentPersister || !entry.currentPersister.getKeyType().equals(entry.loadedKey, entry.currentKey)) {
                if (entry.loadedPersister != null && entry.currentPersister != null && entry.loadedPersister.hasOrphanDelete()) {
                    throw new HibernateException("You may not change the reference to a collection with cascade=\"all-delete-orphan\"");
                }
                if (entry.currentPersister != null) {
                    entry.dorecreate = true;
                }
                if (entry.loadedPersister != null) {
                    entry.doremove = true;
                    if (entry.dorecreate) {
                        log.trace((Object)"Forcing collection initialization");
                        coll.forceInitialization();
                    }
                }
            } else if (entry.dirty) {
                entry.doupdate = true;
            }
        }
    }

    boolean collectionIsDirty(PersistentCollection coll) throws HibernateException {
        CollectionEntry entry = this.getCollectionEntry(coll);
        return entry.initialized && entry.dirty;
    }

    private LoadingCollectionEntry getLoadingCollectionEntry(CollectionKey collectionKey) {
        return (LoadingCollectionEntry)this.loadingCollections.get(collectionKey);
    }

    private void addLoadingCollectionEntry(CollectionKey collectionKey, PersistentCollection collection, Serializable id, Object resultSetId) {
        this.loadingCollections.put(collectionKey, new LoadingCollectionEntry(collection, id, resultSetId));
    }

    public PersistentCollection getLoadingCollection(CollectionPersister persister, Serializable id, Object resultSetId) throws HibernateException {
        CollectionKey ckey = new CollectionKey(persister, id);
        LoadingCollectionEntry lce = this.getLoadingCollectionEntry(ckey);
        if (lce == null) {
            PersistentCollection pc = this.getCollection(ckey);
            if (pc != null) {
                CollectionEntry ce = this.getCollectionEntry(pc);
                if (ce.initialized) {
                    log.trace((Object)"collection already initialized: ignoring");
                    return null;
                }
                log.trace((Object)"uninitialized collection: initializing");
            } else {
                Object entity = this.getCollectionOwner(id, persister);
                if (entity != null && this.getEntry((Object)entity).status != LOADING) {
                    log.trace((Object)"owning entity already loaded: ignoring");
                    return null;
                }
                log.trace((Object)"new collection: instantiating");
                pc = persister.getCollectionType().instantiate(this, persister);
            }
            pc.beforeInitialize(persister);
            pc.beginRead();
            this.addLoadingCollectionEntry(ckey, pc, id, resultSetId);
            return pc;
        }
        if (lce.resultSetId == resultSetId) {
            log.trace((Object)"reading row");
            return lce.collection;
        }
        log.trace((Object)"collection is already being initialized: ignoring row");
        return null;
    }

    public void endLoadingCollections(CollectionPersister persister, Object resultSetId) throws HibernateException {
        ArrayList<LoadingCollectionEntry> resultSetCollections = null;
        Iterator iter = this.loadingCollections.values().iterator();
        while (iter.hasNext()) {
            LoadingCollectionEntry lce = (LoadingCollectionEntry)iter.next();
            if (lce.resultSetId != resultSetId) continue;
            if (resultSetCollections == null) {
                resultSetCollections = new ArrayList<LoadingCollectionEntry>();
            }
            resultSetCollections.add(lce);
            iter.remove();
        }
        this.endLoadingCollections(persister, resultSetCollections);
    }

    private void endLoadingCollections(CollectionPersister persister, List resultSetCollections) throws HibernateException {
        int count;
        int n = count = resultSetCollections == null ? 0 : resultSetCollections.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " collections were found in result set"));
        }
        for (int i = 0; i < count; ++i) {
            LoadingCollectionEntry lce = (LoadingCollectionEntry)resultSetCollections.get(i);
            boolean addToCache = lce.collection.endRead();
            CollectionEntry ce = this.getCollectionEntry(lce.collection);
            if (ce == null) {
                this.addInitializedCollection(lce.collection, persister, lce.id);
            } else {
                ce.postInitialize(lce.collection);
            }
            if (persister.hasCache() && addToCache) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Caching collection: " + MessageHelper.infoString(persister, lce.id)));
                }
                persister.getCache().put(lce.id, lce.collection.disassemble(persister), this.getTimestamp());
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("collection fully initialized: " + MessageHelper.infoString(persister, lce.id)));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(count + " collections initialized"));
        }
    }

    private PersistentCollection getLoadingCollection(String role, Serializable id) {
        LoadingCollectionEntry lce = this.getLoadingCollectionEntry(new CollectionKey(role, id));
        return lce != null ? lce.collection : null;
    }

    public void beforeLoad() {
        ++this.loadCounter;
    }

    public void afterLoad() {
        --this.loadCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeNonLazyCollections() throws HibernateException {
        if (this.loadCounter == 0) {
            log.debug((Object)"initializing non-lazy collections");
            ++this.loadCounter;
            try {
                int size;
                while ((size = this.nonlazyCollections.size()) > 0) {
                    ((PersistentCollection)this.nonlazyCollections.remove(size - 1)).forceInitialization();
                }
            }
            finally {
                --this.loadCounter;
            }
        }
    }

    private void addCollection(PersistentCollection coll, CollectionEntry entry, Serializable key) {
        this.collectionEntries.put(coll, entry);
        PersistentCollection old = this.collectionsByKey.put(new CollectionKey(entry.loadedPersister, key), coll);
        if (old != null) {
            if (old == coll) {
                throw new AssertionFailure("bug adding collection twice");
            }
            old.unsetSession(this);
            this.collectionEntries.remove(old);
        }
    }

    private PersistentCollection getCollection(CollectionKey collectionKey) {
        return (PersistentCollection)this.collectionsByKey.get(collectionKey);
    }

    private void addUninitializedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) {
        CollectionEntry ce = new CollectionEntry(persister, id, this.flushing);
        collection.setCollectionSnapshot(ce);
        this.addCollection(collection, ce, id);
    }

    private void addUninitializedDetachedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) {
        CollectionEntry ce = new CollectionEntry(persister, id);
        collection.setCollectionSnapshot(ce);
        this.addCollection(collection, ce, id);
    }

    private void addInitializedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) throws HibernateException {
        CollectionEntry ce = new CollectionEntry(persister, id, this.flushing);
        ce.postInitialize(collection);
        collection.setCollectionSnapshot(ce);
        this.addCollection(collection, ce, id);
    }

    CollectionEntry addCollection(PersistentCollection collection) throws HibernateException {
        CollectionEntry ce = new CollectionEntry();
        this.collectionEntries.put(collection, ce);
        collection.setCollectionSnapshot(ce);
        return ce;
    }

    void addNewCollection(PersistentCollection collection, CollectionPersister persister) throws HibernateException {
        CollectionEntry ce = this.addCollection(collection);
        if (persister.hasOrphanDelete()) {
            ce.initSnapshot(collection, persister);
        }
    }

    private void addInitializedDetachedCollection(PersistentCollection collection, CollectionSnapshot cs) throws HibernateException {
        if (cs.wasDereferenced()) {
            this.addCollection(collection);
        } else {
            CollectionEntry ce = new CollectionEntry(cs, this.factory);
            collection.setCollectionSnapshot(ce);
            this.addCollection(collection, ce, cs.getKey());
        }
    }

    public ArrayHolder getArrayHolder(Object array) {
        return (ArrayHolder)this.arrayHolders.get(array);
    }

    public void addArrayHolder(ArrayHolder holder) {
        this.arrayHolders.put(holder.getArray(), holder);
    }

    CollectionPersister getCollectionPersister(String role) throws MappingException {
        return this.factory.getCollectionPersister(role);
    }

    public Serializable getSnapshot(PersistentCollection coll) {
        return this.getCollectionEntry((PersistentCollection)coll).snapshot;
    }

    public Serializable getLoadedCollectionKey(PersistentCollection coll) {
        return this.getCollectionEntry((PersistentCollection)coll).loadedKey;
    }

    public boolean isInverseCollection(PersistentCollection collection) {
        CollectionEntry ce = this.getCollectionEntry(collection);
        return ce != null && ce.loadedPersister.isInverse();
    }

    public Collection getOrphans(PersistentCollection coll) throws HibernateException {
        CollectionEntry ce = this.getCollectionEntry(coll);
        return ce == null || ce.isNew() ? EMPTY : coll.getOrphans(ce.getSnapshot());
    }

    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        CollectionEntry ce = this.getCollectionEntry(collection);
        if (!ce.initialized) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("initializing collection " + MessageHelper.infoString(ce.loadedPersister, ce.loadedKey)));
            }
            log.trace((Object)"checking second-level cache");
            boolean foundInCache = this.initializeCollectionFromCache(ce.loadedKey, this.getCollectionOwner(ce), ce.loadedPersister, collection);
            if (foundInCache) {
                log.trace((Object)"collection initialized from cache");
            } else {
                log.trace((Object)"collection not cached");
                ce.loadedPersister.initialize(ce.loadedKey, this);
                log.trace((Object)"collection initialized");
            }
        }
    }

    private Object getCollectionOwner(CollectionEntry ce) throws MappingException {
        return this.getCollectionOwner(ce.loadedKey, ce.loadedPersister);
    }

    public Object getCollectionOwner(Serializable key, CollectionPersister collectionPersister) throws MappingException {
        return this.getEntity(new Key(key, this.factory.getPersister(collectionPersister.getOwnerClass())));
    }

    public Connection connection() throws HibernateException {
        if (this.connection == null) {
            if (this.connect) {
                this.connect();
            } else {
                if (this.isOpen()) {
                    throw new HibernateException("Session is currently disconnected");
                }
                throw new HibernateException("Session is closed");
            }
        }
        return this.connection;
    }

    private boolean isJTATransactionActive(javax.transaction.Transaction tx) throws SystemException {
        return tx != null && (tx.getStatus() == 0 || tx.getStatus() == 1);
    }

    private void connect() throws HibernateException {
        TransactionManager tm;
        this.connection = this.batcher.openConnection();
        this.connect = false;
        if (!this.isCurrentTransaction && (tm = this.factory.getTransactionManager()) != null) {
            try {
                javax.transaction.Transaction tx = tm.getTransaction();
                if (this.isJTATransactionActive(tx)) {
                    tx.registerSynchronization((Synchronization)new CacheSynchronization(this));
                    this.isCurrentTransaction = true;
                }
            }
            catch (Exception e) {
                throw new TransactionException("could not register synchronization with JTA TransactionManager", e);
            }
        }
    }

    public boolean isConnected() {
        return this.connection != null || this.connect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection disconnect() throws HibernateException {
        log.debug((Object)"disconnecting session");
        try {
            if (this.connect) {
                this.connect = false;
                Connection connection = null;
                return connection;
            }
            if (this.connection == null) {
                throw new HibernateException("Session already disconnected");
            }
            this.batcher.closeStatements();
            Connection c = this.connection;
            this.connection = null;
            if (this.autoClose) {
                this.batcher.closeConnection(c);
                Connection connection = null;
                return connection;
            }
            Connection connection = c;
            return connection;
        }
        finally {
            if (!this.isCurrentTransaction) {
                this.afterTransactionCompletion(false);
            }
        }
    }

    public void reconnect() throws HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Session already connected");
        }
        log.debug((Object)"reconnecting session");
        this.connect = true;
    }

    public void reconnect(Connection conn) throws HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Session already connected");
        }
        this.connection = conn;
    }

    protected void finalize() throws Throwable {
        log.debug((Object)"running Session.finalize()");
        if (this.isCurrentTransaction) {
            log.warn((Object)"afterTransactionCompletion() was never called");
        }
        if (this.connection != null) {
            if (this.connection.isClosed()) {
                log.warn((Object)"finalizing unclosed session with closed connection");
            } else {
                log.warn((Object)"unclosed connection");
                if (this.autoClose) {
                    this.connection.close();
                }
            }
        }
    }

    public Collection filter(Object collection, String filter) throws HibernateException {
        return this.filter(collection, filter, new QueryParameters(new Type[1], new Object[1]));
    }

    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        return this.filter(collection, filter, new QueryParameters(new Type[]{null, type}, new Object[]{null, value}));
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        Object[] vals = new Object[values.length + 1];
        Type[] typs = new Type[types.length + 1];
        System.arraycopy(values, 0, vals, 1, values.length);
        System.arraycopy(types, 0, typs, 1, types.length);
        return this.filter(collection, filter, new QueryParameters(typs, vals));
    }

    private FilterTranslator getFilterTranslator(Object collection, String filter, QueryParameters parameters, boolean scalar) throws HibernateException {
        FilterTranslator filterTranslator;
        CollectionEntry entry;
        CollectionPersister roleBeforeFlush;
        if (collection == null) {
            throw new NullPointerException("null collection passed to filter");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("filter: " + filter));
            parameters.traceParameters(this.factory);
        }
        CollectionPersister collectionPersister = roleBeforeFlush = (entry = this.getCollectionEntryOrNull(collection)) == null ? null : entry.loadedPersister;
        if (roleBeforeFlush == null) {
            CollectionPersister roleAfterFlush;
            this.flush();
            entry = this.getCollectionEntryOrNull(collection);
            CollectionPersister collectionPersister2 = roleAfterFlush = entry == null ? null : entry.loadedPersister;
            if (roleAfterFlush == null) {
                throw new QueryException("The collection was unreferenced");
            }
            filterTranslator = this.factory.getFilter(filter, roleAfterFlush.getRole(), scalar);
        } else {
            filterTranslator = this.factory.getFilter(filter, roleBeforeFlush.getRole(), scalar);
            if (this.autoFlushIfRequired(filterTranslator.getQuerySpaces())) {
                CollectionPersister roleAfterFlush;
                entry = this.getCollectionEntryOrNull(collection);
                CollectionPersister collectionPersister3 = roleAfterFlush = entry == null ? null : entry.loadedPersister;
                if (roleBeforeFlush != roleAfterFlush) {
                    if (roleAfterFlush == null) {
                        throw new QueryException("The collection was dereferenced");
                    }
                    filterTranslator = this.factory.getFilter(filter, roleAfterFlush.getRole(), scalar);
                }
            }
        }
        parameters.getPositionalParameterValues()[0] = entry.loadedKey;
        parameters.getPositionalParameterTypes()[0] = entry.loadedPersister.getKeyType();
        return filterTranslator;
    }

    private CollectionEntry getCollectionEntryOrNull(Object collection) {
        PersistentCollection coll;
        if (collection instanceof PersistentCollection) {
            coll = (PersistentCollection)collection;
        } else {
            coll = this.getArrayHolder(collection);
            if (coll == null) {
                Iterator wrappers = IdentityMap.keyIterator(this.collectionEntries);
                while (wrappers.hasNext()) {
                    PersistentCollection pc = (PersistentCollection)wrappers.next();
                    if (!pc.isWrapper(collection)) continue;
                    coll = pc;
                    break;
                }
            }
        }
        return coll == null ? null : this.getCollectionEntry(coll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List filter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        String[] concreteFilters = QueryTranslator.concreteQueries(filter, this.factory);
        FilterTranslator[] filters = new FilterTranslator[concreteFilters.length];
        for (int i = 0; i < concreteFilters.length; ++i) {
            filters[i] = this.getFilterTranslator(collection, concreteFilters[i], queryParameters, false);
        }
        ++this.dontFlushFromFind;
        List results = Collections.EMPTY_LIST;
        try {
            for (int i = 0; i < concreteFilters.length; ++i) {
                List currentResults;
                try {
                    currentResults = filters[i].list(this, queryParameters);
                }
                catch (SQLException sqle) {
                    throw new JDBCException("Could not execute query", sqle);
                }
                currentResults.addAll(results);
                results = currentResults;
            }
        }
        finally {
            --this.dontFlushFromFind;
        }
        return results;
    }

    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        boolean many;
        String[] concreteFilters = QueryTranslator.concreteQueries(filter, this.factory);
        FilterTranslator[] filters = new FilterTranslator[concreteFilters.length];
        for (int i = 0; i < concreteFilters.length; ++i) {
            filters[i] = this.getFilterTranslator(collection, concreteFilters[i], queryParameters, true);
        }
        if (filters.length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        Iterator result = null;
        Iterator[] results = null;
        boolean bl = many = filters.length > 1;
        if (many) {
            results = new Iterator[filters.length];
        }
        for (int i = 0; i < filters.length; ++i) {
            try {
                result = filters[i].iterate(queryParameters, this);
            }
            catch (SQLException sqle) {
                throw new JDBCException("Could not execute query", sqle);
            }
            if (!many) continue;
            results[i] = result;
        }
        return many ? new JoinedIterator(results) : result;
    }

    public Criteria createCriteria(Class persistentClass) {
        return new CriteriaImpl(persistentClass, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List find(CriteriaImpl criteria) throws HibernateException {
        String[] implementors = this.factory.getImplementors(criteria.getCriteriaClass());
        int size = implementors.length;
        CriteriaLoader[] loaders = new CriteriaLoader[size];
        HashSet spaces = new HashSet();
        for (int i = 0; i < size; ++i) {
            Class newCriteriaClazz;
            try {
                newCriteriaClazz = ReflectHelper.classForName(implementors[i]);
            }
            catch (ClassNotFoundException cnfe) {
                throw new HibernateException("class not found", cnfe);
            }
            loaders[i] = new CriteriaLoader(this.getOuterJoinLoadable(newCriteriaClazz), this.factory, new CriteriaImpl(newCriteriaClazz, criteria));
            spaces.addAll(loaders[i].getQuerySpaces());
        }
        this.autoFlushIfRequired(spaces);
        List results = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        try {
            for (int i = 0; i < size; ++i) {
                List currentResults;
                try {
                    currentResults = loaders[i].list(this);
                }
                catch (SQLException sqle) {
                    throw new JDBCException(sqle);
                }
                currentResults.addAll(results);
                results = currentResults;
            }
        }
        finally {
            --this.dontFlushFromFind;
        }
        return results;
    }

    private OuterJoinLoadable getOuterJoinLoadable(Class clazz) throws MappingException {
        ClassPersister persister = this.getClassPersister(clazz);
        if (!(persister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + clazz.getName());
        }
        return (OuterJoinLoadable)persister;
    }

    public boolean contains(Object object) {
        if (object instanceof HibernateProxy) {
            return HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getSession() == this;
        }
        return this.entityEntries.containsKey(object);
    }

    public void evict(Object object) throws HibernateException {
        if (object instanceof HibernateProxy) {
            Object entity;
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
            Serializable id = li.getIdentifier();
            ClassPersister persister = this.getClassPersister(li.getPersistentClass());
            Key key = new Key(id, persister);
            this.proxiesByKey.remove(key);
            if (!li.isUninitialized() && (entity = this.removeEntity(key)) != null) {
                this.removeEntry(entity);
                this.doEvict(persister, entity);
            }
        } else {
            EntityEntry e = this.removeEntry(object);
            if (e != null) {
                this.removeEntity(new Key(e.id, e.persister));
                this.doEvict(e.persister, object);
            }
        }
    }

    private void doEvict(ClassPersister persister, Object object) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("evicting " + MessageHelper.infoString(persister)));
        }
        if (persister.hasCollections()) {
            new EvictVisitor(this).process(object, persister);
        }
        Cascades.cascade(this, persister, object, Cascades.ACTION_EVICT, 0);
    }

    /*
     * WARNING - void declaration
     */
    void evictCollection(Object value, PersistentCollectionType type) {
        void var3_3;
        Object pc;
        if (type.isArrayType()) {
            pc = this.arrayHolders.remove(value);
        } else if (value instanceof PersistentCollection) {
            pc = value;
        } else {
            return;
        }
        PersistentCollection collection = (PersistentCollection)var3_3;
        if (collection.unsetSession(this)) {
            this.evictCollection(collection);
        }
    }

    private void evictCollection(PersistentCollection collection) {
        CollectionEntry ce = (CollectionEntry)this.collectionEntries.remove(collection);
        if (log.isDebugEnabled()) {
            log.debug((Object)("evicting collection: " + MessageHelper.infoString(ce.loadedPersister, ce.loadedKey)));
        }
        if (ce.loadedPersister != null && ce.loadedKey != null) {
            this.collectionsByKey.remove(new CollectionKey(ce.loadedPersister.getRole(), ce.loadedKey));
        }
    }

    private void evictCachedCollections(ClassPersister persister, Serializable id) throws HibernateException {
        this.evictCachedCollections(persister.getPropertyTypes(), id);
    }

    private void evictCachedCollections(Type[] types, Serializable id) throws HibernateException {
        for (int i = 0; i < types.length; ++i) {
            if (types[i].isPersistentCollectionType()) {
                this.factory.evictCollection(((PersistentCollectionType)types[i]).getRole(), id);
                continue;
            }
            if (!types[i].isComponentType()) continue;
            AbstractComponentType actype = (AbstractComponentType)types[i];
            this.evictCachedCollections(actype.getSubtypes(), id);
        }
    }

    public Object getVersion(Object entity) {
        return this.getEntry((Object)entity).version;
    }

    public Serializable[] getCollectionBatch(CollectionPersister collectionPersister, Serializable id, int batchSize) {
        Serializable[] keys = new Serializable[batchSize];
        keys[0] = id;
        int i = 0;
        Iterator iter = this.collectionEntries.values().iterator();
        while (iter.hasNext()) {
            CollectionEntry ce = (CollectionEntry)iter.next();
            if (ce.initialized || ce.loadedPersister != collectionPersister || id.equals(ce.loadedKey)) continue;
            keys[++i] = ce.loadedKey;
            if (i != batchSize - 1) continue;
            return keys;
        }
        return keys;
    }

    public Serializable[] getClassBatch(Class clazz, Serializable id, int batchSize) {
        Serializable[] ids = new Serializable[batchSize];
        ids[0] = id;
        int i = 0;
        Iterator iter = this.batchLoadableEntityKeys.keySet().iterator();
        while (iter.hasNext()) {
            Key key = (Key)iter.next();
            if (key.getMappedClass() != clazz || id.equals(key.getIdentifier())) continue;
            ids[++i] = key.getIdentifier();
            if (i != batchSize - 1) continue;
            return ids;
        }
        return ids;
    }

    public void scheduleBatchLoad(Class clazz, Serializable id) throws MappingException {
        ClassPersister persister = this.getClassPersister(clazz);
        if (persister.isBatchLoadable()) {
            this.batchLoadableEntityKeys.put(new Key(id, persister), MARKER);
        }
    }

    public Query createSQLQuery(String sql, String returnAlias, Class returnClass) {
        return new SQLQueryImpl(sql, new String[]{returnAlias}, new Class[]{returnClass}, this, null);
    }

    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses) {
        return new SQLQueryImpl(sql, returnAliases, returnClasses, this, null);
    }

    public Query createSQLQuery(String sql, String[] returnAliases, Class[] returnClasses, Collection querySpaces) {
        return new SQLQueryImpl(sql, returnAliases, returnClasses, this, querySpaces);
    }

    public List findBySQL(String sqlQuery, String[] aliases, Class[] classes, QueryParameters queryParameters, Collection querySpaces) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("SQL query: " + sqlQuery));
        }
        SQLLoadable[] persisters = new SQLLoadable[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            persisters[i] = this.getSQLLoadable(classes[i]);
        }
        SQLLoader loader = new SQLLoader(aliases, persisters, this.factory, sqlQuery, querySpaces);
        this.autoFlushIfRequired(loader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            List list = loader.list(this, queryParameters);
            return list;
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    private SQLLoadable getSQLLoadable(Class clazz) throws MappingException {
        ClassPersister cp = this.getClassPersister(clazz);
        if (!(cp instanceof SQLLoadable)) {
            throw new MappingException("class persister is not SQLLoadable: " + clazz.getName());
        }
        return (SQLLoadable)cp;
    }

    public void clear() {
        this.arrayHolders.clear();
        this.entitiesByKey.clear();
        this.entityEntries.clear();
        this.collectionsByKey.clear();
        this.collectionEntries.clear();
        this.proxiesByKey.clear();
        this.batchLoadableEntityKeys.clear();
        this.updates.clear();
        this.insertions.clear();
        this.deletions.clear();
        this.collectionCreations.clear();
        this.collectionRemovals.clear();
        this.collectionUpdates.clear();
    }

    public Object loadByUniqueKey(Class clazz, String uniqueKeyPropertyName, Serializable id) throws HibernateException {
        UniqueKeyLoadable persister = (UniqueKeyLoadable)this.getFactory().getPersister(clazz);
        try {
            Object result = persister.loadByUniqueKey(uniqueKeyPropertyName, id, this);
            return result == null ? null : this.proxyFor(result);
        }
        catch (SQLException sqle) {
            throw new JDBCException(sqle);
        }
    }

    public void replicate(Object obj, ReplicationMode replicationMode) throws HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to replicate null");
        }
        if (this.reassociateIfUninitializedProxy(obj)) {
            return;
        }
        Object object = this.unproxyAndReassociate(obj);
        if (this.isEntryFor(object)) {
            return;
        }
        ClassPersister persister = this.getPersister(object);
        if (persister.isUnsaved(object)) {
            throw new TransientObjectException("unsaved object passed to replicate()");
        }
        Serializable id = persister.getIdentifier(object);
        Object oldVersion = replicationMode == ReplicationMode.EXCEPTION ? null : persister.getCurrentVersion(id, this);
        if (oldVersion != null) {
            if (replicationMode.shouldOverwriteCurrentVersion(object, oldVersion, persister.getVersion(object), persister.getVersionType())) {
                this.doReplicate(object, id, oldVersion, replicationMode, persister);
            }
        } else {
            boolean regenerate;
            if (log.isTraceEnabled()) {
                log.trace((Object)("replicating " + MessageHelper.infoString(persister, id)));
            }
            this.doSave(object, (regenerate = persister.isIdentifierAssignedByInsert()) ? null : new Key(id, persister), persister, true, regenerate, Cascades.ACTION_REPLICATE, replicationMode);
        }
    }

    public SessionFactory getSessionFactory() {
        return this.factory;
    }

    public Object getCollection(String role, Serializable id, Object owner) throws HibernateException {
        CollectionPersister persister = this.factory.getCollectionPersister(role);
        PersistentCollection collection = this.getLoadingCollection(role, id);
        if (collection != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("returning loading collection:" + MessageHelper.infoString(persister, id)));
            }
            return collection.getValue();
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("creating collection wrapper:" + MessageHelper.infoString(persister, id)));
        }
        collection = persister.getCollectionType().instantiate(this, persister);
        this.addUninitializedCollection(collection, persister, id);
        if (persister.isArray()) {
            this.initializeCollection(collection, false);
            this.addArrayHolder((ArrayHolder)collection);
        } else if (!persister.isLazy()) {
            this.nonlazyCollections.add(collection);
        }
        return collection.getValue();
    }

    private boolean initializeCollectionFromCache(Serializable id, Object owner, CollectionPersister persister, PersistentCollection collection) throws HibernateException {
        if (!persister.hasCache()) {
            return false;
        }
        Serializable cached = (Serializable)persister.getCache().get(id, this.getTimestamp());
        if (cached == null) {
            return false;
        }
        collection.initializeFromCache(persister, cached, owner);
        this.getCollectionEntry(collection).postInitialize(collection);
        return true;
    }

    public void cancelQuery() throws HibernateException {
        this.getBatcher().cancelLastQuery();
    }

    public void addNonExist(Key key) {
        this.nonExists.add(key);
    }

    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        return this.doCopy(object, null, IdentityMap.instantiate(10));
    }

    public Object copy(Object object, Map copiedAlready) throws HibernateException {
        return this.doCopy(object, null, copiedAlready);
    }

    public Object doCopy(Object object, Serializable id, Map copiedAlready) throws HibernateException {
        Object result;
        if (object == null) {
            return null;
        }
        if (object instanceof HibernateProxy) {
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
            if (li.isUninitialized()) {
                return this.load(li.getPersistentClass(), li.getIdentifier());
            }
            object = li.getImplementation();
        }
        if (copiedAlready.containsKey(object)) {
            return object;
        }
        EntityEntry entry = this.getEntry(object);
        if (entry != null && id != null && entry.id.equals(id)) {
            return object;
        }
        copiedAlready.put(object, object);
        Class<?> clazz = object.getClass();
        ClassPersister persister = this.getClassPersister(clazz);
        if (id == null && persister.isUnsaved(object)) {
            this.saveWithGeneratedIdentifier(object, Cascades.ACTION_COPY, copiedAlready);
            return object;
        }
        if (id == null) {
            id = persister.getIdentifier(object);
        }
        if ((result = this.get(clazz, id)) == null) {
            this.saveWithGeneratedIdentifier(object, Cascades.ACTION_COPY, copiedAlready);
            return object;
        }
        Object target = this.unproxy(result);
        if (target == object) {
            return result;
        }
        if (Hibernate.getClass(result) != clazz) {
            throw new WrongClassException("class of the given object did not match class of persistent copy", id, clazz);
        }
        if (persister.isVersioned() && !persister.getVersionType().equals(persister.getVersion(result), persister.getVersion(object))) {
            throw new StaleObjectStateException(clazz, id);
        }
        Cascades.cascade(this, persister, object, Cascades.ACTION_COPY, 0, copiedAlready);
        Object[] copiedValues = TypeFactory.copy(persister.getPropertyValues(object), persister.getPropertyValues(target), persister.getPropertyTypes(), this, target);
        persister.setPropertyValues(target, copiedValues);
        return result;
    }

    public Object saveOrUpdateCopy(Object object, Serializable id) throws HibernateException {
        return this.doCopy(object, id, IdentityMap.instantiate(10));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class LoadingCollectionEntry {
        final PersistentCollection collection;
        final Serializable id;
        final Object resultSetId;

        LoadingCollectionEntry(PersistentCollection collection, Serializable id, Object resultSetId) {
            this.collection = collection;
            this.id = id;
            this.resultSetId = resultSetId;
        }
    }

    static final class CollectionKey
    implements Serializable {
        private String role;
        private Serializable key;

        CollectionKey(String role, Serializable key) {
            this.role = role;
            this.key = key;
        }

        CollectionKey(CollectionPersister persister, Serializable key) {
            this.role = persister.getRole();
            this.key = key;
        }

        public boolean equals(Object other) {
            CollectionKey that = (CollectionKey)other;
            return that.role.equals(this.role) && that.key.equals(this.key);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.role.hashCode();
            result = 37 * result + this.key.hashCode();
            return result;
        }
    }

    public static final class CollectionEntry
    implements CollectionSnapshot,
    Serializable {
        boolean dirty;
        transient boolean reached;
        transient boolean processed;
        transient boolean doupdate;
        transient boolean doremove;
        transient boolean dorecreate;
        transient boolean ignore;
        boolean initialized;
        transient CollectionPersister currentPersister;
        transient Serializable currentKey;
        transient CollectionPersister loadedPersister;
        Serializable loadedKey;
        Serializable snapshot;
        private String role;

        CollectionEntry() {
            this.dirty = false;
            this.initialized = true;
            this.ignore = false;
        }

        CollectionEntry(CollectionPersister loadedPersister, Serializable loadedID) {
            this(loadedPersister, loadedID, false);
        }

        CollectionEntry(CollectionPersister loadedPersister, Serializable loadedID, boolean ignore) {
            this.dirty = false;
            this.initialized = false;
            this.loadedKey = loadedID;
            this.setLoadedPersister(loadedPersister);
            this.ignore = ignore;
        }

        CollectionEntry(CollectionSnapshot cs, SessionFactoryImplementor factory) throws MappingException {
            this.dirty = cs.getDirty();
            this.snapshot = cs.getSnapshot();
            this.loadedKey = cs.getKey();
            this.initialized = true;
            this.ignore = false;
            this.setLoadedPersister(factory.getCollectionPersister(cs.getRole()));
        }

        private boolean isDirty(PersistentCollection coll) throws HibernateException {
            if (this.dirty || !coll.isDirectlyAccessible() && !this.loadedPersister.getElementType().isMutable()) {
                return this.dirty;
            }
            return !coll.equalsSnapshot(this.loadedPersister.getElementType());
        }

        void preFlush(PersistentCollection collection) throws HibernateException {
            boolean bl = this.dirty = this.initialized && this.loadedPersister != null && this.isDirty(collection) || !this.initialized && this.dirty;
            if (log.isDebugEnabled() && this.dirty && this.loadedPersister != null) {
                log.debug((Object)("Collection dirty: " + MessageHelper.infoString(this.loadedPersister, this.loadedKey)));
            }
            this.doupdate = false;
            this.doremove = false;
            this.dorecreate = false;
            this.reached = false;
            this.processed = false;
        }

        void postInitialize(PersistentCollection collection) throws HibernateException {
            this.initialized = true;
            this.snapshot = collection.getSnapshot(this.loadedPersister);
        }

        void postFlush(PersistentCollection collection) throws HibernateException {
            if (this.ignore) {
                this.ignore = false;
            } else {
                if (!this.processed) {
                    throw new AssertionFailure("Hibernate has a bug processing collections");
                }
                this.loadedKey = this.currentKey;
                this.setLoadedPersister(this.currentPersister);
                this.dirty = false;
                collection.postFlush();
                if (this.initialized && (this.doremove || this.dorecreate || this.doupdate)) {
                    this.initSnapshot(collection, this.loadedPersister);
                }
            }
        }

        public void initSnapshot(PersistentCollection collection, CollectionPersister persister) throws HibernateException {
            this.snapshot = collection.getSnapshot(persister);
        }

        public boolean getDirty() {
            return this.dirty;
        }

        public Serializable getKey() {
            return this.loadedKey;
        }

        public String getRole() {
            return this.role;
        }

        public Serializable getSnapshot() {
            return this.snapshot;
        }

        public boolean snapshotIsEmpty() {
            return this.initialized && this.snapshot != null && (this.snapshot instanceof Collection && ((Collection)((Object)this.snapshot)).size() == 0 || this.snapshot instanceof Map && ((Map)((Object)this.snapshot)).size() == 0 || this.snapshot.getClass().isArray() && Array.getLength(this.snapshot) == 0);
        }

        public void setDirty() {
            this.dirty = true;
        }

        void setLoadedPersister(CollectionPersister persister) {
            this.loadedPersister = persister;
            this.role = persister == null ? null : persister.getRole();
        }

        public boolean isNew() {
            return this.initialized && this.snapshot == null;
        }

        public boolean wasDereferenced() {
            return this.loadedKey == null;
        }
    }

    static final class EntityEntry
    implements Serializable {
        LockMode lockMode;
        Status status;
        Serializable id;
        Object[] loadedState;
        Object[] deletedState;
        boolean existsInDatabase;
        Object version;
        transient ClassPersister persister;
        String className;
        boolean isBeingReplicated;

        EntityEntry(Status status, Object[] loadedState, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, ClassPersister persister, boolean disableVersionIncrement) {
            this.status = status;
            this.loadedState = loadedState;
            this.id = id;
            this.existsInDatabase = existsInDatabase;
            this.version = version;
            this.lockMode = lockMode;
            this.isBeingReplicated = disableVersionIncrement;
            this.persister = persister;
            if (persister != null) {
                this.className = persister.getClassName();
            }
        }
    }

    static interface Executable {
        public void beforeExecutions() throws HibernateException;

        public void execute() throws HibernateException;

        public void afterTransactionCompletion(boolean var1) throws HibernateException;

        public Serializable[] getPropertySpaces();
    }

    static final class Status
    implements Serializable {
        private String name;

        Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.name.equals(LOADED.name)) {
                return LOADED;
            }
            if (this.name.equals(DELETED.name)) {
                return DELETED;
            }
            if (this.name.equals(GONE.name)) {
                return GONE;
            }
            if (this.name.equals(LOADING.name)) {
                return LOADING;
            }
            throw new InvalidObjectException("invalid Status");
        }
    }
}

