/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import net.java.sen.CToken;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Node {
    private static Log log;
    public CToken token = null;
    public Node prev = null;
    public Node next = null;
    public Node lnext = null;
    public Node rnext = null;
    public char[] surface = null;
    public String termInfo = null;
    public int begin = 0;
    public int length = 0;
    public int end = 0;
    public int cost = 0;
    public int id = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.java.sen.Node");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public int start() {
        return this.begin;
    }

    public int end() {
        return this.begin + this.length;
    }

    public int length() {
        return this.length;
    }

    public String getPos() {
        int cnt = 0;
        if (this.termInfo == null) {
            return null;
        }
        if (this.termInfo.length() == 0) {
            log.error((Object)("feature information is null at '" + this.toString() + "'."));
            log.error((Object)("token id = " + this.token.posID));
            log.error((Object)("token rcAttr2 = " + this.token.rcAttr2));
            log.error((Object)("token rcAttr1 = " + this.token.rcAttr1));
            log.error((Object)("token lcAttr = " + this.token.lcAttr));
            log.error((Object)("token length = " + this.token.length));
            log.error((Object)("token cost = " + this.token.cost));
            return null;
        }
        while (this.termInfo.charAt(cnt++) != ',') {
        }
        if (this.termInfo.charAt(cnt) != '*') {
            while (this.termInfo.charAt(cnt++) != ',') {
            }
            if (this.termInfo.charAt(cnt) != '*') {
                while (this.termInfo.charAt(cnt++) != ',') {
                }
                if (this.termInfo.charAt(cnt) != '*') {
                    while (this.termInfo.charAt(cnt++) != ',') {
                    }
                }
            }
        }
        return this.termInfo.substring(0, cnt - 1).replace(',', '-');
    }

    public String getBasicString() {
        int cnt = 0;
        if (this.termInfo == null) {
            return this.toString();
        }
        if (this.termInfo.length() == 0) {
            log.error((Object)("feature information is null at '" + this.toString() + "'."));
            log.error((Object)("token id = " + this.token.posID));
            log.error((Object)("token rcAttr2 = " + this.token.rcAttr2));
            log.error((Object)("token rcAttr1 = " + this.token.rcAttr1));
            log.error((Object)("token lcAttr = " + this.token.lcAttr));
            log.error((Object)("token length = " + this.token.length));
            log.error((Object)("token cost = " + this.token.cost));
            return null;
        }
        log.debug((Object)("posInfo=" + this.termInfo));
        int i = 0;
        while (i < 6) {
            while (this.termInfo.charAt(cnt++) != ',') {
            }
            ++i;
        }
        int begin = cnt;
        while (this.termInfo.charAt(cnt) != ',') {
            ++cnt;
        }
        return this.termInfo.substring(begin, cnt);
    }

    protected void clear() {
        this.token = null;
        this.prev = null;
        this.next = null;
        this.lnext = null;
        this.rnext = null;
        this.surface = null;
        this.termInfo = null;
        this.begin = 0;
        this.length = 0;
        this.end = 0;
        this.cost = 0;
        this.id = 0;
    }

    protected void copy(Node org) {
        this.token = org.token;
        this.prev = org.prev;
        this.next = org.next;
        this.lnext = org.lnext;
        this.rnext = org.rnext;
        this.surface = org.surface;
        this.termInfo = org.termInfo;
        this.begin = org.begin;
        this.length = org.length;
        this.end = org.end;
        this.cost = org.cost;
        this.id = org.id;
    }

    public String toString() {
        if (this.surface != null) {
            return new String(this.surface, this.begin, this.length);
        }
        return null;
    }

    public String getReading() {
        if (this.termInfo == null || this.termInfo.length() == 0) {
            return null;
        }
        int begin = this.getFieldBegin(7);
        int end = this.getFieldBegin(8);
        return this.termInfo.substring(begin, end - 1);
    }

    public String getPronunciation() {
        if (this.termInfo == null || this.termInfo.length() == 0) {
            return null;
        }
        int begin = this.getFieldBegin(8);
        int end = this.termInfo.length();
        return this.termInfo.substring(begin, end);
    }

    private int getFieldBegin(int pos) {
        int cnt = 0;
        int ptr = 0;
        while (cnt < pos && ptr < this.termInfo.length()) {
            if (this.termInfo.charAt(ptr++) != ',') continue;
            ++cnt;
        }
        if (cnt != pos) {
            return -1;
        }
        return ptr++;
    }
}

